/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.runtime.installer.config.ComponentNodeConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LauncherConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nanoxml.XMLElement;

public class ComponentConfig
extends ComponentNodeConfig {
    private boolean includesAll;
    private boolean mandatory;
    private boolean downloaded;
    private List locations = new ArrayList();
    private List dependencies = new ArrayList();
    private Set dependencyOrigins = new HashSet();

    public static String getUninstallerFilename() {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        List list = installerConfig.getLaunchers();
        for (int i = 0; i < list.size(); ++i) {
            LauncherConfig launcherConfig = (LauncherConfig)list.get(i);
            if (!launcherConfig.isUninstaller()) continue;
            return launcherConfig.getFile();
        }
        return "";
    }

    public static boolean isIncludedInSelectedComponents(String string) {
        String string2;
        string = string.replace('\\', '/');
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (installerConfig.getType().equals("macos") && installerConfig.getMacSpecificConfig().isSingleBundle()) {
            string2 = installerConfig.getMacSpecificConfig().getRuntimeDirParent().trim();
            if (string.startsWith(string2)) {
                string = string.substring(string2.length());
            } else {
                return true;
            }
        }
        if (string.startsWith(".install4j")) {
            return true;
        }
        string2 = ComponentConfig.getUninstallerFilename().trim();
        if (string2 != null && string2.length() > 0 && (string.equals(string2) || string.startsWith(string2 + ".app"))) {
            return true;
        }
        List list = installerConfig.getComponents();
        if (list.size() == 0) {
            return true;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ComponentConfig componentConfig = (ComponentConfig)iterator.next();
            if (!componentConfig.isSelected()) continue;
            if (componentConfig.isIncludesAll()) {
                return true;
            }
            if (!ComponentConfig.isIncludedInComponent(string, componentConfig)) continue;
            return true;
        }
        return false;
    }

    private static boolean isIncludedInComponent(String string, ComponentConfig componentConfig) {
        Iterator iterator = componentConfig.getLocations().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!ComponentConfig.isEqualOrContained(string2, string) && (!InstallerUtil.isMacOS() || !ComponentConfig.isEqualOrContained(string2 + ".app", string))) continue;
            return true;
        }
        return false;
    }

    private static boolean isEqualOrContained(String string, String string2) {
        return string.equals(string2) || string2.startsWith(string + "/");
    }

    public ComponentConfig(ComponentNodeConfig componentNodeConfig) {
        super(componentNodeConfig);
    }

    public boolean isIncludesAll() {
        return this.includesAll;
    }

    public boolean isSelected() {
        return super.isSelected() || this.dependencyOrigins.size() > 0;
    }

    public void setSelected(boolean bl) {
        super.setSelected(bl);
        this.notifyDependentComponents(InstallerConfig.getCurrentInstance());
    }

    public void notifyDependentComponents(InstallerConfig installerConfig) {
        Iterator iterator = this.dependencies.iterator();
        while (iterator.hasNext()) {
            ComponentConfig componentConfig = installerConfig.getComponentById((String)iterator.next());
            if (componentConfig == null) continue;
            if (this.isSelected()) {
                componentConfig.addDependencyOrigin(this, installerConfig);
                continue;
            }
            componentConfig.removeDependencyOrigin(this, installerConfig);
        }
    }

    private void addDependencyOrigin(ComponentConfig componentConfig, InstallerConfig installerConfig) {
        this.dependencyOrigins.add(componentConfig);
        this.notifyDependentComponents(installerConfig);
    }

    private void removeDependencyOrigin(ComponentConfig componentConfig, InstallerConfig installerConfig) {
        this.dependencyOrigins.remove(componentConfig);
        this.notifyDependentComponents(installerConfig);
    }

    public boolean isMandatory() {
        return this.mandatory || this.dependencyOrigins.size() > 0;
    }

    public boolean isDownloaded() {
        return this.downloaded;
    }

    public List getLocations() {
        return this.locations;
    }

    public List getDependencies() {
        return this.dependencies;
    }

    protected void read(XMLElement xMLElement) {
        super.read(xMLElement);
        this.includesAll = ComponentConfig.readAttribute(xMLElement, "allIncluded", this.includesAll);
        this.mandatory = ComponentConfig.readAttribute(xMLElement, "mandatory", this.mandatory);
        this.downloaded = ComponentConfig.readAttribute(xMLElement, "downloaded", this.downloaded);
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            String string;
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            String string2 = xMLElement2.getName();
            if (string2.equals("entry")) {
                string = ComponentConfig.readAttribute(xMLElement2, "location", "").replace('\\', '/');
                this.locations.add(string);
                continue;
            }
            if (!string2.equals("dependsOn")) continue;
            string = ComponentConfig.readAttribute(xMLElement2, "id", "");
            this.dependencies.add(string);
        }
    }

    public String toString() {
        return this.getName() + "[" + this.getId() + "]; Selected: " + this.isSelected();
    }
}

