/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util.hashmap;

import com.sosnoski.util.hashmap.ObjectKeyBase;

public class StringIntHashMap
extends ObjectKeyBase {
    public static final int DEFAULT_NOT_FOUND = Integer.MIN_VALUE;
    protected String[] m_keyTable;
    protected int[] m_valueTable;
    protected int m_notFoundValue;
    static /* synthetic */ Class class$java$lang$String;

    public StringIntHashMap(int n, double d, int n2, Object object) {
        super(n, d, class$java$lang$String == null ? (class$java$lang$String = StringIntHashMap.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, object);
        this.m_notFoundValue = n2;
    }

    public StringIntHashMap(int n, double d) {
        this(n, d, Integer.MIN_VALUE, (Object)"base");
    }

    public StringIntHashMap(int n, Object object) {
        this(n, 0.3, Integer.MIN_VALUE, object);
    }

    public StringIntHashMap(int n) {
        this(n, 0.3);
    }

    public StringIntHashMap(Object object) {
        this(0, 0.3, Integer.MIN_VALUE, object);
    }

    public StringIntHashMap() {
        this(0, 0.3);
    }

    public StringIntHashMap(StringIntHashMap stringIntHashMap) {
        super(stringIntHashMap);
        this.m_notFoundValue = stringIntHashMap.m_notFoundValue;
    }

    protected final Object[] getKeyArray() {
        return this.m_keyTable;
    }

    protected final void setKeyArray(Object object) {
        this.m_keyTable = (String[])object;
    }

    protected final Object getValueArray() {
        return this.m_valueTable;
    }

    protected final void setValueArray(Object object) {
        this.m_valueTable = (int[])object;
    }

    protected final boolean reinsert(int n) {
        String string = this.m_keyTable[n];
        this.m_keyTable[n] = null;
        return this.assignSlot(string, this.m_valueTable[n]) != n;
    }

    protected void restructure(Object object, Object object2) {
        String[] stringArray = (String[])object;
        int[] nArray = (int[])object2;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                this.assignSlot(stringArray[n], nArray[n]);
            }
            ++n;
        }
    }

    protected int assignSlot(String string, int n) {
        int n2 = this.freeSlot(this.standardSlot(string));
        this.m_keyTable[n2] = string;
        this.m_valueTable[n2] = n;
        return n2;
    }

    public int add(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("null key not supported");
        }
        if (n == this.m_notFoundValue) {
            throw new IllegalArgumentException("value matching not found return not supported");
        }
        this.ensureCapacity(this.m_entryCount + 1);
        int n2 = this.standardFind(string);
        if (n2 >= 0) {
            int n3 = this.m_valueTable[n2];
            this.m_valueTable[n2] = n;
            return n3;
        }
        ++this.m_entryCount;
        n2 = -n2 - 1;
        this.m_keyTable[n2] = string;
        this.m_valueTable[n2] = n;
        return this.m_notFoundValue;
    }

    public final boolean containsKey(String string) {
        return this.standardFind(string) >= 0;
    }

    public final int get(String string) {
        int n = this.standardFind(string);
        if (n >= 0) {
            return this.m_valueTable[n];
        }
        return this.m_notFoundValue;
    }

    public int remove(String string) {
        int n = this.standardFind(string);
        if (n >= 0) {
            int n2 = this.m_valueTable[n];
            this.internalRemove(n);
            return n2;
        }
        return this.m_notFoundValue;
    }

    public Object clone() {
        return new StringIntHashMap(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

