/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf;

import com.sun.glf.CompositeRenderer;
import com.sun.glf.FillRenderer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.Position;
import com.sun.glf.Renderer;
import com.sun.glf.StrokeRenderer;
import com.sun.glf.util.CompositionComponent;
import com.sun.glf.util.Glyph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;

public class ShapeLayer
extends Layer {
    protected Renderer renderer;
    protected Shape shape;

    public ShapeLayer(LayerComposition layerComposition, Shape shape, Renderer renderer) {
        this(layerComposition, shape, renderer, null);
    }

    public ShapeLayer(LayerComposition layerComposition, Shape shape, Renderer renderer, Position position) {
        super(layerComposition);
        if (shape == null || renderer == null) {
            throw new IllegalArgumentException();
        }
        this.renderer = renderer;
        this.shape = shape;
        if (position != null) {
            this.setTransform(position.getTransform(shape, layerComposition.getBounds()));
        }
    }

    public Shape getShape() {
        return new GeneralPath(this.shape);
    }

    public Shape createTransformedShape() {
        if (this.transform == null) {
            return new GeneralPath(this.shape);
        }
        return this.transform.createTransformedShape(this.shape);
    }

    public void paint(Graphics2D graphics2D) {
        this.renderer.render(graphics2D, this.shape);
    }

    public Rectangle2D getBounds() {
        Rectangle2D rectangle2D = this.shape.getBounds2D();
        Dimension2D dimension2D = this.renderer.getMargins();
        rectangle2D.setRect(rectangle2D.getX() - dimension2D.getWidth(), rectangle2D.getY() - dimension2D.getHeight(), rectangle2D.getWidth() + 2.0 * dimension2D.getWidth(), rectangle2D.getHeight() + 2.0 * dimension2D.getHeight());
        return rectangle2D;
    }

    public static void main(String[] stringArray) {
        Glyph glyph = new Glyph(new Font("serif", 1, 80), '@');
        Shape shape = glyph.getShape();
        Rectangle rectangle = shape.getBounds();
        Dimension dimension = new Dimension(rectangle.width + 10, rectangle.height + 10);
        Rectangle rectangle2 = new Rectangle(0, 0, dimension.width, dimension.height);
        shape = Position.CENTER.createTransformedShape(shape, rectangle2);
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        final JFrame jFrame = new JFrame("ShapeLayer unit testing");
        jFrame.getContentPane().setBackground(Color.white);
        jFrame.getContentPane().setLayout(new GridLayout(0, 1));
        CompositionComponent compositionComponent = null;
        LayerComposition layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        FillRenderer fillRenderer = new FillRenderer(new Color(128, 0, 0));
        ShapeLayer shapeLayer = new ShapeLayer(layerComposition, shape, fillRenderer);
        layerComposition.setLayers(new Layer[]{shapeLayer});
        compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText("ShapeLayer with FillRenderer");
        jFrame.getContentPane().add(compositionComponent);
        layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        StrokeRenderer strokeRenderer = new StrokeRenderer((Paint)Color.black, 4.0f);
        shapeLayer = new ShapeLayer(layerComposition, shape, strokeRenderer);
        layerComposition.setLayers(new Layer[]{shapeLayer});
        compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText("ShapeLayer with StrokeRenderer (BasicStroke)");
        jFrame.getContentPane().add(compositionComponent);
        layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        CompositeRenderer compositeRenderer = new CompositeRenderer(new Renderer[]{fillRenderer, strokeRenderer});
        shapeLayer = new ShapeLayer(layerComposition, shape, compositeRenderer);
        layerComposition.setLayers(new Layer[]{shapeLayer});
        compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText("ShapeLayer with CompositeRenderer (fill and stroke)");
        jFrame.getContentPane().add(compositionComponent);
        jFrame.pack();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jFrame.setVisible(false);
                jFrame.dispose();
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
    }
}

