/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.demos;

import com.sun.glf.Anchor;
import com.sun.glf.Composition;
import com.sun.glf.FillRenderer;
import com.sun.glf.ImageLayer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.Position;
import com.sun.glf.ShapeLayer;
import com.sun.glf.StrokeRenderer;
import com.sun.glf.TextAlignment;
import com.sun.glf.TextLayer;
import com.sun.glf.goodies.BumpTransform;
import com.sun.glf.goodies.ColorComposite;
import com.sun.glf.goodies.CompositeStroke;
import com.sun.glf.goodies.DirectionalLight;
import com.sun.glf.goodies.ElevationMap;
import com.sun.glf.goodies.GaussianKernel;
import com.sun.glf.goodies.LightOp;
import com.sun.glf.goodies.LitSurface;
import com.sun.glf.goodies.LitSurfaceType;
import com.sun.glf.goodies.RadialGradientPaintExt;
import com.sun.glf.goodies.ShapeStroke;
import com.sun.glf.util.CompositionFactory;
import com.sun.glf.util.Glyph;
import com.sun.glf.util.LightsStudio;
import com.sun.glf.util.Toolbox;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.RescaleOp;
import java.io.File;

public class GLFWebDemoTwo
implements CompositionFactory {
    Dimension size = new Dimension(600, 400);
    File backgroundImageFile = new File("");
    String text = "Java 2D is Gold";
    Font textFont = new Font("SunSansCondensed-Heavy", 0, 140);
    int blurRadius = 12;
    int textShadowOffsetX = 10;
    int textShadowOffsetY = 10;
    int embossBlurRadius = 12;
    boolean whiteIsHigh = true;
    int heightScale = 10;
    Anchor lightAnchor = Anchor.TOP;
    float lightIntensity = 2.0f;
    Color lightColor = Color.white;
    float backgroundRescale = 1.5f;
    Glyph borderGlyph = new Glyph(new Font("serif", 0, 50), '@');
    Color borderColor = Color.orange;
    String centerText = "GLF";
    Font centerTextFont = new Font("SunSansCondensed-Heavy", 0, 140);

    public String getCenterText() {
        return this.centerText;
    }

    public void setCenterText(String string) {
        this.centerText = string;
    }

    public Font getCenterTextFont() {
        return this.centerTextFont;
    }

    public void setCenterTextFont(Font font) {
        this.centerTextFont = font;
    }

    public Glyph getBorderGlyph() {
        return this.borderGlyph;
    }

    public void setBorderGlyph(Glyph glyph) {
        this.borderGlyph = glyph;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public float getBackgroundRescale() {
        return this.backgroundRescale;
    }

    public void setBackgroundRescale(float f) {
        this.backgroundRescale = f;
    }

    public float getLightIntensity() {
        return this.lightIntensity;
    }

    public void setLightIntensity(float f) {
        this.lightIntensity = f;
    }

    public Color getLightColor() {
        return this.lightColor;
    }

    public void setLightColor(Color color) {
        this.lightColor = color;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension dimension) {
        this.size = dimension;
    }

    public File getBackgroundImageFile() {
        return this.backgroundImageFile;
    }

    public void setBackgroundImageFile(File file) {
        this.backgroundImageFile = file;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
    }

    public int getBlurRadius() {
        return this.blurRadius;
    }

    public void setBlurRadius(int n) {
        this.blurRadius = n;
    }

    public int getTextShadowOffsetX() {
        return this.textShadowOffsetX;
    }

    public void setTextShadowOffsetX(int n) {
        this.textShadowOffsetX = n;
    }

    public int getTextShadowOffsetY() {
        return this.textShadowOffsetY;
    }

    public void setTextShadowOffsetY(int n) {
        this.textShadowOffsetY = n;
    }

    public int getEmbossBlurRadius() {
        return this.embossBlurRadius;
    }

    public void setEmbossBlurRadius(int n) {
        this.embossBlurRadius = n;
    }

    public boolean isWhiteIsHigh() {
        return this.whiteIsHigh;
    }

    public void setWhiteIsHigh(boolean bl) {
        this.whiteIsHigh = bl;
    }

    public int getHeightScale() {
        return this.heightScale;
    }

    public void setHeightScale(int n) {
        this.heightScale = n;
    }

    public Anchor getLightAnchor() {
        return this.lightAnchor;
    }

    public void setLightAnchor(Anchor anchor) {
        this.lightAnchor = anchor;
    }

    public Composition build() {
        LayerComposition layerComposition = new LayerComposition(this.size);
        BufferedImage bufferedImage = Toolbox.loadImage(this.backgroundImageFile, 10);
        if (bufferedImage == null) {
            throw new Error("Could not load : " + this.backgroundImageFile);
        }
        ImageLayer imageLayer = new ImageLayer(layerComposition, bufferedImage, Position.CENTER);
        RescaleOp rescaleOp = new RescaleOp(this.backgroundRescale, 0.0f, null);
        imageLayer.setImageFilter(rescaleOp);
        Shape shape = this.borderGlyph.getShape();
        Rectangle rectangle = shape.getBounds();
        ShapeStroke shapeStroke = new ShapeStroke(new Shape[]{shape}, (float)rectangle.width * 1.2f);
        Rectangle rectangle2 = new Rectangle(rectangle.width, rectangle.height, this.size.width - 2 * rectangle.width, this.size.height - 2 * rectangle.height);
        ShapeLayer shapeLayer = new ShapeLayer(layerComposition, rectangle2, new StrokeRenderer((Paint)this.borderColor, shapeStroke));
        shapeLayer.setComposite(ColorComposite.Hs);
        CompositeStroke compositeStroke = new CompositeStroke(shapeStroke, new BasicStroke());
        ShapeLayer shapeLayer2 = new ShapeLayer(layerComposition, rectangle2, new StrokeRenderer((Paint)this.borderColor, compositeStroke));
        Shape shape2 = TextLayer.makeTextBlock(this.text, this.textFont, -1.0f, TextAlignment.CENTER);
        int n = shape2.getBounds().height;
        int n2 = shape2.getBounds().width;
        BumpTransform bumpTransform = new BumpTransform((float)Math.PI * 2);
        shape2 = bumpTransform.transform(shape2);
        Shape shape3 = TextLayer.makeTextBlock(this.centerText, this.centerTextFont, -1.0f, TextAlignment.CENTER);
        shape3 = Position.CENTER.createTransformedShape(shape3, shape2.getBounds());
        GeneralPath generalPath = new GeneralPath(shape2);
        generalPath.append(shape3, false);
        shape2 = generalPath;
        shape2 = Position.CENTER.createTransformedShape(shape2, layerComposition.getBounds());
        ShapeLayer shapeLayer3 = new ShapeLayer(layerComposition, shape2, new FillRenderer(Color.black));
        ConvolveOp convolveOp = new ConvolveOp(new GaussianKernel(this.blurRadius));
        Dimension dimension = new Dimension(this.blurRadius * 2, this.blurRadius * 2);
        shapeLayer3.setImageFilter(convolveOp, dimension);
        shapeLayer3.setTransform(AffineTransform.getTranslateInstance(this.textShadowOffsetX, this.textShadowOffsetY));
        Color[] colorArray = new Color[]{Color.white, Color.white, new Color(235, 212, 19), new Color(180, 143, 29)};
        Rectangle rectangle3 = shape2.getBounds();
        float[] fArray = new float[]{(float)n2 / ((float)Math.PI * 2) - (float)n, (float)n / 3.0f, (float)n / 2.0f};
        RadialGradientPaintExt radialGradientPaintExt = new RadialGradientPaintExt(rectangle3, colorArray, fArray);
        ShapeLayer shapeLayer4 = new ShapeLayer(layerComposition, layerComposition.getBounds(), new FillRenderer(radialGradientPaintExt));
        shapeLayer4.setLayerMask(shape2);
        ElevationMap elevationMap = new ElevationMap(shape2, this.embossBlurRadius, this.whiteIsHigh, this.heightScale);
        LitSurface litSurface = new LitSurface(0.0, LitSurfaceType.METALLIC, elevationMap);
        DirectionalLight directionalLight = LightsStudio.getSunLight(this.lightAnchor, this.lightIntensity, this.lightColor);
        litSurface.addLight(directionalLight);
        LightOp lightOp = new LightOp(litSurface);
        shapeLayer4.setRasterFilter(lightOp);
        Layer[] layerArray = new Layer[]{imageLayer, shapeLayer, shapeLayer2, shapeLayer3, shapeLayer4};
        layerComposition.setLayers(layerArray);
        layerComposition.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return layerComposition;
    }
}

