/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.Anchor;
import com.sun.glf.Position;
import com.sun.glf.TextAlignment;
import com.sun.glf.TextLayer;
import com.sun.glf.goodies.GaussianKernel;
import java.awt.AlphaComposite;
import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferByte;
import java.io.File;

public class ElevationMap {
    static final int NORM = 1024;
    int w;
    int h;
    int[][] normal;
    private int[] flatNormal = new int[]{0, 0, 1024};
    private int anchorX = 0;
    private int anchorY = 0;
    private boolean cyclic = true;
    static final String USAGE = "java com.sun.glf.goodies.ElevationMap <imageName>|<string>";

    public ElevationMap(Shape shape, int n, boolean bl, int n2) {
        this(shape, shape.getBounds(), Anchor.CENTER, 0.0f, 0.0f, n, bl, n2);
    }

    public ElevationMap(Shape shape, Rectangle rectangle, Anchor anchor, float f, float f2, int n, boolean bl, int n2) {
        Rectangle rectangle2 = (Rectangle)rectangle.clone();
        rectangle2.x = 0;
        rectangle2.y = 0;
        Position position = new Position(anchor, f, f2);
        AffineTransform affineTransform = position.getTransform(shape.getBounds(), rectangle2);
        rectangle2.width += 2 * n;
        rectangle2.height += 2 * n;
        AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(n, n);
        affineTransform2.concatenate(affineTransform);
        BufferedImage bufferedImage = new BufferedImage(rectangle2.width, rectangle2.height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setPaint(Color.black);
        graphics2D.fillRect(0, 0, rectangle2.width, rectangle2.height);
        graphics2D.transform(affineTransform2);
        graphics2D.setPaint(Color.white);
        graphics2D.fill(shape);
        GaussianKernel gaussianKernel = new GaussianKernel(n);
        ConvolveOp convolveOp = new ConvolveOp(gaussianKernel, 1, null);
        BufferedImage bufferedImage2 = convolveOp.filter(bufferedImage, null);
        graphics2D.dispose();
        graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, rectangle2.width, rectangle2.height);
        graphics2D.transform(affineTransform2);
        graphics2D.setPaint(Color.white);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.fill(shape);
        graphics2D.setTransform(new AffineTransform());
        graphics2D.setComposite(AlphaComposite.SrcIn);
        graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
        graphics2D.setComposite(AlphaComposite.DstOver);
        graphics2D.setPaint(Color.black);
        graphics2D.fillRect(0, 0, rectangle2.width, rectangle2.height);
        this.createMap(bufferedImage.getSubimage(n, n, rectangle2.width - 2 * n, rectangle2.height - 2 * n), bl, n2);
        this.setAnchorPoint(new Point(rectangle.x, rectangle.y));
    }

    public static BufferedImage makeTexture(Shape shape, int n) {
        return ElevationMap.makeTexture(shape, shape.getBounds(), Anchor.CENTER, 0.0f, 0.0f, n);
    }

    public static BufferedImage makeTexture(Shape shape, Rectangle rectangle, Anchor anchor, float f, float f2, int n) {
        Rectangle rectangle2 = (Rectangle)rectangle.clone();
        rectangle2.x = 0;
        rectangle2.y = 0;
        Position position = new Position(anchor, f, f2);
        AffineTransform affineTransform = position.getTransform(shape.getBounds(), rectangle2);
        rectangle2.width += 2 * n;
        rectangle2.height += 2 * n;
        AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(n, n);
        affineTransform2.concatenate(affineTransform);
        BufferedImage bufferedImage = new BufferedImage(rectangle2.width, rectangle2.height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setPaint(Color.black);
        graphics2D.fillRect(0, 0, rectangle2.width, rectangle2.height);
        graphics2D.transform(affineTransform2);
        graphics2D.setPaint(Color.white);
        graphics2D.fill(shape);
        GaussianKernel gaussianKernel = new GaussianKernel(n);
        ConvolveOp convolveOp = new ConvolveOp(gaussianKernel, 1, null);
        BufferedImage bufferedImage2 = convolveOp.filter(bufferedImage, null);
        graphics2D.dispose();
        graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, rectangle2.width, rectangle2.height);
        graphics2D.transform(affineTransform2);
        graphics2D.setPaint(Color.white);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.fill(shape);
        graphics2D.setTransform(new AffineTransform());
        graphics2D.setComposite(AlphaComposite.SrcIn);
        graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
        graphics2D.setComposite(AlphaComposite.DstOver);
        graphics2D.setPaint(Color.black);
        graphics2D.fillRect(0, 0, rectangle2.width, rectangle2.height);
        return bufferedImage.getSubimage(n, n, rectangle2.width - 2 * n, rectangle2.height - 2 * n);
    }

    public ElevationMap(BufferedImage bufferedImage, boolean bl, int n) {
        this.createMap(bufferedImage, bl, n);
    }

    public void setAnchorPoint(Point point) {
        point.x %= this.w;
        point.y %= this.h;
        this.anchorX = point.x > 0 ? point.x - this.w : point.x;
        this.anchorY = point.y > 0 ? point.y - this.h : point.y;
    }

    public Point getAnchorPoint() {
        return new Point(this.anchorX, this.anchorY);
    }

    private final void createMap(BufferedImage object, boolean bl, int n) {
        int n2;
        Object object2;
        this.w = ((BufferedImage)object).getWidth();
        this.h = ((BufferedImage)object).getHeight();
        int n3 = 0;
        double d = 0.0;
        if (((BufferedImage)object).getType() != 10) {
            object2 = new BufferedImage(((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight(), 10);
            Graphics2D graphics2D = ((BufferedImage)object2).createGraphics();
            graphics2D.drawImage((Image)object, 0, 0, null);
            object = object2;
        }
        object2 = ((DataBufferByte)((BufferedImage)object).getRaster().getDataBuffer()).getData();
        int n4 = bl ? 1 : -1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = n4 * n;
        this.normal = new int[this.w * this.h][3];
        int n9 = 65025;
        int n10 = 4 * n9;
        n3 = 0;
        n5 = n8 * ((object2[1] & 0xFF) - (object2[0] & 0xFF));
        n6 = n8 * ((object2[this.w] & 0xFF) - (object2[0] & 0xFF));
        n7 = n5 * n5 + n6 * n6 + n9;
        d = Math.sqrt(n7);
        this.normal[n3][0] = (int)((double)(-1024 * n5) / d);
        this.normal[n3][1] = (int)((double)(-1024 * n6) / d);
        this.normal[n3][2] = (int)(261120.0 / d);
        ++n3;
        for (n2 = 1; n2 < this.w - 1; ++n2) {
            n5 = n8 * ((object2[n3 + 1] & 0xFF) - (object2[n3 - 1] & 0xFF));
            n6 = 2 * n8 * ((object2[n3 + this.w] & 0xFF) - (object2[n3] & 0xFF));
            n7 = n5 * n5 + n6 * n6 + n10;
            d = Math.sqrt(n7);
            this.normal[n3][0] = (int)((double)(-1024 * n5) / d);
            this.normal[n3][1] = (int)((double)(-1024 * n6) / d);
            this.normal[n3][2] = (int)(522240.0 / d);
            ++n3;
        }
        n5 = n8 * ((object2[n3] & 0xFF) - (object2[n3 - 1] & 0xFF));
        n6 = n8 * ((object2[n3 + this.w] & 0xFF) - (object2[n3] & 0xFF));
        n7 = n5 * n5 + n6 * n6 + n9;
        d = Math.sqrt(n7);
        this.normal[n3][0] = (int)((double)(-1024 * n5) / d);
        this.normal[n3][1] = (int)((double)(-1024 * n6) / d);
        this.normal[n3][2] = (int)(261120.0 / d);
        ++n3;
        for (n2 = 1; n2 < this.h - 1; ++n2) {
            n5 = 2 * n8 * ((object2[n3 + 1] & 0xFF) - (object2[n3] & 0xFF));
            n6 = n8 * ((object2[n3 + this.w] & 0xFF) - (object2[n3 - this.w] & 0xFF));
            n7 = n5 * n5 + n6 * n6 + n10;
            d = Math.sqrt(n7);
            this.normal[n3][0] = (int)((double)(-1024 * n5) / d);
            this.normal[n3][1] = (int)((double)(-1024 * n6) / d);
            this.normal[n3][2] = (int)(522240.0 / d);
            ++n3;
            for (int i = 1; i < this.w - 1; ++i) {
                n5 = n8 * ((object2[n3 + 1] & 0xFF) - (object2[n3 - 1] & 0xFF));
                n6 = n8 * ((object2[n3 + this.w] & 0xFF) - (object2[n3 - this.w] & 0xFF));
                n7 = n5 * n5 + n6 * n6 + n10;
                d = Math.sqrt(n7);
                this.normal[n3][0] = (int)((double)(-1024 * n5) / d);
                this.normal[n3][1] = (int)((double)(-1024 * n6) / d);
                this.normal[n3][2] = (int)(522240.0 / d);
                ++n3;
            }
            n5 = 2 * n8 * ((object2[n3] & 0xFF) - (object2[n3 - 1] & 0xFF));
            n6 = n8 * ((object2[n3 + this.w] & 0xFF) - (object2[n3 - this.w] & 0xFF));
            n7 = n5 * n5 + n6 * n6 + n10;
            d = Math.sqrt(n7);
            this.normal[n3][0] = (int)((double)(-1024 * n5) / d);
            this.normal[n3][1] = (int)((double)(-1024 * n6) / d);
            this.normal[n3][2] = (int)(522240.0 / d);
            ++n3;
        }
        n5 = n8 * ((object2[n3 + 1] & 0xFF) - (object2[n3] & 0xFF));
        n6 = n8 * ((object2[n3] & 0xFF) - (object2[n3 - this.w] & 0xFF));
        n7 = n5 * n5 + n6 * n6 + n9;
        d = Math.sqrt(n7);
        this.normal[n3][0] = (int)((double)(-1024 * n5) / d);
        this.normal[n3][1] = (int)((double)(-1024 * n6) / d);
        this.normal[n3][2] = (int)(261120.0 / d);
        ++n3;
        for (n2 = 1; n2 < this.w - 1; ++n2) {
            n5 = n8 * ((object2[n3 + 1] & 0xFF) - (object2[n3 - 1] & 0xFF));
            n6 = 2 * n8 * ((object2[n3] & 0xFF) - (object2[n3 - this.w] & 0xFF));
            n7 = n5 * n5 + n6 * n6 + n10;
            d = Math.sqrt(n7);
            this.normal[n3][0] = (int)((double)(-1024 * n5) / d);
            this.normal[n3][1] = (int)((double)(-1024 * n6) / d);
            this.normal[n3][2] = (int)(522240.0 / d);
            ++n3;
        }
        n5 = n8 * ((object2[n3] & 0xFF) - (object2[n3 - 1] & 0xFF));
        n6 = n8 * ((object2[n3] & 0xFF) - (object2[n3 - this.w] & 0xFF));
        n7 = n5 * n5 + n6 * n6 + n9;
        d = Math.sqrt(n7);
        this.normal[n3][0] = (int)((double)(-1024 * n5) / d);
        this.normal[n3][1] = (int)((double)(-1024 * n6) / d);
        this.normal[n3][2] = (int)(261120.0 / d);
    }

    public final int[] getNormal(int n, int n2) {
        n = (n - this.anchorX) % this.w;
        n2 = (n2 - this.anchorY) % this.h;
        int n3 = n2 * this.w + n;
        return this.normal[n3];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void main(String[] stringArray) {
        String string;
        File file;
        if (stringArray.length < 1) {
            System.out.println(USAGE);
            System.exit(0);
        }
        if ((file = new File(string = stringArray[0])).exists()) {
            BufferedImage bufferedImage;
            Image image;
            block8: {
                Button button = new Button("");
                MediaTracker mediaTracker = new MediaTracker(button);
                image = Toolkit.getDefaultToolkit().getImage(string);
                mediaTracker.addImage(image, 0);
                try {
                    try {
                        mediaTracker.waitForAll();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new Error();
                    }
                    bufferedImage = null;
                    if (!mediaTracker.isErrorAny()) break block8;
                    throw new Error("Could not load " + string + ". Check it is an image file");
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (!mediaTracker.isErrorAny()) throw throwable;
                    throw new Error("Could not load " + string + ". Check it is an image file");
                }
            }
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            bufferedImage = new BufferedImage(n, n2, 10);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            System.out.println("\nCreating elevation map from image. Size(" + n + ", " + n2 + ")");
            long l = System.currentTimeMillis();
            ElevationMap elevationMap = new ElevationMap(bufferedImage, true, 10);
            System.out.println("Processing took: " + (System.currentTimeMillis() - l) + " ms");
        } else {
            String string2 = "Times New Roman Bold";
            int n = 200;
            Font font = new Font(string2, 0, n);
            Shape shape = TextLayer.makeTextBlock(stringArray[0], font, 400.0f, TextAlignment.CENTER);
            Rectangle rectangle = shape.getBounds();
            int n3 = rectangle.width;
            int n4 = rectangle.height;
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(-rectangle.x, -rectangle.y);
            shape = (GeneralPath)affineTransform.createTransformedShape(shape);
            System.out.println("\nCreating elevation map from shape");
            long l = System.currentTimeMillis();
            ElevationMap elevationMap = new ElevationMap(shape, 10, true, 10);
            System.out.println("Processing took: " + (System.currentTimeMillis() - l) + " ms");
        }
        System.exit(0);
    }
}

