/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.Anchor;
import com.sun.glf.ImageLayer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.goodies.DirectionalLight;
import com.sun.glf.goodies.ElevationMap;
import com.sun.glf.goodies.LitSurface;
import com.sun.glf.goodies.SpotLight;
import com.sun.glf.util.CompositionComponent;
import com.sun.glf.util.LightsStudio;
import com.sun.glf.util.Toolbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class LightOp
implements BufferedImageOp,
RasterOp {
    private static ColorModel xrgbCM = new DirectColorModel(24, 0xFF0000, 65280, 255);
    private static ColorModel srgbCM = ColorModel.getRGBdefault();
    private static final double I0 = 0.1;
    private LitSurface litSurface;
    static final String USAGE = "java com.sun.glf.goodies.LightOp [<textureFile>]";

    public LightOp(LitSurface litSurface) {
        if (litSurface == null) {
            throw new IllegalArgumentException();
        }
        this.litSurface = litSurface;
    }

    public WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        this.checkCompatible(raster.getSampleModel());
        if (writableRaster != null) {
            this.checkCompatible(writableRaster.getSampleModel());
        } else {
            writableRaster = this.createCompatibleDestRaster(raster);
        }
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n3 = dataBufferInt.getOffset();
        int n4 = dataBufferInt2.getOffset();
        int n5 = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int n6 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int[] nArray = dataBufferInt.getBankData()[0];
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        int n7 = n5 - n;
        int n8 = n6 - n;
        int n9 = raster.getMinX();
        int n10 = raster.getMinY();
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        boolean bl = false;
        int n14 = n3;
        int n15 = n4;
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0, 0.0};
        double d = 256.0 / Math.log(0.1);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        if (this.litSurface.isTextured()) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    n19 = nArray[n14];
                    n11 = n19 >> 16 & 0xFF;
                    n12 = n19 >> 8 & 0xFF;
                    n13 = n19 & 0xFF;
                    this.litSurface.getTexturedIntensity(j + n9, i + n10, dArray, dArray2);
                    d2 = d * Math.log(dArray[0]);
                    d3 = d * Math.log(dArray[1]);
                    d4 = d * Math.log(dArray[2]);
                    int n20 = d2 % 1.0 > 0.5 ? (d2 > 0.0 ? (int)d2 + 1 : (int)d2 - 1) : (n16 = (int)d2);
                    int n21 = d3 % 1.0 > 0.5 ? (d3 > 0.0 ? (int)d3 + 1 : (int)d3 - 1) : (n17 = (int)d3);
                    n18 = d4 % 1.0 > 0.5 ? (d4 > 0.0 ? (int)d4 + 1 : (int)d4 - 1) : (int)d4;
                    n11 = (n11 -= n16) < 0 ? 0 : n11;
                    n11 = n11 > 255 ? 255 : n11;
                    n12 = (n12 -= n17) < 0 ? 0 : n12;
                    n12 = n12 > 255 ? 255 : n12;
                    n13 = (n13 -= n18) < 0 ? 0 : n13;
                    n13 = n13 > 255 ? 255 : n13;
                    nArray2[n15] = n19 & 0xFF000000 | n11 << 16 & 0xFF0000 | n12 << 8 & 0xFF00 | n13 & 0xFF;
                    ++n15;
                    ++n14;
                }
                n15 += n8;
                n14 += n7;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    n19 = nArray[n14];
                    n11 = n19 >> 16 & 0xFF;
                    n12 = n19 >> 8 & 0xFF;
                    n13 = n19 & 0xFF;
                    this.litSurface.getFlatIntensity(j + n9, i + n10, dArray, dArray2);
                    d2 = d * Math.log(dArray[0]);
                    d3 = d * Math.log(dArray[1]);
                    d4 = d * Math.log(dArray[2]);
                    int n22 = d2 % 1.0 > 0.5 ? (d2 > 0.0 ? (int)d2 + 1 : (int)d2 - 1) : (n16 = (int)d2);
                    int n23 = d3 % 1.0 > 0.5 ? (d3 > 0.0 ? (int)d3 + 1 : (int)d3 - 1) : (n17 = (int)d3);
                    n18 = d4 % 1.0 > 0.5 ? (d4 > 0.0 ? (int)d4 + 1 : (int)d4 - 1) : (int)d4;
                    n11 = (n11 -= n16) < 0 ? 0 : n11;
                    n11 = n11 > 255 ? 255 : n11;
                    n12 = (n12 -= n17) < 0 ? 0 : n12;
                    n12 = n12 > 255 ? 255 : n12;
                    n13 = (n13 -= n18) < 0 ? 0 : n13;
                    n13 = n13 > 255 ? 255 : n13;
                    nArray2[n15] = n19 & 0xFF000000 | n11 << 16 & 0xFF0000 | n12 << 8 & 0xFF00 | n13 & 0xFF;
                    ++n15;
                    ++n14;
                }
                n15 += n8;
                n14 += n7;
            }
        }
        return writableRaster;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Object object;
        BufferedImage bufferedImage3;
        if (bufferedImage == null) {
            throw new NullPointerException("src image is null");
        }
        SampleModel sampleModel = bufferedImage.getSampleModel();
        if (!this.isCompatible(sampleModel)) {
            bufferedImage3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
            object = new ColorConvertOp(null);
            ((ColorConvertOp)object).filter(bufferedImage, bufferedImage3);
            bufferedImage = bufferedImage3;
        }
        bufferedImage3 = bufferedImage2;
        if (bufferedImage2 == null) {
            bufferedImage3 = bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        } else {
            object = bufferedImage2.getSampleModel();
            if (!this.isCompatible((SampleModel)object)) {
                bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            }
        }
        this.filter(bufferedImage.getRaster(), bufferedImage2.getRaster());
        if (bufferedImage2 != bufferedImage3) {
            object = new ColorConvertOp(null);
            ((ColorConvertOp)object).filter(bufferedImage2, bufferedImage3);
        }
        return bufferedImage2;
    }

    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public Rectangle2D getBounds2D(Raster raster) {
        this.checkCompatible(raster.getSampleModel());
        return new Rectangle(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight());
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        this.checkCompatible(raster.getSampleModel());
        return raster.createCompatibleWritableRaster();
    }

    public void checkCompatible(SampleModel sampleModel) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            throw new IllegalArgumentException("LightOp only works with Rasters using SinglePixelPackedSampleModels");
        }
        int n = sampleModel.getNumBands();
        if (n < 3 || n > 4) {
            throw new IllegalArgumentException("LightOp only words with Rasters having 3 or 4 bands");
        }
        if (sampleModel.getDataType() != 3) {
            throw new IllegalArgumentException("LightOp only works with Rasters using DataBufferInts");
        }
        int[] nArray = ((SinglePixelPackedSampleModel)sampleModel).getBitOffsets();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] % 8 == 0) continue;
            throw new IllegalArgumentException("LightOp only works with Rasters using 8 bits per band : " + i + " : " + nArray[i]);
        }
    }

    public boolean isCompatible(SampleModel sampleModel) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        int n = sampleModel.getNumBands();
        if (n < 3 || n > 4) {
            return false;
        }
        if (sampleModel.getDataType() != 3) {
            return false;
        }
        int[] nArray = ((SinglePixelPackedSampleModel)sampleModel).getBitOffsets();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] % 8 == 0) continue;
            return false;
        }
        return true;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        this.checkCompatible(bufferedImage.getSampleModel());
        BufferedImage bufferedImage2 = null;
        if (colorModel == null) {
            colorModel = bufferedImage.getColorModel();
        }
        bufferedImage2 = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight()), colorModel.isAlphaPremultiplied(), null);
        return bufferedImage2;
    }

    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Double();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public static void main(String[] stringArray) {
        Object object;
        Cloneable cloneable;
        Rectangle rectangle;
        Object object2;
        Object object3;
        if (stringArray.length < 1) {
            System.out.println(USAGE);
            System.exit(0);
        }
        String string = stringArray[0];
        JFrame jFrame = new JFrame("LightOp unit testing");
        jFrame.getContentPane().setLayout(new GridLayout(0, 1));
        BufferedImage bufferedImage = Toolbox.loadImage(string, 1);
        int n = 200;
        int n2 = 100;
        Dimension dimension = new Dimension(n, n2);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setPaint(new Color(153, 153, 204));
        graphics2D.fillRect(0, 0, n, n2);
        LitSurface litSurface = new LitSurface(0.2, 1.0, 1.0, 16, null);
        litSurface.addLight(new SpotLight(new Rectangle(0, 0, n, n2), new Color(255, 120, 120), 8.0, 0.0));
        LightOp lightOp = new LightOp(litSurface);
        BufferedImage bufferedImage3 = lightOp.filter(bufferedImage2, null);
        BufferedImage bufferedImage4 = null;
        BufferedImage bufferedImage5 = null;
        if (bufferedImage != null) {
            bufferedImage4 = new BufferedImage(bufferedImage.getWidth(null), bufferedImage.getHeight(null), 1);
            graphics2D = bufferedImage4.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            object3 = new ElevationMap(bufferedImage4, true, 10);
            litSurface = new LitSurface(0.2, 1.0, 1.0, 16, (ElevationMap)object3);
            litSurface.addLight(new SpotLight(new Rectangle(0, 0, n, n2), Color.white, 2.0, 0.0));
            lightOp = new LightOp(litSurface);
            bufferedImage5 = lightOp.filter(bufferedImage2, null);
        } else {
            object3 = new Font("Times New Roman", 1, 40);
            FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
            object2 = ((Font)object3).createGlyphVector(fontRenderContext, "&").getOutline();
            rectangle = object2.getBounds();
            cloneable = AffineTransform.getTranslateInstance(-rectangle.x, -rectangle.y);
            object2 = cloneable.createTransformedShape((Shape)object2);
            object = new ElevationMap((Shape)object2, 10, true, 10);
            litSurface = new LitSurface(0.2, 1.0, 1.0, 16, (ElevationMap)object);
            litSurface.addLight(new SpotLight(new Rectangle(0, 0, n, n2), Color.white, 2.0, 0.0));
            lightOp = new LightOp(litSurface);
            bufferedImage5 = lightOp.filter(bufferedImage2, null);
            bufferedImage4 = ElevationMap.makeTexture((Shape)object2, 10);
        }
        int n3 = bufferedImage4.getWidth();
        int n4 = bufferedImage4.getHeight();
        if (n3 > n) {
            bufferedImage4 = bufferedImage4.getSubimage(0, 0, n, n4);
        }
        if (n4 > n2) {
            bufferedImage4 = bufferedImage4.getSubimage(0, 0, n, n2);
        }
        litSurface.removeAllLights();
        litSurface.addLight(new DirectionalLight(new double[]{-40.0, -40.0, 40.0}, 0.5, Color.white));
        lightOp = new LightOp(litSurface);
        object2 = lightOp.filter(bufferedImage2, null);
        rectangle = new Rectangle(0, 0, n, n2);
        cloneable = new Dimension(n, n2);
        litSurface.addLight(LightsStudio.getSpotLight(rectangle, Anchor.TOP_LEFT, (Dimension)cloneable, 2.0, Color.yellow));
        litSurface.addLight(LightsStudio.getSpotLight(rectangle, Anchor.TOP_RIGHT, (Dimension)cloneable, 2.0, Color.green));
        litSurface.addLight(LightsStudio.getSpotLight(rectangle, Anchor.BOTTOM_LEFT, (Dimension)cloneable, 2.0, Color.red));
        litSurface.addLight(LightsStudio.getSpotLight(rectangle, Anchor.TOP_RIGHT, (Dimension)cloneable, 2.0, Color.white));
        object = lightOp.filter(bufferedImage2, null);
        jFrame.getContentPane().add(LightOp.makeNewComponent(bufferedImage2, "Original Image"));
        jFrame.getContentPane().add(LightOp.makeNewComponent(bufferedImage3, "SpotLight on flat surface"));
        jFrame.getContentPane().add(LightOp.makeNewComponent(bufferedImage4, "Elevation map used to create texture"));
        jFrame.getContentPane().add(LightOp.makeNewComponent(bufferedImage5, "WarnLlight on textured surface"));
        jFrame.getContentPane().add(LightOp.makeNewComponent((Image)object2, "DirectionalLight on textured surface"));
        jFrame.getContentPane().add(LightOp.makeNewComponent((Image)object, "WarnLigths & DirectionalLight on textured surface"));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static JComponent makeNewComponent(Image image, String string) {
        Dimension dimension = new Dimension(image.getWidth(null), image.getHeight(null));
        LayerComposition layerComposition = new LayerComposition(dimension);
        ImageLayer imageLayer = new ImageLayer(layerComposition, image, null);
        layerComposition.setLayers(new Layer[]{imageLayer});
        CompositionComponent compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText(string);
        return compositionComponent;
    }
}

