/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;

public class ShapeStroke
implements Stroke {
    private Shape[] pattern;
    private AffineTransform t = new AffineTransform();
    private float gap;
    private static final int GAP_ADJUST_LIMIT_DEFAULT = 5;
    private int gapAdjustLimit = 5;
    private static final float FLATNESS = 1.0f;
    float startCredit;

    public Shape[] getPattern() {
        Shape[] shapeArray = new Shape[this.pattern.length];
        System.arraycopy(this.pattern, 0, shapeArray, 0, this.pattern.length);
        return shapeArray;
    }

    public float getGap() {
        return this.gap;
    }

    public ShapeStroke(Shape shape, float f) {
        this(new Shape[]{shape}, f, 5);
    }

    public ShapeStroke(Shape[] shapeArray, float f) {
        this(shapeArray, f, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShapeStroke(Shape[] shapeArray, float f, int n) {
        Shape[] shapeArray2 = shapeArray;
        synchronized (shapeArray) {
            if (shapeArray == null || shapeArray.length < 1) {
                throw new IllegalArgumentException("pattern array should have at least one element");
            }
            this.gap = f;
            this.pattern = new Shape[shapeArray.length];
            System.arraycopy(shapeArray, 0, this.pattern, 0, shapeArray.length);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            for (int i = 0; i < this.pattern.length; ++i) {
                Rectangle rectangle = this.pattern[i].getBounds();
                this.t.setToTranslation(-rectangle.x - rectangle.width / 2, -rectangle.y - rectangle.height / 2);
                this.pattern[i] = this.t.createTransformedShape(this.pattern[i]);
            }
            return;
        }
    }

    public Shape createStrokedShape(Shape shape) {
        GeneralPath generalPath = new GeneralPath();
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(new AffineTransform()), 1.0);
        int n = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float[] fArray = new float[6];
        int n2 = 0;
        boolean bl = false;
        while (!flatteningPathIterator.isDone()) {
            n2 = flatteningPathIterator.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    f = fArray[0];
                    f2 = fArray[1];
                    f5 = f;
                    f6 = f2;
                    bl = true;
                    break;
                }
                case 1: {
                    f3 = fArray[0];
                    f4 = fArray[1];
                    n = this.addSegment(f, f2, f3, f4, generalPath, bl, f3 == f5 && f4 == f6, n);
                    bl = false;
                    f = f3;
                    f2 = f4;
                    break;
                }
                case 4: {
                    n = this.addSegment(f, f2, f5, f6, generalPath, bl, true, n);
                    bl = false;
                    f = f5;
                    f2 = f6;
                    break;
                }
                default: {
                    throw new Error("Illegal seg type : " + n2);
                }
            }
            flatteningPathIterator.next();
        }
        return generalPath;
    }

    private int addSegment(float f, float f2, float f3, float f4, GeneralPath generalPath, boolean bl, boolean bl2, int n) {
        float f5;
        float f6;
        if (bl) {
            this.startCredit = this.gap;
        }
        float f7 = f3 - f;
        float f8 = f4 - f2;
        if ((double)f7 != 0.0) {
            f6 = f8 / f7;
            f5 = f6 * f6;
            if (f >= f3) {
                f = (float)((double)f + (double)this.startCredit / Math.sqrt(1.0f + f5));
                f2 = (float)((double)f2 + (double)(f6 * this.startCredit) / Math.sqrt(1.0f + f5));
            } else {
                f = (float)((double)f - (double)this.startCredit / Math.sqrt(1.0f + f5));
                f2 = (float)((double)f2 - (double)(f6 * this.startCredit) / Math.sqrt(1.0f + f5));
            }
        } else {
            f2 = f4 > f2 ? (f2 -= this.startCredit) : (f2 += this.startCredit);
        }
        this.t.setToTranslation(f, f2);
        f6 = (float)Math.sqrt((f3 - f) * (f3 - f) + (f4 - f2) * (f4 - f2));
        f5 = f6 / this.gap;
        int n2 = (int)Math.floor(f5);
        float f9 = (f3 - f) / f5;
        float f10 = (f4 - f2) / f5;
        if (n2 >= this.gapAdjustLimit) {
            float f11 = 1.0f + (f5 - (float)n2) / (float)n2;
            f9 *= f11;
            f10 *= f11;
        }
        if (bl2 && n2 > 0) {
            f9 = (f3 - f) / (float)n2;
            f10 = (f4 - f2) / (float)n2;
            --n2;
        }
        for (int i = 0; i < n2; ++i) {
            this.t.translate(f9, f10);
            generalPath.append(this.t.createTransformedShape(this.pattern[n++]), false);
            n %= this.pattern.length;
        }
        this.startCredit = n2 < this.gapAdjustLimit ? this.gap * (f5 - (float)n2) : 0.0f;
        return n;
    }
}

