/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.util;

import com.sun.glf.util.ColorBox;
import com.sun.glf.util.GridBagPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorPropertyEditor
extends PropertyEditorSupport {
    static final String CHANGE = "Change ...";
    static final String CHOOSE_COLOR = "Choose Color";
    static final String TOOLTIP_SET_TRANSPARENCY = "Sets color opacity";
    GridBagPanel colorChooser;

    public String getJavaInitializationString() {
        Color color = (Color)this.getValue();
        return "new Color(" + color.getRed() + "," + color.getGreen() + ", " + color.getBlue() + ", " + color.getAlpha() + ")";
    }

    public Object getValue() {
        Color color = (Color)super.getValue();
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public Component getCustomEditor() {
        if (this.colorChooser == null) {
            this.colorChooser = new GridBagPanel();
            ColorBox colorBox = new ColorBox();
            JPanel jPanel = new JPanel(new GridLayout(1, 1, 0, 0));
            jPanel.add(colorBox);
            jPanel.setPreferredSize(new Dimension(25, 25));
            jPanel.setBorder(BorderFactory.createEtchedBorder());
            JSlider jSlider = new JSlider(0, 0, 255, 0);
            JLabel jLabel = new JLabel();
            jLabel.setHorizontalTextPosition(0);
            jLabel.setHorizontalAlignment(0);
            Dimension dimension = jSlider.getPreferredSize();
            jSlider.setPreferredSize(new Dimension(100, dimension.height));
            class ValueChangeListener
            extends MouseAdapter
            implements PropertyChangeListener,
            ChangeListener {
                private final /* synthetic */ ColorBox val$colorBox;
                private final /* synthetic */ JSlider val$transparency;
                private final /* synthetic */ JLabel val$transparencyValue;

                ValueChangeListener(ColorBox colorBox, JSlider jSlider, JLabel jLabel) {
                    this.val$colorBox = colorBox;
                    this.val$transparency = jSlider;
                    this.val$transparencyValue = jLabel;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    Color color = JColorChooser.showDialog(this.val$colorBox, ColorPropertyEditor.CHOOSE_COLOR, (Color)ColorPropertyEditor.this.getValue());
                    if (color != null) {
                        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.val$transparency.getValue());
                        ColorPropertyEditor.this.setValue(color);
                    }
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Color color = (Color)ColorPropertyEditor.this.getValue();
                    this.val$colorBox.setBackground(color);
                    this.val$transparency.setValue(color.getAlpha());
                    this.val$transparencyValue.setText("" + (int)Math.rint(100.0 * (double)color.getAlpha() / 255.0) + "%");
                    this.val$colorBox.repaint();
                    this.val$transparency.repaint();
                    this.val$transparencyValue.repaint();
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    Color color = (Color)ColorPropertyEditor.this.getValue();
                    Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.val$transparency.getValue());
                    this.val$transparencyValue.setText("" + (int)Math.rint(100.0 * (double)color2.getAlpha() / 255.0) + "%");
                    this.val$transparencyValue.repaint();
                    ColorPropertyEditor.this.setValue(color2);
                }
            }
            ValueChangeListener valueChangeListener = new ValueChangeListener(colorBox, jSlider, jLabel);
            colorBox.addMouseListener(valueChangeListener);
            this.addPropertyChangeListener(valueChangeListener);
            jSlider.addChangeListener(valueChangeListener);
            JLabel jLabel2 = new JLabel("100%");
            jLabel.setPreferredSize(jLabel2.getPreferredSize());
            this.colorChooser.add(jPanel, 0, 0, 1, 1, 10, 0, 0.0, 0.0);
            this.colorChooser.add(Box.createHorizontalStrut(5), 1, 0, 1, 1, 10, 0, 0.0, 0.0);
            this.colorChooser.add(jSlider, 2, 0, 1, 1, 10, 2, 0.0, 0.0);
            this.colorChooser.add(jLabel, 3, 0, 1, 1, 10, 2, 0.0, 0.0);
            this.colorChooser.add(Box.createHorizontalGlue(), 4, 1, 1, 1, 10, 2, 1.0, 0.0);
            jSlider.setToolTipText(TOOLTIP_SET_TRANSPARENCY);
        }
        return this.colorChooser;
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

