/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.util;

import com.sun.glf.util.PaintableEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PropertyEditorUI
extends JPanel {
    private Method getMethod;
    private Method setMethod;
    private PropertyEditor editor;
    private int editorType;
    private Component component;
    static final int EDITOR_CUSTOM = 0;
    static final int EDITOR_PAINTABLE = 1;
    static final int EDITOR_STRING = 2;

    public PropertyEditorUI(PropertyEditor propertyEditor, Method method, Method method2) {
        if (propertyEditor == null || method == null || method2 == null) {
            throw new IllegalArgumentException();
        }
        this.editor = propertyEditor;
        this.getMethod = method;
        this.setMethod = method2;
        this.editorType = propertyEditor.supportsCustomEditor() ? 0 : (propertyEditor.isPaintable() ? 1 : 2);
        switch (this.editorType) {
            case 0: {
                this.component = propertyEditor.getCustomEditor();
                break;
            }
            case 1: {
                this.component = new PaintableEditor(propertyEditor);
                break;
            }
            case 2: {
                this.component = new JTextField();
            }
        }
        this.setLayout(new BorderLayout());
        this.add(this.component);
    }

    public int getEditorType() {
        return this.editorType;
    }

    public void load(Object object) {
        try {
            Object object2 = this.getMethod.invoke(object, null);
            this.editor.setValue(object2);
            if (this.editorType == 2) {
                ((JTextField)this.component).setText(this.editor.getAsText());
            }
            this.component.repaint();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Error();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Error();
        }
    }

    public void save(Object object) throws InvocationTargetException {
        if (this.editorType == 2) {
            this.editor.setAsText(((JTextField)this.component).getText());
        }
        Object object2 = this.editor.getValue();
        try {
            this.setMethod.invoke(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Error();
        }
    }
}

