/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.ImportHandler;
import giny.model.Edge;
import giny.model.Node;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.TestCase;

public class CytoscapeTest
extends TestCase {
    CyNetwork cytoNetwork;
    String title;
    int nodeCount;
    int edgeCount;

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
        this.cytoNetwork = null;
    }

    public void testGetImportHandler() throws Exception {
        ImportHandler importHandler = Cytoscape.getImportHandler();
        CytoscapeTest.assertEquals(importHandler.getClass(), ImportHandler.class);
    }

    public void testNullNetwork() throws Exception {
        this.cytoNetwork = Cytoscape.getNullNetwork();
        this.title = this.cytoNetwork.getTitle();
        CytoscapeTest.assertEquals("0", this.title);
        this.nodeCount = this.cytoNetwork.getNodeCount();
        CytoscapeTest.assertEquals(0, this.nodeCount);
        this.edgeCount = this.cytoNetwork.getEdgeCount();
        CytoscapeTest.assertEquals(0, this.edgeCount);
    }

    public void testCreateNonexistentNetwork() throws Exception {
        try {
            this.cytoNetwork = Cytoscape.createNetworkFromFile("nonexistentNetwork");
        }
        catch (Exception e) {
            System.out.println("this is the expected exception");
            e.printStackTrace();
            CytoscapeTest.assertEquals(1, 1);
            return;
        }
        CytoscapeTest.fail("Did not catch expected exception");
    }

    public void testBug839() throws IOException {
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("n1");
        nodes.add("n2");
        nodes.add("n3");
        nodes.add("n4");
        nodes.add("n5");
        this.cytoNetwork = Cytoscape.createNetworkFromFile("testData/bug_839.sif");
        Iterator it = this.cytoNetwork.nodesIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            CytoscapeTest.assertTrue("checking node " + n.getIdentifier(), nodes.contains(n.getIdentifier()));
        }
        HashSet<String> edges = new HashSet<String>();
        edges.add(CyEdge.createIdentifier("n1", "activates", "n2"));
        edges.add(CyEdge.createIdentifier("n1", "activates", "n4"));
        edges.add(CyEdge.createIdentifier("n1", "activates", "n5"));
        edges.add(CyEdge.createIdentifier("n2", "activates", "n1"));
        edges.add(CyEdge.createIdentifier("n2", "activates", "n5"));
        edges.add(CyEdge.createIdentifier("n3", "inhibits", "n3"));
        edges.add(CyEdge.createIdentifier("n3", "inhibits", "n4"));
        edges.add(CyEdge.createIdentifier("n3", "inhibits", "n5"));
        edges.add(CyEdge.createIdentifier("n4", "activates", "n1"));
        edges.add(CyEdge.createIdentifier("n4", "activates", "n2"));
        edges.add(CyEdge.createIdentifier("n4", "activates", "n4"));
        edges.add(CyEdge.createIdentifier("n5", "activates", "n1"));
        edges.add(CyEdge.createIdentifier("n5", "activates", "n4"));
        edges.add(CyEdge.createIdentifier("n5", "activates", "n5"));
        it = this.cytoNetwork.edgesIterator();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            CytoscapeTest.assertTrue("checking edge " + e.getIdentifier(), edges.contains(e.getIdentifier()));
        }
    }

    public void testgetCyEdgeWithStrings() throws IOException {
        this.cytoNetwork = Cytoscape.createNetworkFromFile("testData/directedGraph.sif");
        CytoscapeTest.assertEquals(2, this.cytoNetwork.getNodeCount());
        CytoscapeTest.assertEquals(4, this.cytoNetwork.getEdgeCount());
        String en1 = CyEdge.createIdentifier("a", "pp", "b");
        CyEdge ce1 = Cytoscape.getCyEdge("a", en1, "b", "pp");
        CytoscapeTest.assertNotNull(ce1);
        CyEdge ce1_again = Cytoscape.getCyEdge("a", en1, "b", "pp");
        CytoscapeTest.assertTrue(ce1 == ce1_again);
        String en2 = CyEdge.createIdentifier("a", "xx", "b");
        CyEdge ce2 = Cytoscape.getCyEdge("a", en2, "b", "pp");
        CytoscapeTest.assertNotNull(ce2);
        String en3 = CyEdge.createIdentifier("b", "pp", "a");
        CyEdge ce3 = Cytoscape.getCyEdge("b", en3, "a", "pp");
        CytoscapeTest.assertTrue(ce1 != ce3);
    }

    public void testgetCyEdgeWithNodes() throws IOException {
        this.cytoNetwork = Cytoscape.createNetworkFromFile("testData/directedGraph.sif");
        CyNode a = Cytoscape.getCyNode("a");
        CyNode b = Cytoscape.getCyNode("b");
        CyNode c = Cytoscape.getCyNode("c", true);
        String attr = "interaction";
        CytoscapeTest.assertNotNull(Cytoscape.getCyEdge(a, b, attr, "pp", false, true));
        CytoscapeTest.assertNotNull(Cytoscape.getCyEdge(b, a, attr, "pp", false, true));
        CytoscapeTest.assertNotNull(Cytoscape.getCyEdge(a, a, attr, "pp", false, true));
        CytoscapeTest.assertNotNull(Cytoscape.getCyEdge(a, a, attr, "pp", false, true));
        CytoscapeTest.assertNotNull(Cytoscape.getCyEdge(a, b, attr, "pd", false, true));
        CytoscapeTest.assertNull(Cytoscape.getCyEdge(b, a, attr, "pd", false, true));
        CytoscapeTest.assertNotNull(Cytoscape.getCyEdge(b, a, attr, "pd", false, false));
        CytoscapeTest.assertNull(Cytoscape.getCyEdge(a, c, attr, "pp", false, true));
        CytoscapeTest.assertNull(Cytoscape.getCyEdge(a, b, attr, "xx", false, true));
        CytoscapeTest.assertNotNull(Cytoscape.getCyEdge(a, c, attr, "pd", true, true));
        CytoscapeTest.assertNotNull(Cytoscape.getCyEdge(a, c, attr, "pd", false, true));
    }

    public void testGetCyEdgeWithBadNodeStrings() throws Exception {
        this.cytoNetwork = Cytoscape.createNetworkFromFile("testData/directedGraph.sif");
        int numEdges = Cytoscape.getRootGraph().getEdgeCount();
        int numNodes = Cytoscape.getRootGraph().getNodeCount();
        CyEdge e1 = Cytoscape.getCyEdge("a", "missing edge name", "b", "asdfasdf");
        CytoscapeTest.assertEquals(e1.getIdentifier(), "a (asdfasdf) b");
        CytoscapeTest.assertEquals(numEdges + 1, Cytoscape.getRootGraph().getEdgeCount());
        CytoscapeTest.assertEquals(numNodes, Cytoscape.getRootGraph().getNodeCount());
        CyEdge e2 = Cytoscape.getCyEdge("missing source", "missing edge name", "b", "zz");
        CytoscapeTest.assertEquals(e2.getIdentifier(), "missing source (zz) b");
        CytoscapeTest.assertEquals(numEdges + 2, Cytoscape.getRootGraph().getEdgeCount());
        CytoscapeTest.assertEquals(numNodes + 1, Cytoscape.getRootGraph().getNodeCount());
        CyEdge e3 = Cytoscape.getCyEdge("a", "missing edge name", "missing target", "zz");
        CytoscapeTest.assertEquals(e3.getIdentifier(), "a (zz) missing target");
        CytoscapeTest.assertEquals(numEdges + 3, Cytoscape.getRootGraph().getEdgeCount());
        CytoscapeTest.assertEquals(numNodes + 2, Cytoscape.getRootGraph().getNodeCount());
        CyEdge e4 = Cytoscape.getCyEdge(null, "missing edge name", "b", "zz");
        CytoscapeTest.assertNull(e4);
        CyEdge e5 = Cytoscape.getCyEdge("a", "missing edge name", null, "zz");
        CytoscapeTest.assertNull(e5);
        CytoscapeTest.assertEquals(numEdges + 3, Cytoscape.getRootGraph().getEdgeCount());
        CytoscapeTest.assertEquals(numNodes + 2, Cytoscape.getRootGraph().getNodeCount());
    }

    public void testSetNestedNetworkAndGetNestedNetwork() throws Exception {
        CyNode node = Cytoscape.getCyNode("nestedNode", true);
        CytoscapeTest.assertNull(node.getNestedNetwork());
        CyNetwork network = Cytoscape.createNetwork("nestedTest");
        node.setNestedNetwork(network);
        CytoscapeTest.assertEquals(network, node.getNestedNetwork());
        String id = network.getIdentifier();
        CytoscapeTest.assertTrue(((CyNetwork)node.getNestedNetwork()).getIdentifier().equals(id));
    }
}

