/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.actions.DeleteAction;
import cytoscape.util.undo.CyAbstractEdit;
import cytoscape.view.CyNetworkView;
import giny.view.NodeView;

class DeleteEdit
extends CyAbstractEdit {
    private static final long serialVersionUID = -1164181258019250610L;
    int[] nodes;
    int[] edges;
    double[] xPos;
    double[] yPos;
    CyNetwork net;
    DeleteAction deleteAction;

    DeleteEdit(CyNetwork net, int[] nodeInd, int[] edgeInd) {
        super("Delete");
        int i;
        if (net == null) {
            throw new IllegalArgumentException("network is null");
        }
        this.net = net;
        this.nodes = new int[nodeInd.length];
        for (i = 0; i < nodeInd.length; ++i) {
            this.nodes[i] = nodeInd[i];
        }
        this.edges = new int[edgeInd.length];
        for (i = 0; i < edgeInd.length; ++i) {
            this.edges[i] = edgeInd[i];
        }
        this.xPos = new double[this.nodes.length];
        this.yPos = new double[this.nodes.length];
        CyNetworkView netView = Cytoscape.getNetworkView(net.getIdentifier());
        if (netView != null && netView != Cytoscape.getNullNetworkView()) {
            for (int i2 = 0; i2 < this.nodes.length; ++i2) {
                NodeView nv = netView.getNodeView(this.nodes[i2]);
                this.xPos[i2] = nv.getXPosition();
                this.yPos[i2] = nv.getYPosition();
            }
        }
    }

    DeleteEdit(CyNetwork net, int[] nodeInd, int[] edgeInd, DeleteAction deleteAction) {
        this(net, nodeInd, edgeInd);
        this.deleteAction = deleteAction;
    }

    public void redo() {
        super.redo();
        this.net.hideEdges(this.edges);
        this.net.hideNodes(this.nodes);
        CyNetworkView netView = Cytoscape.getNetworkView(this.net.getIdentifier());
        netView.redrawGraph(true, true);
        Cytoscape.firePropertyChange("NETWORK_MODIFIED", netView, this.net);
        this.deleteAction.setEnabled(false);
    }

    public void undo() {
        super.undo();
        this.net.restoreNodes(this.nodes);
        this.net.restoreEdges(this.edges);
        CyNetworkView netView = Cytoscape.getNetworkView(this.net.getIdentifier());
        if (netView != null && netView != Cytoscape.getNullNetworkView()) {
            for (int i = 0; i < this.nodes.length; ++i) {
                NodeView nv = netView.getNodeView(this.nodes[i]);
                nv.setOffset(this.xPos[i], this.yPos[i]);
            }
        }
        netView.redrawGraph(true, true);
        Cytoscape.firePropertyChange("NETWORK_MODIFIED", netView, this.net);
        this.deleteAction.setEnabled(true);
    }
}

