/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.util.CyNetworkNaming;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.VisualStyle;
import giny.model.Node;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.MenuEvent;

public class NewWindowSelectedNodesOnlyAction
extends CytoscapeAction {
    public NewWindowSelectedNodesOnlyAction() {
        super("From Selected Nodes, All Edges");
        this.setPreferredMenu("File.New.Network");
        this.setAcceleratorCombo(78, 2);
    }

    public void actionPerformed(ActionEvent e) {
        Set nodes;
        CyNetwork new_network;
        CyNetworkView new_view;
        CyNetwork current_network = Cytoscape.getCurrentNetwork();
        if (current_network == null || current_network == Cytoscape.getNullNetwork()) {
            return;
        }
        CyNetworkView current_network_view = null;
        if (Cytoscape.viewExists(current_network.getIdentifier())) {
            current_network_view = Cytoscape.getNetworkView(current_network.getIdentifier());
        }
        if ((new_view = Cytoscape.getNetworkView((new_network = Cytoscape.createNetwork(nodes = current_network.getSelectedNodes(), current_network.getConnectingEdges(new ArrayList(nodes)), CyNetworkNaming.getSuggestedSubnetworkTitle(current_network), current_network)).getIdentifier())) == Cytoscape.getNullNetworkView()) {
            return;
        }
        String vsName = "default";
        if (current_network_view != Cytoscape.getNullNetworkView()) {
            Iterator i = new_network.nodesIterator();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                new_view.getNodeView(node).setOffset(current_network_view.getNodeView(node).getXPosition(), current_network_view.getNodeView(node).getYPosition());
            }
            new_view.fitContent();
            VisualStyle newVS = current_network_view.getVisualStyle();
            if (newVS != null) {
                vsName = newVS.getName();
            }
        }
        Cytoscape.getVisualMappingManager().setVisualStyle(vsName);
    }

    public void menuSelected(MenuEvent e) {
        CyNetwork n = Cytoscape.getCurrentNetwork();
        if (n == null || n == Cytoscape.getNullNetwork()) {
            this.setEnabled(false);
            return;
        }
        Set nodes = n.getSelectedNodes();
        if (nodes != null && nodes.size() > 0) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

