/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.writers.InteractionWriter;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

class SaveAsSifTask
implements Task {
    private String fileName;
    private TaskMonitor taskMonitor;

    SaveAsSifTask(String fileName) {
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.taskMonitor.setStatus("Saving Interactions...");
        try {
            CyNetwork netToSave;
            block6: {
                if (Cytoscape.getCurrentNetwork().getNodeCount() == 0) {
                    throw new IllegalArgumentException("Network is empty.");
                }
                netToSave = Cytoscape.getCurrentNetwork();
                FileWriter f = null;
                try {
                    f = new FileWriter(this.fileName);
                    InteractionWriter.writeInteractions(netToSave, f, this.taskMonitor);
                    Object var4_5 = null;
                    if (f == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    if (f == null) throw throwable;
                    f.close();
                    throw throwable;
                }
                f.close();
            }
            Object[] ret_val = new Object[]{netToSave, new File(this.fileName).toURI(), new Integer(Cytoscape.FILE_SIF)};
            Cytoscape.firePropertyChange("NETWORK_SAVED", null, ret_val);
            this.taskMonitor.setPercentCompleted(100);
            this.taskMonitor.setStatus("Network successfully saved to:  " + this.fileName);
            return;
        }
        catch (IllegalArgumentException e) {
            this.taskMonitor.setException(e, "Network is Empty.  Cannot be saved.");
            return;
        }
        catch (IOException e) {
            this.taskMonitor.setException(e, "Unable to save network.");
        }
    }

    public void halt() {
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Saving Network");
    }
}

