/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.Cytoscape;
import cytoscape.data.SelectEvent;
import cytoscape.data.SelectFilter;
import cytoscape.giny.CytoscapeRootGraph;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import java.util.HashSet;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SelectEventTest
extends TestCase {
    public SelectEventTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testConstants() throws Exception {
        SelectEventTest.assertTrue(true);
        SelectEventTest.assertTrue(true);
        SelectEventTest.assertTrue(true);
        SelectEventTest.assertTrue(true);
        SelectEventTest.assertTrue(true);
        SelectEventTest.assertTrue(true);
    }

    public void testCtor() throws Exception {
        CytoscapeRootGraph rootGraph = Cytoscape.getRootGraph();
        Node node1 = rootGraph.getNode(rootGraph.createNode());
        Node node2 = rootGraph.getNode(rootGraph.createNode());
        Edge edge1 = rootGraph.getEdge(rootGraph.createEdge(node1, node2));
        Edge edge2 = rootGraph.getEdge(rootGraph.createEdge(node2, node1));
        Node[] nodeArray = new Node[]{node1, node2};
        Edge[] edgeArray = new Edge[]{edge1, edge2};
        GraphPerspective gp = rootGraph.createGraphPerspective(nodeArray, edgeArray);
        SelectFilter source = new SelectFilter(gp);
        HashSet<Node> nodeSet = new HashSet<Node>();
        nodeSet.add(node1);
        nodeSet.add(node2);
        HashSet<Edge> edgeSet = new HashSet<Edge>();
        edgeSet.add(edge1);
        edgeSet.add(edge2);
        SelectEvent singleNodeOn = new SelectEvent(source, node1, true);
        this.checkEvent(singleNodeOn, source, node1, 0, true);
        SelectEvent singleNodeOff = new SelectEvent(source, node2, false);
        this.checkEvent(singleNodeOff, source, node2, 0, false);
        SelectEvent singleEdgeOn = new SelectEvent(source, edge1, true);
        this.checkEvent(singleEdgeOn, source, edge1, 1, true);
        SelectEvent singleEdgeOff = new SelectEvent(source, edge2, false);
        this.checkEvent(singleEdgeOff, source, edge2, 1, false);
        SelectEvent nodeSetOn = new SelectEvent(source, nodeSet, true);
        this.checkEvent(nodeSetOn, source, nodeSet, 2, true);
        SelectEvent nodeSetOff = new SelectEvent(source, nodeSet, false);
        this.checkEvent(nodeSetOff, source, nodeSet, 2, false);
        SelectEvent edgeSetOn = new SelectEvent(source, edgeSet, true);
        this.checkEvent(edgeSetOn, source, edgeSet, 3, true);
        SelectEvent edgeSetOff = new SelectEvent(source, edgeSet, false);
        this.checkEvent(edgeSetOff, source, edgeSet, 3, false);
    }

    public void checkEvent(SelectEvent event, SelectFilter source, Object target, int targetType, boolean selectOn) {
        SelectEventTest.assertTrue(event.getSource() == source);
        SelectEventTest.assertTrue(event.getTarget() == target);
        SelectEventTest.assertTrue(event.getTargetType() == targetType);
        SelectEventTest.assertTrue(event.getEventType() == selectOn);
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(SelectEventTest.class));
    }
}

