/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation.readers;

import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.Ontology;
import cytoscape.data.annotation.readers.OntologyXmlReader;
import cytoscape.logger.CyLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class AnnotationXmlReader {
    File xmlFile;
    Annotation annotation;
    File directoryAbsolute;

    public AnnotationXmlReader(File xmlFile) throws Exception {
        if (!xmlFile.canRead()) {
            CyLogger.getLogger().info("---- data.annotation.readers.AnnotationXmlReader error, cannot read\n         " + xmlFile);
            throw new Exception("cannot read input: " + xmlFile);
        }
        this.xmlFile = xmlFile;
        this.directoryAbsolute = xmlFile.getAbsoluteFile().getParentFile();
        this.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void read() throws Exception {
        Document doc;
        block6: {
            SAXBuilder builder = new SAXBuilder();
            FileInputStream is = null;
            try {
                is = new FileInputStream(this.xmlFile);
                doc = builder.build(is, this.xmlFile.toURI().toURL().toString());
                Object var6_4 = null;
                if (is == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (is != null) {
                    ((InputStream)is).close();
                }
                throw throwable;
            }
            ((InputStream)is).close();
        }
        Element root = doc.getRootElement();
        String species = root.getAttributeValue("species");
        String ontologyXmlFileName = root.getAttributeValue("ontology");
        String annotationType = root.getAttributeValue("type");
        File ontologyXmlFileAbsolutePath = new File(this.directoryAbsolute, ontologyXmlFileName);
        if (!ontologyXmlFileAbsolutePath.canRead()) {
            String warn = "annotation xml file must name its associated ontology xml file ";
            warn = warn + "by giving its path relative to the actual location of the ";
            warn = warn + "annotation xml file.\n";
            warn = warn + "could not find:";
            warn = warn + "  " + ontologyXmlFileAbsolutePath;
            CyLogger.getLogger().warn(warn);
            throw new FileNotFoundException(ontologyXmlFileAbsolutePath.getPath());
        }
        OntologyXmlReader oReader = new OntologyXmlReader(ontologyXmlFileAbsolutePath);
        Ontology ontology = oReader.getOntology();
        this.annotation = new Annotation(species, annotationType, ontology);
        List children = root.getChildren();
        ListIterator iterator = children.listIterator();
        while (iterator.hasNext()) {
            Element termElement = (Element)iterator.next();
            String entityName = termElement.getChild("entity").getText().trim();
            String tmp = termElement.getChild("id").getText().trim();
            int id = Integer.parseInt(tmp);
            this.annotation.add(entityName, id);
        }
        return;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }
}

