/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.attr.util;

import cytoscape.data.attr.CountedIterator;
import cytoscape.data.attr.MultiHashMap;
import cytoscape.data.attr.MultiHashMapDefinition;
import java.util.ArrayList;
import java.util.List;

public final class MultiHashMapHelpers {
    private MultiHashMapHelpers() {
    }

    public static List getAllAttributeValues(String objectKey, String attributeName, MultiHashMap cyData, MultiHashMapDefinition cyDataDef) {
        ArrayList<Object> bucket = new ArrayList<Object>();
        int keyspaceDims = cyDataDef.getAttributeKeyspaceDimensionTypes(attributeName).length;
        if (keyspaceDims < 1) {
            Object attrVal = cyData.getAttributeValue(objectKey, attributeName, null);
            if (attrVal != null) {
                bucket.add(attrVal);
            }
        } else {
            MultiHashMapHelpers.r_getAllAttributeValues(objectKey, attributeName, cyData, bucket, new Object[0], keyspaceDims);
        }
        return bucket;
    }

    public static List getAllAttributeValuesAlongPrefix(String objectKey, String attributeName, Object[] keyPrefix, MultiHashMap cyData, MultiHashMapDefinition cyDataDef) {
        int prefixDims;
        ArrayList<Object> bucket = new ArrayList<Object>();
        int keyspaceDims = cyDataDef.getAttributeKeyspaceDimensionTypes(attributeName).length;
        int n = prefixDims = keyPrefix == null ? 0 : keyPrefix.length;
        if (keyspaceDims <= prefixDims) {
            Object attrVal = cyData.getAttributeValue(objectKey, attributeName, keyPrefix);
            if (attrVal != null) {
                bucket.add(attrVal);
            }
        } else {
            Object[] keyPrefixCopy = new Object[prefixDims];
            for (int i = 0; i < prefixDims; ++i) {
                keyPrefixCopy[i] = keyPrefix[i];
            }
            MultiHashMapHelpers.r_getAllAttributeValues(objectKey, attributeName, cyData, bucket, keyPrefixCopy, keyspaceDims);
        }
        return bucket;
    }

    private static void r_getAllAttributeValues(String objectKey, String attributeName, MultiHashMap dataRegistry, ArrayList bucket, Object[] prefixSoFar, int keyspaceDims) {
        CountedIterator currentKeyspan = dataRegistry.getAttributeKeyspan(objectKey, attributeName, prefixSoFar);
        Object[] newPrefix = new Object[prefixSoFar.length + 1];
        for (int i = 0; i < prefixSoFar.length; ++i) {
            newPrefix[i] = prefixSoFar[i];
        }
        while (currentKeyspan.hasNext()) {
            newPrefix[newPrefix.length - 1] = currentKeyspan.next();
            if (keyspaceDims == newPrefix.length) {
                bucket.add(dataRegistry.getAttributeValue(objectKey, attributeName, newPrefix));
                continue;
            }
            MultiHashMapHelpers.r_getAllAttributeValues(objectKey, attributeName, dataRegistry, bucket, newPrefix, keyspaceDims);
        }
    }

    public static List getAllAttributeKeys(String objectKey, String attributeName, MultiHashMap cyData, MultiHashMapDefinition cyDataDef) {
        ArrayList<Object[]> bucket = new ArrayList<Object[]>();
        int keyspaceDims = cyDataDef.getAttributeKeyspaceDimensionTypes(attributeName).length;
        if (keyspaceDims < 1) {
            Object attrVal = cyData.getAttributeValue(objectKey, attributeName, null);
            if (attrVal != null) {
                bucket.add(new Object[0]);
            }
        } else {
            MultiHashMapHelpers.r_getAllAttributeKeys(objectKey, attributeName, cyData, bucket, new Object[0], keyspaceDims);
        }
        return bucket;
    }

    public static List getAllAttributeKeysAlongPrefix(String objectKey, String attributeName, Object[] keyPrefix, MultiHashMap cyData, MultiHashMapDefinition cyDataDef) {
        ArrayList<Object[]> bucket = new ArrayList<Object[]>();
        int keyspaceDims = cyDataDef.getAttributeKeyspaceDimensionTypes(attributeName).length;
        int prefixDims = keyPrefix == null ? 0 : keyPrefix.length;
        Object[] keyPrefixCopy = new Object[prefixDims];
        for (int i = 0; i < prefixDims; ++i) {
            keyPrefixCopy[i] = keyPrefix[i];
        }
        if (keyspaceDims <= prefixDims) {
            Object attrVal = cyData.getAttributeValue(objectKey, attributeName, keyPrefixCopy);
            if (attrVal != null) {
                bucket.add(keyPrefixCopy);
            }
        } else {
            MultiHashMapHelpers.r_getAllAttributeKeys(objectKey, attributeName, cyData, bucket, keyPrefixCopy, keyspaceDims);
        }
        return bucket;
    }

    private static void r_getAllAttributeKeys(String objectKey, String attributeName, MultiHashMap dataRegistry, ArrayList bucket, Object[] prefixSoFar, int keyspaceDims) {
        CountedIterator currentKeyspan = dataRegistry.getAttributeKeyspan(objectKey, attributeName, prefixSoFar);
        if (keyspaceDims == prefixSoFar.length + 1) {
            while (currentKeyspan.hasNext()) {
                Object[] newPrefix = new Object[prefixSoFar.length + 1];
                for (int i = 0; i < prefixSoFar.length; ++i) {
                    newPrefix[i] = prefixSoFar[i];
                }
                newPrefix[newPrefix.length - 1] = currentKeyspan.next();
                bucket.add(newPrefix);
            }
        } else {
            Object[] newPrefix = new Object[prefixSoFar.length + 1];
            for (int i = 0; i < prefixSoFar.length; ++i) {
                newPrefix[i] = prefixSoFar[i];
            }
            while (currentKeyspan.hasNext()) {
                newPrefix[newPrefix.length - 1] = currentKeyspan.next();
                MultiHashMapHelpers.r_getAllAttributeKeys(objectKey, attributeName, dataRegistry, bucket, newPrefix, keyspaceDims);
            }
        }
    }
}

