/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.attr.util;

import cytoscape.data.attr.CountedIterator;
import cytoscape.data.attr.MultiHashMap;
import cytoscape.data.attr.MultiHashMapDefinition;
import cytoscape.data.attr.MultiHashMapDefinitionListener;
import cytoscape.data.attr.MultiHashMapListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cytoscape.equations.BooleanList;
import org.cytoscape.equations.DoubleList;
import org.cytoscape.equations.Equation;
import org.cytoscape.equations.FunctionUtil;
import org.cytoscape.equations.LongList;
import org.cytoscape.equations.StringList;

class MultiHashMapModel
implements MultiHashMapDefinition,
MultiHashMap {
    private static final CountedIterator s_the_empty_iterator = new CountedIterator(){

        public final int numRemaining() {
            return 0;
        }

        public final boolean hasNext() {
            return false;
        }

        public final Object next() {
            throw new NoSuchElementException();
        }

        public final void remove() {
            throw new UnsupportedOperationException("cannot remove from this iterator");
        }
    };
    private final HashMap m_attrMap = new HashMap();
    private MultiHashMapDefinitionListener m_dataDefListener = null;
    private MultiHashMapListener m_dataListener = null;

    MultiHashMapModel() {
    }

    public final void defineAttribute(String attributeName, byte valueType, byte[] keyTypes) {
        int i;
        if (attributeName == null) {
            throw new NullPointerException("attributeName is null");
        }
        if (this.m_attrMap.containsKey(attributeName)) {
            throw new IllegalStateException("attributeName '" + attributeName + "' already exists");
        }
        switch (valueType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("valueType is unrecognized");
            }
        }
        int keyTypesLength = keyTypes == null ? 0 : keyTypes.length;
        byte[] keyTypesCopy = new byte[keyTypesLength];
        if (keyTypes != null) {
            for (i = 0; i < keyTypesLength; ++i) {
                keyTypesCopy[i] = keyTypes[i];
            }
        }
        block7: for (i = 0; i < keyTypesCopy.length; ++i) {
            switch (keyTypesCopy[i]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("keyTypes[" + i + "] is unrecognized");
                }
            }
        }
        AttrDefData def = new AttrDefData(new HashMap(), valueType, keyTypesCopy);
        this.m_attrMap.put(attributeName, def);
        MultiHashMapDefinitionListener l = this.m_dataDefListener;
        if (l != null) {
            l.attributeDefined(attributeName);
        }
    }

    public final CountedIterator getDefinedAttributes() {
        return new Iterator2Counted(this.m_attrMap.keySet().iterator(), this.m_attrMap.size());
    }

    public final byte getAttributeValueType(String attributeName) {
        if (attributeName == null) {
            throw new NullPointerException("attributeName is null");
        }
        AttrDefData def = (AttrDefData)this.m_attrMap.get(attributeName);
        if (def == null) {
            return -1;
        }
        return def.valueType;
    }

    public final byte[] getAttributeKeyspaceDimensionTypes(String attributeName) {
        if (attributeName == null) {
            throw new NullPointerException("attributeName is null");
        }
        AttrDefData def = (AttrDefData)this.m_attrMap.get(attributeName);
        if (def == null) {
            throw new IllegalStateException("no attributeName '" + attributeName + "' exists");
        }
        byte[] returnThis = new byte[def.keyTypes.length];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = def.keyTypes[i];
        }
        return returnThis;
    }

    public final boolean undefineAttribute(String attributeName) {
        if (attributeName == null) {
            throw new NullPointerException("attributeName is null");
        }
        Object o = this.m_attrMap.remove(attributeName);
        if (o != null) {
            MultiHashMapDefinitionListener l = this.m_dataDefListener;
            if (l != null) {
                l.attributeUndefined(attributeName);
            }
            return true;
        }
        return false;
    }

    public final void addDataDefinitionListener(MultiHashMapDefinitionListener listener) {
        this.m_dataDefListener = AttrDefLisChain.add(this.m_dataDefListener, listener);
    }

    public final void removeDataDefinitionListener(MultiHashMapDefinitionListener listener) {
        this.m_dataDefListener = AttrDefLisChain.remove(this.m_dataDefListener, listener);
    }

    public final Object setAttributeValue(String objectKey, String attributeName, Object attributeValue, Object[] keyIntoValue) {
        if (attributeName == null) {
            throw new NullPointerException("attributeName is null");
        }
        AttrDefData def = (AttrDefData)this.m_attrMap.get(attributeName);
        if (def == null) {
            throw new IllegalStateException("no attributeName '" + attributeName + "' exists");
        }
        if (objectKey == null) {
            throw new NullPointerException("objectKey is null");
        }
        if (attributeValue == null) {
            throw new NullPointerException("cannot set null attributeValue - use removeAttributeValue() instead");
        }
        boolean isEquation = attributeValue instanceof Equation;
        Class actualType = isEquation ? ((Equation)attributeValue).getType() : attributeValue.getClass();
        switch (def.valueType) {
            case 1: {
                if (actualType == Boolean.class || isEquation && (actualType == Long.class || actualType == Double.class || actualType == BooleanList.class)) break;
                throw new ClassCastException("found " + actualType + " for \"" + attributeName + "\", expected Boolean!");
            }
            case 2: {
                if (actualType == Double.class || isEquation && (actualType == Long.class || actualType == Boolean.class || actualType == DoubleList.class)) break;
                throw new ClassCastException("found " + actualType + " for \"" + attributeName + "\", expected Double!");
            }
            case 3: {
                if (actualType == Integer.class || isEquation && (actualType == Double.class || actualType == Boolean.class || actualType == Long.class || actualType == LongList.class)) break;
                throw new ClassCastException("found " + actualType + " for \"" + attributeName + "\", expected Integer!");
            }
            case 4: {
                if (actualType == String.class || isEquation) break;
                throw new ClassCastException("found " + actualType + " for \"" + attributeName + "\", expected String!");
            }
        }
        if (def.keyTypes.length == 0) {
            if (keyIntoValue != null && keyIntoValue.length != 0) {
                throw new IllegalArgumentException("attributeName '" + attributeName + "' has no keyspace" + " defined, yet keyIntoValue is not empty");
            }
            if (FunctionUtil.isSomeKindOfList(actualType)) {
                throw new ClassCastException("found " + actualType + " for \"" + attributeName + "\", expected String!");
            }
        } else {
            int keyIntoValueLength;
            int n = keyIntoValueLength = keyIntoValue == null ? 0 : keyIntoValue.length;
            if (def.keyTypes.length != keyIntoValueLength) {
                throw new IllegalArgumentException("keyIntoValue has incorrect dimensionality");
            }
            if (isEquation) {
                switch (def.valueType) {
                    case 1: {
                        if (actualType == BooleanList.class) break;
                        throw new ClassCastException("found " + actualType + " for \"" + attributeName + "\", expected String!");
                    }
                    case 2: {
                        if (actualType == DoubleList.class) break;
                        throw new ClassCastException("found " + actualType + " for \"" + attributeName + "\", expected String!");
                    }
                    case 3: {
                        if (actualType == LongList.class) break;
                        throw new ClassCastException("found " + actualType + " for \"" + attributeName + "\", expected String!");
                    }
                    case 4: {
                        if (actualType == StringList.class) break;
                        throw new ClassCastException("found " + actualType + " for \"" + attributeName + "\", expected String!");
                    }
                }
            }
        }
        MultiHashMapListener listener = this.m_dataListener;
        if (def.keyTypes.length == 0) {
            Object returnThis = def.objMap.put(objectKey, attributeValue);
            if (listener != null) {
                listener.attributeValueAssigned(objectKey, attributeName, null, returnThis, attributeValue);
            }
            return returnThis;
        }
        Object o = def.objMap.get(objectKey);
        HashMap firstDim = o == null ? new HashMap() : (HashMap)o;
        Object returnThis = this.r_setAttributeValue(firstDim, attributeValue, keyIntoValue, def.keyTypes, 0);
        if (o == null) {
            def.objMap.put(objectKey, firstDim);
        }
        if (listener != null) {
            listener.attributeValueAssigned(objectKey, attributeName, keyIntoValue, returnThis, attributeValue);
        }
        return returnThis;
    }

    private final Object r_setAttributeValue(HashMap hash, Object attributeValue, Object[] keyIntoValue, byte[] keyTypes, int currOffset) {
        Object currKey = keyIntoValue[currOffset];
        if (currKey == null) {
            throw new NullPointerException("keyIntoValue[" + currOffset + "] null");
        }
        boolean passed = false;
        switch (keyTypes[currOffset]) {
            case 1: {
                passed = currKey instanceof Boolean;
                break;
            }
            case 2: {
                passed = currKey instanceof Double;
                break;
            }
            case 3: {
                passed = currKey instanceof Integer;
                break;
            }
            case 4: {
                passed = currKey instanceof String;
            }
        }
        if (!passed) {
            throw new ClassCastException("keyIntoValue[" + currOffset + "] is of incorrect object type");
        }
        if (currOffset == keyIntoValue.length - 1) {
            return hash.put(currKey, attributeValue);
        }
        Object o = hash.get(currKey);
        HashMap dim = o == null ? new HashMap() : (HashMap)o;
        Object returnThis = this.r_setAttributeValue(dim, attributeValue, keyIntoValue, keyTypes, currOffset + 1);
        if (o == null) {
            hash.put(currKey, dim);
        }
        return returnThis;
    }

    public final Object getAttributeValue(String objectKey, String attributeName, Object[] keyIntoValue) {
        if (attributeName == null) {
            throw new NullPointerException("attributeName is null");
        }
        AttrDefData def = (AttrDefData)this.m_attrMap.get(attributeName);
        if (def == null) {
            throw new IllegalStateException("no attributeName '" + attributeName + "' exists");
        }
        if (objectKey == null) {
            throw new NullPointerException("objectKey is null");
        }
        if (def.keyTypes.length == 0) {
            if (keyIntoValue != null && keyIntoValue.length != 0) {
                throw new IllegalArgumentException("attributeName '" + attributeName + "' has no keyspace" + " defined, yet keyIntoValue is not empty");
            }
        } else {
            int keyIntoValueLength;
            int n = keyIntoValueLength = keyIntoValue == null ? 0 : keyIntoValue.length;
            if (def.keyTypes.length != keyIntoValueLength) {
                throw new IllegalArgumentException("keyIntoValue has incorrect dimensionality for attribute \"" + attributeName + "\"(expected: " + keyIntoValueLength + ", found: " + def.keyTypes.length + ")!");
            }
        }
        if (def.keyTypes.length == 0) {
            return def.objMap.get(objectKey);
        }
        Object o = def.objMap.get(objectKey);
        if (o == null) {
            return null;
        }
        return this.r_getAttributeValue((HashMap)o, keyIntoValue, def.keyTypes, 0);
    }

    private final Object r_getAttributeValue(HashMap hash, Object[] keyIntoValue, byte[] keyTypes, int currOffset) {
        Object currKey = keyIntoValue[currOffset];
        if (currKey == null) {
            throw new NullPointerException("keyIntoValue[" + currOffset + "] null");
        }
        boolean passed = false;
        switch (keyTypes[currOffset]) {
            case 1: {
                passed = currKey instanceof Boolean;
                break;
            }
            case 2: {
                passed = currKey instanceof Double;
                break;
            }
            case 3: {
                passed = currKey instanceof Integer;
                break;
            }
            case 4: {
                passed = currKey instanceof String;
            }
        }
        if (!passed) {
            throw new ClassCastException("keyIntoValue[" + currOffset + "] is of incorrect object type");
        }
        if (currOffset == keyIntoValue.length - 1) {
            return hash.get(currKey);
        }
        Object o = hash.get(currKey);
        if (o == null) {
            return null;
        }
        return this.r_getAttributeValue((HashMap)o, keyIntoValue, keyTypes, currOffset + 1);
    }

    public final Object removeAttributeValue(String objectKey, String attributeName, Object[] keyIntoValue) {
        if (attributeName == null) {
            throw new NullPointerException("attributeName is null");
        }
        AttrDefData def = (AttrDefData)this.m_attrMap.get(attributeName);
        if (def == null) {
            throw new IllegalStateException("no attributeName '" + attributeName + "' exists");
        }
        if (objectKey == null) {
            throw new NullPointerException("objectKey is null");
        }
        if (def.keyTypes.length == 0) {
            if (keyIntoValue != null && keyIntoValue.length != 0) {
                throw new IllegalArgumentException("attributeName '" + attributeName + "' has no keyspace" + " defined, yet keyIntoValue is not empty");
            }
        } else {
            int keyIntoValueLength;
            int n = keyIntoValueLength = keyIntoValue == null ? 0 : keyIntoValue.length;
            if (def.keyTypes.length != keyIntoValueLength) {
                throw new IllegalArgumentException("keyIntoValue has incorrect dimensionality");
            }
        }
        MultiHashMapListener listener = this.m_dataListener;
        if (def.keyTypes.length == 0) {
            Object returnThis = def.objMap.remove(objectKey);
            if (listener != null && returnThis != null) {
                listener.attributeValueRemoved(objectKey, attributeName, null, returnThis);
            }
            return returnThis;
        }
        Object o = def.objMap.get(objectKey);
        if (o == null) {
            return null;
        }
        HashMap dim = (HashMap)o;
        Object returnThis = this.r_removeAttributeValue(dim, keyIntoValue, def.keyTypes, 0);
        if (returnThis != null) {
            if (dim.size() == 0) {
                def.objMap.remove(objectKey);
            }
            if (listener != null) {
                listener.attributeValueRemoved(objectKey, attributeName, keyIntoValue, returnThis);
            }
        }
        return returnThis;
    }

    private final Object r_removeAttributeValue(HashMap hash, Object[] keyIntoValue, byte[] keyTypes, int currOffset) {
        Object currKey = keyIntoValue[currOffset];
        if (currKey == null) {
            throw new NullPointerException("keyIntoValue[" + currOffset + "] null");
        }
        boolean passed = false;
        switch (keyTypes[currOffset]) {
            case 1: {
                passed = currKey instanceof Boolean;
                break;
            }
            case 2: {
                passed = currKey instanceof Double;
                break;
            }
            case 3: {
                passed = currKey instanceof Integer;
                break;
            }
            case 4: {
                passed = currKey instanceof String;
            }
        }
        if (!passed) {
            throw new ClassCastException("keyIntoValue[" + currOffset + "] is of incorrect object type");
        }
        if (currOffset == keyIntoValue.length - 1) {
            return hash.remove(currKey);
        }
        Object o = hash.get(currKey);
        if (o == null) {
            return null;
        }
        HashMap dim = (HashMap)o;
        Object returnThis = this.r_removeAttributeValue(dim, keyIntoValue, keyTypes, currOffset + 1);
        if (dim.size() == 0) {
            hash.remove(currKey);
        }
        return returnThis;
    }

    public final boolean removeAllAttributeValues(String objectKey, String attributeName) {
        MultiHashMapListener listener;
        boolean returnThis;
        if (attributeName == null) {
            throw new NullPointerException("attributeName is null");
        }
        AttrDefData def = (AttrDefData)this.m_attrMap.get(attributeName);
        if (def == null) {
            throw new IllegalStateException("no attributeName '" + attributeName + "' exists");
        }
        if (objectKey == null) {
            throw new NullPointerException("objectKey is null");
        }
        boolean bl = returnThis = def.objMap.remove(objectKey) != null;
        if (returnThis && (listener = this.m_dataListener) != null) {
            listener.allAttributeValuesRemoved(objectKey, attributeName);
        }
        return returnThis;
    }

    public final CountedIterator getAttributeKeyspan(String objectKey, String attributeName, Object[] keyPrefix) {
        if (attributeName == null) {
            throw new NullPointerException("attributeName is null");
        }
        AttrDefData def = (AttrDefData)this.m_attrMap.get(attributeName);
        if (def == null) {
            throw new IllegalStateException("no attributeName '" + attributeName + "' exists");
        }
        if (objectKey == null) {
            throw new NullPointerException("objectKey is null");
        }
        if (def.keyTypes.length == 0) {
            throw new IllegalStateException("attributeName '" + attributeName + "' has no keyspace, so" + " calling this method makes no sense");
        }
        if (keyPrefix != null && keyPrefix.length >= def.keyTypes.length) {
            throw new IllegalArgumentException("the length of keyPrefix must be strictly less than the dimensionality of keyspace");
        }
        if (keyPrefix == null || keyPrefix.length == 0) {
            HashMap dim = (HashMap)def.objMap.get(objectKey);
            if (dim == null) {
                return s_the_empty_iterator;
            }
            return new Iterator2Counted(dim.keySet().iterator(), dim.size());
        }
        HashMap dim = (HashMap)def.objMap.get(objectKey);
        if (dim == null) {
            return s_the_empty_iterator;
        }
        return this.r_getAttributeKeyspan(dim, keyPrefix, def.keyTypes, 0);
    }

    private final CountedIterator r_getAttributeKeyspan(HashMap hash, Object[] keyPrefix, byte[] keyTypes, int currOffset) {
        Object currKey = keyPrefix[currOffset];
        if (currKey == null) {
            throw new NullPointerException("keyPrefix[" + currOffset + "] is null");
        }
        boolean passed = false;
        switch (keyTypes[currOffset]) {
            case 1: {
                passed = currKey instanceof Boolean;
                break;
            }
            case 2: {
                passed = currKey instanceof Double;
                break;
            }
            case 3: {
                passed = currKey instanceof Integer;
                break;
            }
            case 4: {
                passed = currKey instanceof String;
            }
        }
        if (!passed) {
            throw new ClassCastException("keyPrefix[" + currOffset + "] is of incorrect object type");
        }
        if (currOffset == keyPrefix.length - 1) {
            HashMap dim = (HashMap)hash.get(currKey);
            if (dim == null) {
                return s_the_empty_iterator;
            }
            return new Iterator2Counted(dim.keySet().iterator(), dim.size());
        }
        HashMap dim = (HashMap)hash.get(currKey);
        if (dim == null) {
            return s_the_empty_iterator;
        }
        return this.r_getAttributeKeyspan(dim, keyPrefix, keyTypes, currOffset + 1);
    }

    public final CountedIterator getObjectKeys(String attributeName) {
        if (attributeName == null) {
            throw new NullPointerException("attributeName is null");
        }
        AttrDefData def = (AttrDefData)this.m_attrMap.get(attributeName);
        if (def == null) {
            throw new IllegalStateException("no attributeName '" + attributeName + "' exists");
        }
        return new Iterator2Counted(def.objMap.keySet().iterator(), def.objMap.size());
    }

    public final void addDataListener(MultiHashMapListener listener) {
        this.m_dataListener = AttrLisChain.add(this.m_dataListener, listener);
    }

    public final void removeDataListener(MultiHashMapListener listener) {
        this.m_dataListener = AttrLisChain.remove(this.m_dataListener, listener);
    }

    private static final class AttrLisChain
    implements MultiHashMapListener {
        private final MultiHashMapListener a;
        private final MultiHashMapListener b;

        private AttrLisChain(MultiHashMapListener a, MultiHashMapListener b) {
            this.a = a;
            this.b = b;
        }

        public final void attributeValueAssigned(String objectKey, String attributeName, Object[] keyIntoValue, Object oldAttrVal, Object newAttrVal) {
            this.a.attributeValueAssigned(objectKey, attributeName, keyIntoValue, oldAttrVal, newAttrVal);
            this.b.attributeValueAssigned(objectKey, attributeName, keyIntoValue, oldAttrVal, newAttrVal);
        }

        public final void attributeValueRemoved(String objectKey, String attributeName, Object[] keyIntoValue, Object attributeValue) {
            this.a.attributeValueRemoved(objectKey, attributeName, keyIntoValue, attributeValue);
            this.b.attributeValueRemoved(objectKey, attributeName, keyIntoValue, attributeValue);
        }

        public final void allAttributeValuesRemoved(String objectKey, String attributeName) {
            this.a.allAttributeValuesRemoved(objectKey, attributeName);
            this.b.allAttributeValuesRemoved(objectKey, attributeName);
        }

        private static final MultiHashMapListener add(MultiHashMapListener a, MultiHashMapListener b) {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            return new AttrLisChain(a, b);
        }

        private static final MultiHashMapListener remove(MultiHashMapListener l, MultiHashMapListener oldl) {
            if (l == oldl || l == null) {
                return null;
            }
            if (l instanceof AttrLisChain) {
                return ((AttrLisChain)l).remove(oldl);
            }
            return l;
        }

        private final MultiHashMapListener remove(MultiHashMapListener oldl) {
            if (oldl == this.a) {
                return this.b;
            }
            if (oldl == this.b) {
                return this.a;
            }
            MultiHashMapListener a2 = AttrLisChain.remove(this.a, oldl);
            MultiHashMapListener b2 = AttrLisChain.remove(this.b, oldl);
            if (a2 == this.a && b2 == this.b) {
                return this;
            }
            return AttrLisChain.add(a2, b2);
        }
    }

    private static final class AttrDefLisChain
    implements MultiHashMapDefinitionListener {
        private final MultiHashMapDefinitionListener a;
        private final MultiHashMapDefinitionListener b;

        private AttrDefLisChain(MultiHashMapDefinitionListener a, MultiHashMapDefinitionListener b) {
            this.a = a;
            this.b = b;
        }

        public final void attributeDefined(String attributeName) {
            this.a.attributeDefined(attributeName);
            this.b.attributeDefined(attributeName);
        }

        public final void attributeUndefined(String attributeName) {
            this.a.attributeUndefined(attributeName);
            this.b.attributeUndefined(attributeName);
        }

        private static final MultiHashMapDefinitionListener add(MultiHashMapDefinitionListener a, MultiHashMapDefinitionListener b) {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            return new AttrDefLisChain(a, b);
        }

        private static final MultiHashMapDefinitionListener remove(MultiHashMapDefinitionListener l, MultiHashMapDefinitionListener oldl) {
            if (l == oldl || l == null) {
                return null;
            }
            if (l instanceof AttrDefLisChain) {
                return ((AttrDefLisChain)l).remove(oldl);
            }
            return l;
        }

        private final MultiHashMapDefinitionListener remove(MultiHashMapDefinitionListener oldl) {
            if (oldl == this.a) {
                return this.b;
            }
            if (oldl == this.b) {
                return this.a;
            }
            MultiHashMapDefinitionListener a2 = AttrDefLisChain.remove(this.a, oldl);
            MultiHashMapDefinitionListener b2 = AttrDefLisChain.remove(this.b, oldl);
            if (a2 == this.a && b2 == this.b) {
                return this;
            }
            return AttrDefLisChain.add(a2, b2);
        }
    }

    private static final class Iterator2Counted
    implements CountedIterator {
        private final Iterator iter;
        private int count;

        private Iterator2Counted(Iterator iter, int count) {
            this.iter = iter;
            this.count = count;
        }

        public final boolean hasNext() {
            return this.iter.hasNext();
        }

        public final Object next() {
            if (this.iter.hasNext()) {
                --this.count;
            }
            return this.iter.next();
        }

        public final int numRemaining() {
            return this.count;
        }

        public final void remove() {
            throw new UnsupportedOperationException("cannot remove from this iterator");
        }
    }

    private static final class AttrDefData {
        private final HashMap objMap;
        private final byte valueType;
        private final byte[] keyTypes;

        private AttrDefData(HashMap objMap, byte valueType, byte[] keyTypes) {
            this.objMap = objMap;
            this.valueType = valueType;
            this.keyTypes = keyTypes;
        }
    }
}

