/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.readers.MetadataEntries;
import cytoscape.data.readers.MetadataParser;
import java.util.Map;
import junit.framework.TestCase;

public class MetadataParserTest
extends TestCase {
    MetadataParser mdp;
    CyNetwork network;

    protected void setUp() throws Exception {
        super.setUp();
        this.network = Cytoscape.getCurrentNetwork();
        this.mdp = new MetadataParser(this.network);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testMakeNewMetadataMap() {
        Map<String, String> newMap = this.mdp.makeNewMetadataMap();
        MetadataParserTest.assertNotNull(newMap);
        MetadataParserTest.assertEquals(MetadataEntries.values().length, newMap.size());
        MetadataParserTest.assertEquals((Object)"http://www.cytoscape.org/", (Object)newMap.get(MetadataEntries.SOURCE.toString()));
        MetadataParserTest.assertEquals((Object)"N/A", (Object)newMap.get(MetadataEntries.IDENTIFIER.toString()));
    }

    public void testSetMetadata() {
        System.out.println("### Metadata Parser is testing with network: " + this.network.getTitle() + " ###");
        this.mdp.setMetadata(MetadataEntries.SOURCE, "Gene Ontology");
        this.mdp.setMetadata(MetadataEntries.DESCRIPTION, "DAG created form OBO file.");
        Map metadata = Cytoscape.getNetworkAttributes().getMapAttribute(this.network.getIdentifier(), "Network Metadata");
        MetadataParserTest.assertNotNull(metadata);
        MetadataParserTest.assertEquals((Object)"Gene Ontology", metadata.get(MetadataEntries.SOURCE.toString()));
        MetadataParserTest.assertEquals((Object)"DAG created form OBO file.", metadata.get(MetadataEntries.DESCRIPTION.toString()));
    }
}

