/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.servers;

import cytoscape.CytoscapeInit;
import cytoscape.cruft.obo.BiologicalProcessAnnotationReader;
import cytoscape.cruft.obo.CellularComponentAnnotationReader;
import cytoscape.cruft.obo.MolecularFunctionAnnotationReader;
import cytoscape.cruft.obo.OboOntologyReader;
import cytoscape.cruft.obo.OboOntologyReader2;
import cytoscape.cruft.obo.SynonymReader;
import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.AnnotationDescription;
import cytoscape.data.annotation.Ontology;
import cytoscape.data.annotation.readers.AnnotationFlatFileReader;
import cytoscape.data.annotation.readers.AnnotationXmlReader;
import cytoscape.data.annotation.readers.OntologyFlatFileReader;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextHttpReader;
import cytoscape.data.readers.TextJarReader;
import cytoscape.data.servers.BioDataServerInterface;
import cytoscape.data.servers.BioDataServerRmi;
import cytoscape.data.synonyms.Thesaurus;
import cytoscape.data.synonyms.readers.ThesaurusFlatFileReader;
import cytoscape.logger.CyLogger;
import cytoscape.util.BioDataServerUtil;
import cytoscape.util.URLUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.rmi.Naming;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class BioDataServer {
    private static String GENE_ASSOCIATION_FILE = "gene_association";
    private static String OBO_FILE = "obo";
    protected BioDataServerInterface server;
    private static CyLogger logger = CyLogger.getLogger(BioDataServer.class);
    private boolean flip;
    private static final String TAXON_RESOURCE_FILE = "/cytoscape/resources/tax_report.txt";
    String taxonName;
    String taxonNumber;
    String absPath;
    String taxonFileName;
    File taxonFile;
    File start;
    Thesaurus thesaurus;
    HashMap attributeMap;
    HashMap ontologyTypeMap;
    BioDataServerUtil bdsu;
    BufferedReader taxonFileReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BioDataServer(String serverName) throws Exception {
        this.attributeMap = new HashMap();
        this.ontologyTypeMap = new HashMap();
        this.bdsu = new BioDataServerUtil();
        this.taxonFileReader = null;
        this.flip = false;
        this.thesaurus = new Thesaurus(CytoscapeInit.getProperties().getProperty("defaultSpeciesName"));
        this.taxonName = null;
        this.taxonNumber = null;
        this.start = CytoscapeInit.getMRUD();
        if (serverName.indexOf("rmi://") >= 0) {
            this.server = (BioDataServerInterface)Naming.lookup(serverName);
            return;
        }
        this.server = new BioDataServerRmi();
        File fileTester = new File(serverName);
        if (serverName.startsWith("jar://") || serverName.startsWith("http://") || !fileTester.isDirectory() && fileTester.canRead()) {
            boolean fileFlag;
            block9: {
                fileFlag = false;
                BufferedReader manFileIn = null;
                try {
                    manFileIn = new BufferedReader(new FileReader(serverName));
                    fileFlag = this.checkFileType(manFileIn);
                    Object var6_5 = null;
                    if (manFileIn == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (manFileIn == null) throw throwable;
                    manFileIn.close();
                    throw throwable;
                }
                manFileIn.close();
            }
            if (!fileFlag) {
                String[] thesaurusFilenames = this.parseLoadFile(serverName, "synonyms");
                this.loadThesaurusFiles(thesaurusFilenames);
                String[] ontologyFiles = this.parseLoadFile(serverName, "ontology");
                String[] annotationFilenames = this.parseLoadFile(serverName, "annotation");
                this.loadAnnotationFiles(annotationFilenames, ontologyFiles);
                return;
            }
            String[] flags = this.parseLoadFile(serverName, "flip");
            if (flags[0].endsWith("true")) {
                this.flip = true;
                logger.info("Cannonical and common names will be fliped...");
            } else {
                this.flip = false;
            }
            String[] oboFile = this.parseLoadFile(serverName, OBO_FILE);
            String[] geneAssociationFile = this.parseLoadFile(serverName, GENE_ASSOCIATION_FILE);
            try {
                this.loadObo(geneAssociationFile, oboFile);
                return;
            }
            catch (Exception e) {
                logger.warn("Unable to load OBO file: " + e.getMessage(), e);
                throw e;
            }
        }
        logger.warn("Could not read BioDataServer load file '" + serverName + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkFileType(BufferedReader br) throws IOException {
        String curLine = null;
        boolean rv = false;
        try {
            while (!rv && null != (curLine = br.readLine())) {
                if (!curLine.startsWith(OBO_FILE) && !curLine.startsWith(GENE_ASSOCIATION_FILE)) continue;
                rv = true;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            br.close();
            throw throwable;
        }
        br.close();
        return rv;
    }

    protected String[] parseLoadFile(String filename, String key) {
        String rawText;
        File absoluteDirectory = null;
        String httpUrlPrefix = null;
        boolean readingFromFileSystem = false;
        boolean readingFromWeb = false;
        try {
            Object reader;
            if (filename.trim().startsWith("jar://")) {
                reader = new TextJarReader(filename);
                ((TextJarReader)reader).read();
                rawText = ((TextJarReader)reader).getText();
            } else if (filename.trim().startsWith("http://")) {
                reader = new TextHttpReader(filename);
                ((TextHttpReader)reader).read();
                rawText = ((TextHttpReader)reader).getText();
                readingFromWeb = true;
                try {
                    URL url = new URL(filename);
                    String fullUrlString = url.toString();
                    httpUrlPrefix = fullUrlString.substring(0, fullUrlString.lastIndexOf("/"));
                }
                catch (Exception e) {
                    httpUrlPrefix = "url parsing error!";
                }
            } else {
                File file = new File(filename);
                readingFromFileSystem = true;
                absoluteDirectory = file.getAbsoluteFile().getParentFile();
                TextFileReader reader2 = new TextFileReader(filename);
                reader2.read();
                rawText = reader2.getText();
            }
        }
        catch (Exception e0) {
            logger.warn("-- Exception while reading annotation server load file " + filename, e0);
            return new String[0];
        }
        String[] lines = rawText.split("\n");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.trim().startsWith("#") || !line.startsWith(key)) continue;
            String fileToRead = line.substring(line.indexOf("=") + 1);
            if (readingFromFileSystem) {
                fileToRead = new File(absoluteDirectory, fileToRead).getPath();
            } else if (readingFromWeb) {
                fileToRead = httpUrlPrefix + "/" + fileToRead;
            }
            list.add(fileToRead);
        }
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new String[0]);
    }

    public BioDataServer() throws Exception {
        this.server = new BioDataServerRmi();
    }

    public Ontology[] readOntologyFlatFiles(String[] ontologyFilenames) throws Exception {
        Vector<Ontology> list = new Vector<Ontology>();
        for (int i = 0; i < ontologyFilenames.length; ++i) {
            String filename = ontologyFilenames[i];
            if (filename.endsWith(".xml")) continue;
            OntologyFlatFileReader reader = new OntologyFlatFileReader(filename);
            list.add(reader.getOntology());
        }
        return list.toArray(new Ontology[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Ontology[] readOntologyFlatFiles2(String[] ontologyFilenames) throws Exception {
        Vector<Ontology> list = new Vector<Ontology>();
        int i = 0;
        while (true) {
            block12: {
                Object var11_11;
                BufferedReader oboReader2;
                String filename;
                block11: {
                    Object var9_10;
                    if (i >= ontologyFilenames.length) {
                        return list.toArray(new Ontology[0]);
                    }
                    filename = ontologyFilenames[i];
                    BufferedReader oboReader = null;
                    oboReader2 = null;
                    try {
                        oboReader = new BufferedReader(new OboOntologyReader(new FileReader(filename)));
                        OntologyFlatFileReader reader = new OntologyFlatFileReader(oboReader);
                        list.add(reader.getOntology());
                        var9_10 = null;
                        if (oboReader == null) break block11;
                    }
                    catch (Throwable throwable) {
                        var9_10 = null;
                        if (oboReader != null) {
                            oboReader.close();
                        }
                        throw throwable;
                    }
                    oboReader.close();
                }
                try {
                    String line;
                    oboReader2 = new BufferedReader(new OboOntologyReader2(new FileReader(filename)));
                    String[] parts = null;
                    while ((line = oboReader2.readLine()) != null) {
                        parts = line.split("=");
                        if (parts.length != 2) continue;
                        if (parts[1].equals("biological_process")) {
                            this.ontologyTypeMap.put(parts[0], "P");
                            continue;
                        }
                        if (parts[1].equals("molecular_function")) {
                            this.ontologyTypeMap.put(parts[0], "F");
                            continue;
                        }
                        if (!parts[1].equals("cellular_component")) continue;
                        this.ontologyTypeMap.put(parts[0], "C");
                    }
                    var11_11 = null;
                    if (oboReader2 == null) break block12;
                }
                catch (Throwable throwable) {
                    var11_11 = null;
                    if (oboReader2 != null) {
                        oboReader2.close();
                    }
                    throw throwable;
                }
                oboReader2.close();
            }
            ++i;
        }
    }

    protected Ontology pickOntology(Ontology[] ontologies, Annotation annotation) {
        for (int i = 0; i < ontologies.length; ++i) {
            if (!ontologies[i].getCurator().equalsIgnoreCase(annotation.getCurator())) continue;
            return ontologies[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadObo(String[] annotationFilenames, String[] ontologyFilenames) throws Exception {
        Ontology[] ontologies = this.readOntologyFlatFiles2(ontologyFilenames);
        URL taxURL = this.getClass().getResource(TAXON_RESOURCE_FILE);
        int i = 0;
        while (true) {
            Annotation mfAnnotation;
            Annotation ccAnnotation;
            Annotation bpAnnotation;
            block17: {
                Object var19_19;
                String filename;
                block16: {
                    Object var17_18;
                    block15: {
                        Object var15_17;
                        String[] thFileName;
                        block14: {
                            Object var13_14;
                            if (i >= annotationFilenames.length) {
                                return;
                            }
                            bpAnnotation = null;
                            ccAnnotation = null;
                            mfAnnotation = null;
                            filename = annotationFilenames[i];
                            thFileName = new String[]{annotationFilenames[i]};
                            BufferedReader gaFileReader = null;
                            try {
                                gaFileReader = new BufferedReader(new FileReader(filename));
                                this.taxonFileReader = new BufferedReader(new InputStreamReader(URLUtil.getBasicInputStream(taxURL)));
                                this.taxonName = this.bdsu.checkSpecies(gaFileReader, this.taxonFileReader);
                                var13_14 = null;
                                if (gaFileReader == null) break block14;
                            }
                            catch (Throwable throwable) {
                                var13_14 = null;
                                if (gaFileReader != null) {
                                    gaFileReader.close();
                                }
                                throw throwable;
                            }
                            gaFileReader.close();
                        }
                        this.loadThesaurusFiles2(thFileName);
                        logger.info("Loading: " + annotationFilenames[i] + " (Species = " + this.taxonName + ")");
                        BufferedReader bpRd = null;
                        try {
                            bpRd = new BufferedReader(new BiologicalProcessAnnotationReader(this.taxonName, this.ontologyTypeMap, new FileReader(filename)));
                            AnnotationFlatFileReader bpReader = new AnnotationFlatFileReader(bpRd, this.thesaurus, this.flip);
                            bpAnnotation = bpReader.getAnnotation();
                            var15_17 = null;
                            if (bpRd == null) break block15;
                        }
                        catch (Throwable throwable) {
                            var15_17 = null;
                            if (bpRd != null) {
                                bpRd.close();
                            }
                            throw throwable;
                        }
                        bpRd.close();
                    }
                    BufferedReader ccRd = null;
                    try {
                        ccRd = new BufferedReader(new CellularComponentAnnotationReader(this.taxonName, this.ontologyTypeMap, new FileReader(filename)));
                        AnnotationFlatFileReader ccReader = new AnnotationFlatFileReader(ccRd, this.thesaurus, this.flip);
                        ccAnnotation = ccReader.getAnnotation();
                        var17_18 = null;
                        if (ccRd == null) break block16;
                    }
                    catch (Throwable throwable) {
                        var17_18 = null;
                        if (ccRd != null) {
                            ccRd.close();
                        }
                        throw throwable;
                    }
                    ccRd.close();
                }
                BufferedReader mfRd = null;
                try {
                    mfRd = new BufferedReader(new MolecularFunctionAnnotationReader(this.taxonName, this.ontologyTypeMap, new FileReader(filename)));
                    AnnotationFlatFileReader mfReader = new AnnotationFlatFileReader(mfRd, this.thesaurus, this.flip);
                    mfAnnotation = mfReader.getAnnotation();
                    var19_19 = null;
                    if (mfRd == null) break block17;
                }
                catch (Throwable throwable) {
                    var19_19 = null;
                    if (mfRd != null) {
                        mfRd.close();
                    }
                    throw throwable;
                }
                mfRd.close();
            }
            bpAnnotation.setOntology(this.pickOntology(ontologies, bpAnnotation));
            ccAnnotation.setOntology(this.pickOntology(ontologies, ccAnnotation));
            mfAnnotation.setOntology(this.pickOntology(ontologies, mfAnnotation));
            this.server.addAnnotation(bpAnnotation);
            this.server.addAnnotation(ccAnnotation);
            this.server.addAnnotation(mfAnnotation);
            ++i;
        }
    }

    public void loadAnnotationFiles(String[] annotationFilenames, String[] ontologyFilenames) throws Exception {
        Ontology[] ontologies = this.readOntologyFlatFiles(ontologyFilenames);
        for (int i = 0; i < annotationFilenames.length; ++i) {
            Annotation annotation;
            String filename = annotationFilenames[i];
            if (!filename.endsWith(".xml")) {
                AnnotationFlatFileReader reader = new AnnotationFlatFileReader(filename, this.thesaurus);
                annotation = reader.getAnnotation();
                annotation.setOntology(this.pickOntology(ontologies, annotation));
            } else {
                File xmlFile = new File(annotationFilenames[i]);
                AnnotationXmlReader reader = new AnnotationXmlReader(xmlFile);
                annotation = reader.getAnnotation();
            }
            this.server.addAnnotation(annotation);
        }
    }

    public void loadThesaurusFiles(String[] thesaurusFilenames) throws Exception {
        for (int i = 0; i < thesaurusFilenames.length; ++i) {
            String filename = thesaurusFilenames[i];
            ThesaurusFlatFileReader reader = new ThesaurusFlatFileReader(filename);
            this.thesaurus = reader.getThesaurus();
            this.server.addThesaurus(this.thesaurus.getSpecies(), this.thesaurus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadThesaurusFiles2(String[] thesaurusFilenames) throws Exception {
        for (int i = 0; i < thesaurusFilenames.length; ++i) {
            Object var7_6;
            String filename = thesaurusFilenames[i];
            BufferedReader thRd = null;
            try {
                thRd = new BufferedReader(new SynonymReader(this.taxonName, new FileReader(filename)));
                ThesaurusFlatFileReader reader = new ThesaurusFlatFileReader(thRd, this.flip);
                this.thesaurus = reader.getThesaurus();
                this.server.addThesaurus(this.thesaurus.getSpecies(), this.thesaurus);
                var7_6 = null;
                if (thRd == null) continue;
            }
            catch (Throwable throwable) {
                var7_6 = null;
                if (thRd != null) {
                    thRd.close();
                }
                throw throwable;
            }
            thRd.close();
            {
                continue;
            }
        }
    }

    public void clear() {
        try {
            this.server.clear();
        }
        catch (Exception e) {
            logger.warn("Error!  failed to clear", e);
        }
    }

    public void addAnnotation(Annotation annotation) {
        try {
            this.server.addAnnotation(annotation);
        }
        catch (Exception e) {
            logger.warn("Error!  failed to add annotation " + annotation, e);
        }
    }

    public int getAnnotationCount() {
        try {
            int count = this.server.getAnnotationCount();
            return count;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public AnnotationDescription[] getAnnotationDescriptions() {
        try {
            return this.server.getAnnotationDescriptions();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Annotation getAnnotation(String species, String curator, String type) {
        try {
            return this.server.getAnnotation(species, curator, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Annotation getAnnotation(AnnotationDescription description) {
        try {
            return this.server.getAnnotation(description);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int[] getClassifications(String species, String curator, String type, String entity) {
        try {
            return this.server.getClassifications(species, curator, type, entity);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int[] getClassifications(AnnotationDescription description, String entity) {
        try {
            return this.server.getClassifications(description, entity);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[][] getAllAnnotations(AnnotationDescription description, String entity) {
        try {
            return this.server.getAllAnnotations(description, entity);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String describe() {
        try {
            return this.server.describe();
        }
        catch (Exception e) {
            return "error connecting to data server";
        }
    }

    public void addThesaurus(String species, Thesaurus thesaurus) {
        try {
            this.server.addThesaurus(species, thesaurus);
        }
        catch (Exception e) {
            return;
        }
    }

    public String getCanonicalName(String species, String commonName) {
        try {
            return this.server.getCanonicalName(species, commonName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] getAllCommonNames(String species, String commonName) {
        try {
            return this.server.getAllCommonNames(species, commonName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getCommonName(String species, String canonicalName) {
        try {
            return this.server.getCommonName(species, canonicalName);
        }
        catch (Exception e) {
            return null;
        }
    }
}

