/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.ding;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.render.stateful.GraphLOD;
import cytoscape.util.PropUtil;
import cytoscape.view.CyNetworkView;
import ding.view.DGraphView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class CyGraphLOD
extends GraphLOD
implements PropertyChangeListener {
    protected int coarseDetailThreshold;
    protected int nodeBorderThreshold;
    protected int nodeLabelThreshold;
    protected int edgeArrowThreshold;
    protected int edgeLabelThreshold;

    public CyGraphLOD() {
        this.init();
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("PREFERENCES_UPDATED".equals(e.getPropertyName())) {
            this.init();
            Map<String, CyNetworkView> networkViewMap = Cytoscape.getNetworkViewMap();
            Iterator<CyNetworkView> foo = networkViewMap.values().iterator();
            while (foo.hasNext()) {
                ((DGraphView)((Object)foo.next())).setGraphLOD(this);
            }
        }
    }

    protected void init() {
        Properties p = CytoscapeInit.getProperties();
        this.coarseDetailThreshold = PropUtil.getInt(p, "render.coarseDetailThreshold", 2000);
        this.nodeBorderThreshold = PropUtil.getInt(p, "render.nodeBorderThreshold", 200);
        this.nodeLabelThreshold = PropUtil.getInt(p, "render.nodeLabelThreshold", 100);
        this.edgeArrowThreshold = PropUtil.getInt(p, "render.edgeArrowThreshold", 300);
        this.edgeLabelThreshold = PropUtil.getInt(p, "render.edgeLabelThreshold", 120);
    }

    @Deprecated
    protected int getInt(String key, int defaultValue) {
        return PropUtil.getInt(CytoscapeInit.getProperties(), key, defaultValue);
    }

    @Deprecated
    protected boolean getBoolean(String key, boolean defaultValue) {
        return PropUtil.getBoolean(CytoscapeInit.getProperties(), key, defaultValue);
    }

    public byte renderEdges(int visibleNodeCount, int totalNodeCount, int totalEdgeCount) {
        if (totalEdgeCount >= Math.min(this.edgeArrowThreshold, this.edgeLabelThreshold)) {
            return 0;
        }
        return 1;
    }

    public boolean detail(int renderNodeCount, int renderEdgeCount) {
        return renderNodeCount + renderEdgeCount < this.coarseDetailThreshold;
    }

    public boolean nodeBorders(int renderNodeCount, int renderEdgeCount) {
        return renderNodeCount < this.nodeBorderThreshold;
    }

    public boolean nodeLabels(int renderNodeCount, int renderEdgeCount) {
        return renderNodeCount < this.nodeLabelThreshold;
    }

    public boolean customGraphics(int renderNodeCount, int renderEdgeCount) {
        return renderNodeCount < this.nodeBorderThreshold;
    }

    public boolean edgeArrows(int renderNodeCount, int renderEdgeCount) {
        return renderEdgeCount < this.edgeArrowThreshold;
    }

    public boolean dashedEdges(int renderNodeCount, int renderEdgeCount) {
        return true;
    }

    public boolean edgeAnchors(int renderNodeCount, int renderEdgeCount) {
        return true;
    }

    public boolean edgeLabels(int renderNodeCount, int renderEdgeCount) {
        return renderEdgeCount < this.edgeLabelThreshold;
    }

    public boolean textAsShape(int renderNodeCount, int renderEdgeCount) {
        return false;
    }
}

