/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.render.stateful;

import cytoscape.geom.spacial.SpacialEntry2DEnumerator;
import cytoscape.geom.spacial.SpacialIndex2D;
import cytoscape.graph.fixed.FixedGraph;
import cytoscape.render.immed.EdgeAnchors;
import cytoscape.render.immed.GraphGraphics;
import cytoscape.render.stateful.CustomGraphic;
import cytoscape.render.stateful.EdgeDetails;
import cytoscape.render.stateful.GraphLOD;
import cytoscape.render.stateful.MeasuredLineCreator;
import cytoscape.render.stateful.NodeDetails;
import cytoscape.render.stateful.TextRenderingUtils;
import cytoscape.util.intr.IntEnumerator;
import cytoscape.util.intr.IntHash;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.Iterator;

public final class GraphRenderer {
    public static final int LOD_HIGH_DETAIL = 1;
    public static final int LOD_NODE_BORDERS = 2;
    public static final int LOD_NODE_LABELS = 4;
    public static final int LOD_EDGE_ARROWS = 8;
    public static final int LOD_DASHED_EDGES = 16;
    public static final int LOD_EDGE_ANCHORS = 32;
    public static final int LOD_EDGE_LABELS = 64;
    public static final int LOD_TEXT_AS_SHAPE = 128;
    public static final int LOD_CUSTOM_GRAPHICS = 256;
    private static final float[] s_floatTemp = new float[6];
    private static final int[] s_segTypeBuff = new int[200];
    private static final float[] s_floatBuff2 = new float[1200];

    private GraphRenderer() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int renderGraph(FixedGraph graph, SpacialIndex2D nodePositions, GraphLOD lod, NodeDetails nodeDetails, EdgeDetails edgeDetails, IntHash nodeBuff, GraphGraphics grafx, Paint bgPaint, double xCenter, double yCenter, double scaleFactor) {
        int node;
        int node2;
        int i;
        int nodeHitCount;
        int renderEdgeCount;
        int renderNodeCount;
        int i2;
        int runningNodeCount;
        nodeBuff.empty();
        float xMin = (float)(xCenter - 0.5 * (double)grafx.image.getWidth(null) / scaleFactor);
        float yMin = (float)(yCenter - 0.5 * (double)grafx.image.getHeight(null) / scaleFactor);
        float xMax = (float)(xCenter + 0.5 * (double)grafx.image.getWidth(null) / scaleFactor);
        float yMax = (float)(yCenter + 0.5 * (double)grafx.image.getHeight(null) / scaleFactor);
        float[] floatBuff1 = new float[4];
        float[] floatBuff2 = new float[4];
        float[] floatBuff3 = new float[2];
        float[] floatBuff4 = new float[2];
        float[] floatBuff5 = new float[8];
        double[] doubleBuff1 = new double[4];
        double[] doubleBuff2 = new double[2];
        GeneralPath path2d = new GeneralPath();
        SpacialEntry2DEnumerator nodeHits = nodePositions.queryOverlap(xMin, yMin, xMax, yMax, null, 0, false);
        int visibleNodeCount = nodeHits.numRemaining();
        int totalNodeCount = graph.nodes().numRemaining();
        int totalEdgeCount = graph.edges().numRemaining();
        byte renderEdges = lod.renderEdges(visibleNodeCount, totalNodeCount, totalEdgeCount);
        if (renderEdges > 0) {
            runningNodeCount = 0;
            for (i2 = 0; i2 < visibleNodeCount; ++i2) {
                nodeHits.nextExtents(floatBuff1, 0);
                if (floatBuff1[0] == floatBuff1[2] || floatBuff1[1] == floatBuff1[3]) continue;
                ++runningNodeCount;
            }
            renderNodeCount = runningNodeCount;
            renderEdgeCount = totalEdgeCount;
        } else if (renderEdges < 0) {
            runningNodeCount = 0;
            for (i2 = 0; i2 < visibleNodeCount; ++i2) {
                nodeHits.nextExtents(floatBuff1, 0);
                if (floatBuff1[0] == floatBuff1[2] || floatBuff1[1] == floatBuff1[3]) continue;
                ++runningNodeCount;
            }
            renderNodeCount = runningNodeCount;
            renderEdgeCount = 0;
        } else {
            runningNodeCount = 0;
            int runningEdgeCount = 0;
            for (int i3 = 0; i3 < visibleNodeCount; ++i3) {
                int node3 = nodeHits.nextExtents(floatBuff1, 0);
                if (floatBuff1[0] != floatBuff1[2] && floatBuff1[1] != floatBuff1[3]) {
                    ++runningNodeCount;
                }
                IntEnumerator touchingEdges = graph.edgesAdjacent(node3, true, true, true);
                int touchingEdgeCount = touchingEdges.numRemaining();
                for (int j = 0; j < touchingEdgeCount; ++j) {
                    int edge = touchingEdges.nextInt();
                    int otherNode = node3 ^ graph.edgeSource(edge) ^ graph.edgeTarget(edge);
                    if (nodeBuff.get(otherNode) >= 0) continue;
                    ++runningEdgeCount;
                }
                nodeBuff.put(node3);
            }
            renderNodeCount = runningNodeCount;
            renderEdgeCount = runningEdgeCount;
            nodeBuff.empty();
        }
        int lodTemp = 0;
        if (lod.detail(renderNodeCount, renderEdgeCount)) {
            lodTemp |= 1;
            if (lod.nodeBorders(renderNodeCount, renderEdgeCount)) {
                lodTemp |= 2;
            }
            if (lod.nodeLabels(renderNodeCount, renderEdgeCount)) {
                lodTemp |= 4;
            }
            if (lod.edgeArrows(renderNodeCount, renderEdgeCount)) {
                lodTemp |= 8;
            }
            if (lod.dashedEdges(renderNodeCount, renderEdgeCount)) {
                lodTemp |= 0x10;
            }
            if (lod.edgeAnchors(renderNodeCount, renderEdgeCount)) {
                lodTemp |= 0x20;
            }
            if (lod.edgeLabels(renderNodeCount, renderEdgeCount)) {
                lodTemp |= 0x40;
            }
            if (((lodTemp & 4) != 0 || (lodTemp & 0x40) != 0) && lod.textAsShape(renderNodeCount, renderEdgeCount)) {
                lodTemp |= 0x80;
            }
            if (lod.customGraphics(renderNodeCount, renderEdgeCount)) {
                lodTemp |= 0x100;
            }
        }
        int lodBits = lodTemp;
        grafx.clear(bgPaint, xCenter, yCenter, scaleFactor);
        if (renderEdges >= 0) {
            SpacialEntry2DEnumerator nodeHits2 = renderEdges > 0 ? nodePositions.queryOverlap(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, null, 0, false) : nodePositions.queryOverlap(xMin, yMin, xMax, yMax, null, 0, false);
            if ((lodBits & 1) == 0) {
                nodeHitCount = nodeHits2.numRemaining();
                for (i = 0; i < nodeHitCount; ++i) {
                    node2 = nodeHits2.nextExtents(floatBuff1, 0);
                    float nodeX = (floatBuff1[0] + floatBuff1[2]) / 2.0f;
                    float nodeY = (floatBuff1[1] + floatBuff1[3]) / 2.0f;
                    IntEnumerator touchingEdges = graph.edgesAdjacent(node2, true, true, true);
                    int touchingEdgeCount = touchingEdges.numRemaining();
                    for (int j = 0; j < touchingEdgeCount; ++j) {
                        int edge = touchingEdges.nextInt();
                        int otherNode = node2 ^ graph.edgeSource(edge) ^ graph.edgeTarget(edge);
                        if (nodeBuff.get(otherNode) >= 0) continue;
                        nodePositions.exists(otherNode, floatBuff2, 0);
                        grafx.drawEdgeLow(nodeX, nodeY, (floatBuff2[0] + floatBuff2[2]) / 2.0f, (floatBuff2[1] + floatBuff2[3]) / 2.0f, edgeDetails.colorLowDetail(edge));
                    }
                    nodeBuff.put(node2);
                }
            } else {
                while (nodeHits2.numRemaining() > 0) {
                    node = nodeHits2.nextExtents(floatBuff1, 0);
                    byte nodeShape = nodeDetails.shape(node);
                    IntEnumerator touchingEdges = graph.edgesAdjacent(node, true, true, true);
                    while (touchingEdges.numRemaining() > 0) {
                        EdgeAnchors anchors;
                        Paint trgArrowPaint;
                        Paint srcArrowPaint;
                        float trgArrowSize;
                        float srcArrowSize;
                        byte trgArrow;
                        byte srcArrow;
                        float[] trgExtents;
                        float[] srcExtents;
                        byte trgShape;
                        byte srcShape;
                        int edge = touchingEdges.nextInt();
                        int otherNode = node ^ graph.edgeSource(edge) ^ graph.edgeTarget(edge);
                        if (nodeBuff.get(otherNode) >= 0) continue;
                        if (!nodePositions.exists(otherNode, floatBuff2, 0)) {
                            throw new IllegalStateException("nodePositions not recognizing node that exists in graph");
                        }
                        byte otherNodeShape = nodeDetails.shape(otherNode);
                        if (node == graph.edgeSource(edge)) {
                            srcShape = nodeShape;
                            trgShape = otherNodeShape;
                            srcExtents = floatBuff1;
                            trgExtents = floatBuff2;
                        } else {
                            srcShape = otherNodeShape;
                            trgShape = nodeShape;
                            srcExtents = floatBuff2;
                            trgExtents = floatBuff1;
                        }
                        float thickness = edgeDetails.segmentThickness(edge);
                        Stroke edgeStroke = edgeDetails.segmentStroke(edge);
                        Paint segPaint = edgeDetails.segmentPaint(edge);
                        if ((lodBits & 8) == 0) {
                            srcArrow = -1;
                            trgArrow = -1;
                            srcArrowSize = 0.0f;
                            trgArrowSize = 0.0f;
                            srcArrowPaint = null;
                            trgArrowPaint = null;
                        } else {
                            srcArrow = edgeDetails.sourceArrow(edge);
                            trgArrow = edgeDetails.targetArrow(edge);
                            srcArrowSize = srcArrow == -1 ? 0.0f : edgeDetails.sourceArrowSize(edge);
                            trgArrowSize = trgArrow == -1 ? 0.0f : edgeDetails.targetArrowSize(edge);
                            srcArrowPaint = srcArrow == -1 ? null : edgeDetails.sourceArrowPaint(edge);
                            trgArrowPaint = trgArrow == -1 ? null : edgeDetails.targetArrowPaint(edge);
                        }
                        EdgeAnchors edgeAnchors = anchors = (lodBits & 0x20) == 0 ? null : edgeDetails.anchors(edge);
                        if (!GraphRenderer.computeEdgeEndpoints(grafx, srcExtents, srcShape, srcArrow, srcArrowSize, anchors, trgExtents, trgShape, trgArrow, trgArrowSize, floatBuff3, floatBuff4)) continue;
                        float srcXAdj = floatBuff3[0];
                        float srcYAdj = floatBuff3[1];
                        float trgXAdj = floatBuff4[0];
                        float trgYAdj = floatBuff4[1];
                        grafx.drawEdgeFull(srcArrow, srcArrowSize, srcArrowPaint, trgArrow, trgArrowSize, trgArrowPaint, srcXAdj, srcYAdj, anchors, trgXAdj, trgYAdj, thickness, edgeStroke, segPaint);
                        if (anchors != null) {
                            for (int k = 0; k < anchors.numAnchors(); ++k) {
                                float f;
                                float anchorSize = edgeDetails.anchorSize(edge, k);
                                if (!(f > 0.0f)) continue;
                                anchors.getAnchor(k, floatBuff4, 0);
                                grafx.drawNodeFull((byte)0, (float)((double)floatBuff4[0] - (double)anchorSize / 2.0), (float)((double)floatBuff4[1] - (double)anchorSize / 2.0), (float)((double)floatBuff4[0] + (double)anchorSize / 2.0), (float)((double)floatBuff4[1] + (double)anchorSize / 2.0), edgeDetails.anchorPaint(edge, k), 0.0f, null);
                            }
                        }
                        if ((lodBits & 0x40) == 0) continue;
                        int labelCount = edgeDetails.labelCount(edge);
                        for (int labelInx = 0; labelInx < labelCount; ++labelInx) {
                            double edgeAnchorPointY;
                            double edgeAnchorPointX;
                            String text = edgeDetails.labelText(edge, labelInx);
                            Font font = edgeDetails.labelFont(edge, labelInx);
                            double fontScaleFactor = edgeDetails.labelScaleFactor(edge, labelInx);
                            Paint paint = edgeDetails.labelPaint(edge, labelInx);
                            byte textAnchor = edgeDetails.labelTextAnchor(edge, labelInx);
                            byte edgeAnchor = edgeDetails.labelEdgeAnchor(edge, labelInx);
                            float offsetVectorX = edgeDetails.labelOffsetVectorX(edge, labelInx);
                            float offsetVectorY = edgeDetails.labelOffsetVectorY(edge, labelInx);
                            byte justify = text.indexOf(10) >= 0 ? (byte)edgeDetails.labelJustify(edge, labelInx) : (byte)64;
                            double edgeLabelWidth = edgeDetails.labelWidth(edge);
                            if (edgeAnchor == 17) {
                                edgeAnchorPointX = srcXAdj;
                                edgeAnchorPointY = srcYAdj;
                            } else if (edgeAnchor == 18) {
                                edgeAnchorPointX = trgXAdj;
                                edgeAnchorPointY = trgYAdj;
                            } else {
                                int subPathType;
                                int i4;
                                if (edgeAnchor != 16) throw new IllegalStateException("encountered an invalid EDGE_ANCHOR_* constant: " + edgeAnchor);
                                grafx.getEdgePath(srcArrow, srcArrowSize, trgArrow, trgArrowSize, srcXAdj, srcYAdj, anchors, trgXAdj, trgYAdj, path2d);
                                PathIterator pathIter = path2d.getPathIterator(null);
                                int numPathsTemp = 0;
                                while (!pathIter.isDone()) {
                                    ++numPathsTemp;
                                    pathIter.next();
                                }
                                int numPaths = numPathsTemp;
                                if (numPaths % 2 != 0) {
                                    pathIter = path2d.getPathIterator(null);
                                    for (i4 = numPaths / 2; i4 > 0; --i4) {
                                        pathIter.next();
                                    }
                                    subPathType = pathIter.currentSegment(floatBuff5);
                                    if (subPathType == 1) {
                                        edgeAnchorPointX = floatBuff5[0];
                                        edgeAnchorPointY = floatBuff5[1];
                                    } else if (subPathType == 2) {
                                        edgeAnchorPointX = floatBuff5[2];
                                        edgeAnchorPointY = floatBuff5[3];
                                    } else {
                                        if (subPathType != 3) throw new IllegalStateException("got unexpected PathIterator segment type: " + subPathType);
                                        edgeAnchorPointX = floatBuff5[4];
                                        edgeAnchorPointY = floatBuff5[5];
                                    }
                                } else {
                                    pathIter = path2d.getPathIterator(null);
                                    for (i4 = numPaths / 2; i4 > 0; --i4) {
                                        if (i4 == 1) {
                                            int subPathType2 = pathIter.currentSegment(floatBuff5);
                                            if (subPathType2 == 0 || subPathType2 == 1) {
                                                floatBuff5[6] = floatBuff5[0];
                                                floatBuff5[7] = floatBuff5[1];
                                            } else if (subPathType2 == 2) {
                                                floatBuff5[6] = floatBuff5[2];
                                                floatBuff5[7] = floatBuff5[3];
                                            } else {
                                                if (subPathType2 != 3) throw new IllegalStateException("got unexpected PathIterator segment type: " + subPathType2);
                                                floatBuff5[6] = floatBuff5[4];
                                                floatBuff5[7] = floatBuff5[5];
                                            }
                                        }
                                        pathIter.next();
                                    }
                                    subPathType = pathIter.currentSegment(floatBuff5);
                                    if (subPathType == 1) {
                                        edgeAnchorPointX = 0.5 * (double)floatBuff5[6] + 0.5 * (double)floatBuff5[0];
                                        edgeAnchorPointY = 0.5 * (double)floatBuff5[7] + 0.5 * (double)floatBuff5[1];
                                    } else if (subPathType == 2) {
                                        edgeAnchorPointX = 0.25 * (double)floatBuff5[6] + 0.5 * (double)floatBuff5[0] + 0.25 * (double)floatBuff5[2];
                                        edgeAnchorPointY = 0.25 * (double)floatBuff5[7] + 0.5 * (double)floatBuff5[1] + 0.25 * (double)floatBuff5[3];
                                    } else {
                                        if (subPathType != 3) throw new IllegalStateException("got unexpected PathIterator segment type: " + subPathType);
                                        edgeAnchorPointX = 0.125 * (double)floatBuff5[6] + 0.375 * (double)floatBuff5[0] + 0.375 * (double)floatBuff5[2] + 0.125 * (double)floatBuff5[4];
                                        edgeAnchorPointY = 0.125 * (double)floatBuff5[7] + 0.375 * (double)floatBuff5[1] + 0.375 * (double)floatBuff5[3] + 0.125 * (double)floatBuff5[5];
                                    }
                                }
                            }
                            MeasuredLineCreator measuredText = new MeasuredLineCreator(text, font, grafx.getFontRenderContextFull(), fontScaleFactor, (lodBits & 0x80) != 0, edgeLabelWidth);
                            doubleBuff1[0] = -0.5 * measuredText.getMaxLineWidth();
                            doubleBuff1[1] = -0.5 * measuredText.getTotalHeight();
                            doubleBuff1[2] = 0.5 * measuredText.getMaxLineWidth();
                            doubleBuff1[3] = 0.5 * measuredText.getTotalHeight();
                            GraphRenderer.lemma_computeAnchor(textAnchor, doubleBuff1, doubleBuff2);
                            double textXCenter = edgeAnchorPointX - doubleBuff2[0] + (double)offsetVectorX;
                            double textYCenter = edgeAnchorPointY - doubleBuff2[1] + (double)offsetVectorY;
                            TextRenderingUtils.renderHorizontalText(grafx, measuredText, font, fontScaleFactor, (float)textXCenter, (float)textYCenter, justify, paint, (lodBits & 0x80) != 0);
                        }
                    }
                    nodeBuff.put(node);
                }
            }
        }
        SpacialEntry2DEnumerator nodeHits3 = nodePositions.queryOverlap(xMin, yMin, xMax, yMax, null, 0, false);
        if ((lodBits & 1) == 0) {
            nodeHitCount = nodeHits3.numRemaining();
            for (i = 0; i < nodeHitCount; ++i) {
                node2 = nodeHits3.nextExtents(floatBuff1, 0);
                if (floatBuff1[0] == floatBuff1[2] || floatBuff1[1] == floatBuff1[3]) continue;
                grafx.drawNodeLow(floatBuff1[0], floatBuff1[1], floatBuff1[2], floatBuff1[3], nodeDetails.colorLowDetail(node2));
            }
            return lodBits;
        } else {
            while (nodeHits3.numRemaining() > 0) {
                node = nodeHits3.nextExtents(floatBuff1, 0);
                GraphRenderer.renderNodeHigh(graph, grafx, node, floatBuff1, doubleBuff1, doubleBuff2, nodeDetails, lodBits);
                if ((lodBits & 4) == 0) continue;
                int labelCount = nodeDetails.labelCount(node);
                for (int labelInx = 0; labelInx < labelCount; ++labelInx) {
                    String text = nodeDetails.labelText(node, labelInx);
                    Font font = nodeDetails.labelFont(node, labelInx);
                    double fontScaleFactor = nodeDetails.labelScaleFactor(node, labelInx);
                    Paint paint = nodeDetails.labelPaint(node, labelInx);
                    byte textAnchor = nodeDetails.labelTextAnchor(node, labelInx);
                    byte nodeAnchor = nodeDetails.labelNodeAnchor(node, labelInx);
                    float offsetVectorX = nodeDetails.labelOffsetVectorX(node, labelInx);
                    float offsetVectorY = nodeDetails.labelOffsetVectorY(node, labelInx);
                    byte justify = text.indexOf(10) >= 0 ? (byte)nodeDetails.labelJustify(node, labelInx) : (byte)64;
                    double nodeLabelWidth = nodeDetails.labelWidth(node);
                    doubleBuff1[0] = floatBuff1[0];
                    doubleBuff1[1] = floatBuff1[1];
                    doubleBuff1[2] = floatBuff1[2];
                    doubleBuff1[3] = floatBuff1[3];
                    GraphRenderer.lemma_computeAnchor(nodeAnchor, doubleBuff1, doubleBuff2);
                    double nodeAnchorPointX = doubleBuff2[0];
                    double nodeAnchorPointY = doubleBuff2[1];
                    MeasuredLineCreator measuredText = new MeasuredLineCreator(text, font, grafx.getFontRenderContextFull(), fontScaleFactor, (lodBits & 0x80) != 0, nodeLabelWidth);
                    doubleBuff1[0] = -0.5 * measuredText.getMaxLineWidth();
                    doubleBuff1[1] = -0.5 * measuredText.getTotalHeight();
                    doubleBuff1[2] = 0.5 * measuredText.getMaxLineWidth();
                    doubleBuff1[3] = 0.5 * measuredText.getTotalHeight();
                    GraphRenderer.lemma_computeAnchor(textAnchor, doubleBuff1, doubleBuff2);
                    double textXCenter = nodeAnchorPointX - doubleBuff2[0] + (double)offsetVectorX;
                    double textYCenter = nodeAnchorPointY - doubleBuff2[1] + (double)offsetVectorY;
                    TextRenderingUtils.renderHorizontalText(grafx, measuredText, font, fontScaleFactor, (float)textXCenter, (float)textYCenter, justify, paint, (lodBits & 0x80) != 0);
                }
            }
        }
        return lodBits;
    }

    private static final void lemma_computeAnchor(byte anchor, double[] input4x, double[] rtrn2x) {
        switch (anchor) {
            case 0: {
                rtrn2x[0] = (input4x[0] + input4x[2]) / 2.0;
                rtrn2x[1] = (input4x[1] + input4x[3]) / 2.0;
                break;
            }
            case 5: {
                rtrn2x[0] = (input4x[0] + input4x[2]) / 2.0;
                rtrn2x[1] = input4x[3];
                break;
            }
            case 4: {
                rtrn2x[0] = input4x[2];
                rtrn2x[1] = input4x[3];
                break;
            }
            case 3: {
                rtrn2x[0] = input4x[2];
                rtrn2x[1] = (input4x[1] + input4x[3]) / 2.0;
                break;
            }
            case 2: {
                rtrn2x[0] = input4x[2];
                rtrn2x[1] = input4x[1];
                break;
            }
            case 1: {
                rtrn2x[0] = (input4x[0] + input4x[2]) / 2.0;
                rtrn2x[1] = input4x[1];
                break;
            }
            case 8: {
                rtrn2x[0] = input4x[0];
                rtrn2x[1] = input4x[1];
                break;
            }
            case 7: {
                rtrn2x[0] = input4x[0];
                rtrn2x[1] = (input4x[1] + input4x[3]) / 2.0;
                break;
            }
            case 6: {
                rtrn2x[0] = input4x[0];
                rtrn2x[1] = input4x[3];
                break;
            }
            default: {
                throw new IllegalStateException("encoutered an invalid ANCHOR_* constant: " + anchor);
            }
        }
    }

    public static final boolean computeEdgeEndpoints(GraphGraphics grafx, float[] srcNodeExtents, byte srcNodeShape, byte srcArrow, float srcArrowSize, EdgeAnchors anchors, float[] trgNodeExtents, byte trgNodeShape, byte trgArrow, float trgArrowSize, float[] rtnValSrc, float[] rtnValTrg) {
        float trgYOut;
        float trgXOut;
        float srcYOut;
        float srcXOut;
        float srcX = (float)(((double)srcNodeExtents[0] + (double)srcNodeExtents[2]) / 2.0);
        float srcY = (float)(((double)srcNodeExtents[1] + (double)srcNodeExtents[3]) / 2.0);
        float trgX = (float)(((double)trgNodeExtents[0] + (double)trgNodeExtents[2]) / 2.0);
        float trgY = (float)(((double)trgNodeExtents[1] + (double)trgNodeExtents[3]) / 2.0);
        float[] floatBuff = new float[2];
        if (anchors != null && anchors.numAnchors() == 0) {
            anchors = null;
        }
        if (anchors == null) {
            srcXOut = trgX;
            srcYOut = trgY;
            trgXOut = srcX;
            trgYOut = srcY;
        } else {
            anchors.getAnchor(0, floatBuff, 0);
            srcXOut = floatBuff[0];
            srcYOut = floatBuff[1];
            anchors.getAnchor(anchors.numAnchors() - 1, floatBuff, 0);
            trgXOut = floatBuff[0];
            trgYOut = floatBuff[1];
        }
        GraphRenderer.calcIntersection(grafx, srcNodeShape, srcNodeExtents, srcX, srcY, srcXOut, srcYOut, floatBuff);
        float srcXAdj = floatBuff[0];
        float srcYAdj = floatBuff[1];
        GraphRenderer.calcIntersection(grafx, trgNodeShape, trgNodeExtents, trgX, trgY, trgXOut, trgYOut, floatBuff);
        float trgXAdj = floatBuff[0];
        float trgYAdj = floatBuff[1];
        rtnValSrc[0] = srcXAdj;
        rtnValSrc[1] = srcYAdj;
        rtnValTrg[0] = trgXAdj;
        rtnValTrg[1] = trgYAdj;
        return true;
    }

    private static void calcIntersection(GraphGraphics grafx, byte nodeShape, float[] nodeExtents, float x, float y, float xOut, float yOut, float[] retVal) {
        if (nodeExtents[0] == nodeExtents[2] || nodeExtents[1] == nodeExtents[3]) {
            retVal[0] = x;
            retVal[1] = y;
        } else if (!grafx.computeEdgeIntersection(nodeShape, nodeExtents[0], nodeExtents[1], nodeExtents[2], nodeExtents[3], 0.0f, xOut, yOut, retVal)) {
            float newYOut;
            float newXOut;
            double xCenter = ((double)nodeExtents[0] + (double)nodeExtents[2]) / 2.0;
            double yCenter = ((double)nodeExtents[1] + (double)nodeExtents[3]) / 2.0;
            double desiredDist = Math.max((double)nodeExtents[2] - (double)nodeExtents[0], (double)nodeExtents[3] - (double)nodeExtents[1]);
            double dX = (double)xOut - xCenter;
            double dY = (double)yOut - yCenter;
            double len = Math.sqrt(dX * dX + dY * dY);
            if (len == 0.0) {
                newXOut = (float)((double)xOut + desiredDist);
                newYOut = yOut;
            } else {
                newXOut = (float)(dX / len * desiredDist + (double)xOut);
                newYOut = (float)(dY / len * desiredDist + (double)yOut);
            }
            grafx.computeEdgeIntersection(nodeShape, nodeExtents[0], nodeExtents[1], nodeExtents[2], nodeExtents[3], 0.0f, newXOut, newYOut, retVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void computeClosedPath(PathIterator origPath, GeneralPath rtnVal) {
        float[] fArray = s_floatTemp;
        synchronized (s_floatTemp) {
            int i;
            int segs = 0;
            int offset = 0;
            GraphRenderer.s_segTypeBuff[segs++] = origPath.currentSegment(s_floatTemp);
            if (GraphRenderer.s_segTypeBuff[segs++] != 0) {
                throw new IllegalStateException("expected a SEG_MOVETO at the beginning of origPath");
            }
            for (i = 0; i < 2; ++i) {
                GraphRenderer.s_floatBuff2[offset++] = s_floatTemp[i];
            }
            origPath.next();
            while (!origPath.isDone()) {
                int segType = origPath.currentSegment(s_floatTemp);
                GraphRenderer.s_segTypeBuff[segs++] = segType;
                if (segType == 0 || segType == 4) {
                    throw new IllegalStateException("did not expect SEG_MOVETO or SEG_CLOSE");
                }
                int coordCount = segType * 2;
                for (int i2 = 0; i2 < coordCount; ++i2) {
                    GraphRenderer.s_floatBuff2[offset++] = s_floatTemp[i2];
                }
                origPath.next();
            }
            rtnVal.reset();
            offset = 0;
            block15: for (i = 0; i < segs; ++i) {
                switch (s_segTypeBuff[i]) {
                    case 0: {
                        rtnVal.moveTo(s_floatBuff2[offset++], s_floatBuff2[offset++]);
                        continue block15;
                    }
                    case 1: {
                        rtnVal.lineTo(s_floatBuff2[offset++], s_floatBuff2[offset++]);
                        continue block15;
                    }
                    case 2: {
                        rtnVal.quadTo(s_floatBuff2[offset++], s_floatBuff2[offset++], s_floatBuff2[offset++], s_floatBuff2[offset++]);
                        continue block15;
                    }
                    default: {
                        rtnVal.curveTo(s_floatBuff2[offset++], s_floatBuff2[offset++], s_floatBuff2[offset++], s_floatBuff2[offset++], s_floatBuff2[offset++], s_floatBuff2[offset++]);
                    }
                }
            }
            block16: for (i = segs - 1; i > 0; --i) {
                switch (s_segTypeBuff[i]) {
                    case 1: {
                        rtnVal.lineTo(s_floatBuff2[(offset -= 2) - 2], s_floatBuff2[offset - 1]);
                        continue block16;
                    }
                    case 2: {
                        rtnVal.quadTo(s_floatBuff2[offset -= 4], s_floatBuff2[offset + 1], s_floatBuff2[offset - 2], s_floatBuff2[offset - 1]);
                        continue block16;
                    }
                    default: {
                        rtnVal.curveTo(s_floatBuff2[(offset -= 6) + 2], s_floatBuff2[offset + 3], s_floatBuff2[offset], s_floatBuff2[offset + 1], s_floatBuff2[offset - 2], s_floatBuff2[offset - 1]);
                    }
                }
            }
            rtnVal.closePath();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void renderNodeHigh(FixedGraph graph, GraphGraphics grafx, int node, float[] floatBuff1, double[] doubleBuff1, double[] doubleBuff2, NodeDetails nodeDetails, int lodBits) {
        if (floatBuff1[0] != floatBuff1[2] && floatBuff1[1] != floatBuff1[3]) {
            Paint borderPaint;
            float borderWidth;
            byte shape = nodeDetails.shape(node);
            Paint fillPaint = nodeDetails.fillPaint(node);
            if ((lodBits & 2) == 0) {
                borderWidth = 0.0f;
                borderPaint = null;
            } else {
                borderWidth = nodeDetails.borderWidth(node);
                borderPaint = borderWidth == 0.0f ? null : nodeDetails.borderPaint(node);
            }
            grafx.drawNodeFull(shape, floatBuff1[0], floatBuff1[1], floatBuff1[2], floatBuff1[3], fillPaint, borderWidth, borderPaint);
        }
        if ((lodBits & 0x100) != 0) {
            TexturePaint nestedNetworkPaint = nodeDetails.getNestedNetworkTexturePaint(node);
            if (nestedNetworkPaint != null) {
                doubleBuff1[0] = floatBuff1[0];
                doubleBuff1[1] = floatBuff1[1];
                doubleBuff1[2] = floatBuff1[2];
                doubleBuff1[3] = floatBuff1[3];
                GraphRenderer.lemma_computeAnchor((byte)0, doubleBuff1, doubleBuff2);
                grafx.drawCustomGraphicFull(nestedNetworkPaint.getAnchorRect(), (float)doubleBuff2[0], (float)doubleBuff2[1], nestedNetworkPaint);
            }
            Object object = nodeDetails.customGraphicsLock(node);
            synchronized (object) {
                Iterator<CustomGraphic> dNodeIt = nodeDetails.customGraphics(node);
                CustomGraphic cg = null;
                int graphicInx = 0;
                while (dNodeIt.hasNext()) {
                    cg = dNodeIt.next();
                    float offsetVectorX = nodeDetails.graphicOffsetVectorX(node, graphicInx);
                    float offsetVectorY = nodeDetails.graphicOffsetVectorY(node, graphicInx);
                    doubleBuff1[0] = floatBuff1[0];
                    doubleBuff1[1] = floatBuff1[1];
                    doubleBuff1[2] = floatBuff1[2];
                    doubleBuff1[3] = floatBuff1[3];
                    GraphRenderer.lemma_computeAnchor((byte)0, doubleBuff1, doubleBuff2);
                    grafx.drawCustomGraphicFull(cg.getShape(), (float)(doubleBuff2[0] + (double)offsetVectorX), (float)(doubleBuff2[1] + (double)offsetVectorY), cg.getPaint());
                    ++graphicInx;
                }
            }
        }
    }
}

