/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.data.readers.GraphReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyFileFilter
extends FileFilter
implements FilenameFilter {
    private Hashtable filters = new Hashtable();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;
    protected Hashtable contentTypes = null;
    protected GraphReader reader = null;
    protected String fileNature = "UNKNOWN";

    public CyFileFilter() {
    }

    public CyFileFilter(String extension) {
        this(extension, null, null);
    }

    public CyFileFilter(String extension, String description) {
        this(extension, description, null);
    }

    public CyFileFilter(String[] filters) {
        this(filters, null, null);
    }

    public CyFileFilter(String[] filters, String description) {
        this(filters, description, null);
    }

    public CyFileFilter(String extension, String description, String nature) {
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
        if (nature != null) {
            this.setFileNature(nature);
        }
    }

    public CyFileFilter(String[] filters, String description, String nature) {
        for (int i = 0; i < filters.length; ++i) {
            this.addExtension(filters[i]);
        }
        if (description != null) {
            this.setDescription(description);
        }
        if (nature != null) {
            this.setFileNature(nature);
        }
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (this.filters.size() == 0) {
                return true;
            }
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null && this.filters.get(extension) != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean accept(File dir, String fileName) {
        return this.accept(new File(fileName));
    }

    public boolean accept(String fileName) {
        return this.accept(new File(fileName));
    }

    public boolean accept(URL url, String contentType) {
        if (contentType != null && this.contentTypes != null && this.contentTypes.get(contentType) != null) {
            return true;
        }
        String extension = this.getExtension(url.getFile());
        return extension != null && this.filters.get(extension) != null;
    }

    public String getExtension(File f) {
        if (f != null) {
            return this.getExtension(f.getName());
        }
        return null;
    }

    public String getExtension(String filename) {
        int i;
        if (filename != null && (i = filename.lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    public void addContentType(String type) {
        if (this.contentTypes == null) {
            this.contentTypes = new Hashtable(5);
        }
        this.contentTypes.put(type.toLowerCase(), this);
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Enumeration extensions = this.filters.keys();
                if (extensions != null) {
                    this.fullDescription = this.fullDescription + "*." + (String)(extensions.hasMoreElements() ? extensions.nextElement() : "*");
                    while (extensions.hasMoreElements()) {
                        this.fullDescription = this.fullDescription + ", *." + (String)extensions.nextElement();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public Set<String> getExtensionSet() {
        return this.filters.keySet();
    }

    public GraphReader getReader(String fileName) {
        return null;
    }

    public GraphReader getReader(URL url, URLConnection conn) {
        return null;
    }

    public String getFileNature() {
        if (this.fileNature == null) {
            return null;
        }
        return this.fileNature;
    }

    public void setFileNature(String nature) {
        this.fileNature = nature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getHeader(File file) throws IOException {
        BufferedReader bufferedReader = null;
        String header = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            header = this.parseHeader(bufferedReader);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getHeader(URL url) throws IOException {
        String header = null;
        InputStream is = null;
        try {
            BufferedReader br = null;
            URLConnection connection = url.openConnection();
            is = connection.getInputStream();
            try {
                br = new BufferedReader(new InputStreamReader(is));
                header = this.parseHeader(br);
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return header;
    }

    private String parseHeader(BufferedReader bufferedReader) throws IOException {
        StringBuffer header = new StringBuffer();
        String line = bufferedReader.readLine();
        for (int numLines = 0; line != null && numLines < 20; ++numLines) {
            header.append(line + "\n");
            line = bufferedReader.readLine();
        }
        return header.toString();
    }
}

