/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.logger.CyLogger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JnlpWriterUtil {
    public Document document;
    public Element rootTag;
    public XMLOutputter out;
    protected String fileName;
    protected String cytoDir;
    protected String url = "http://your.jnlp.location";
    protected String saveDir;
    public String libDir;
    public String pluginDir;
    protected HashMap<String, String> options;

    public JnlpWriterUtil(String[] args) {
        this.options = this.getOptions(args);
        this.fileName = this.options.get("filename");
        this.cytoDir = this.options.get("cyto_dir");
        this.saveDir = this.options.get("save_dir");
        if (this.options.containsKey("url")) {
            this.url = this.options.get("url");
        }
        this.libDir = this.cytoDir + "/lib";
        this.pluginDir = this.cytoDir + "/plugins";
        this.setupDoc();
    }

    private void setupDoc() {
        this.document = new Document();
        this.rootTag = new Element("jnlp");
        this.document.setRootElement(this.rootTag);
        if (!this.options.containsKey("url")) {
            Comment Codebase = new Comment("Replace the codebase URL with your own");
            this.rootTag.addContent(Codebase);
        }
        this.rootTag.setAttribute("codebase", this.url);
        this.rootTag.setAttribute("href", this.fileName);
        this.out = new XMLOutputter(Format.getPrettyFormat());
    }

    private static void print(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) throws Exception {
        JnlpWriterUtil jutil = new JnlpWriterUtil(args);
        ArrayList<String> MainLibs = jutil.getLibJars();
        JnlpWriterUtil.print("Adding " + MainLibs.size() + " total main jars");
        ArrayList<String> PluginLibs = jutil.getPluginJars();
        ArrayList<String> PluginClasses = jutil.getMainClass(PluginLibs, jutil.pluginDir);
        JnlpWriterUtil.print("Adding " + PluginLibs.size() + " total plugin jars");
        jutil.createInfoTag();
        jutil.createResourcesTag();
        jutil.addJars("lib/", MainLibs, null);
        jutil.addJars("plugins/", PluginLibs, "These are the plugins you wish to load, edit as necessary.");
        jutil.addArguments(PluginClasses);
        jutil.writeToFile();
    }

    public String getString() {
        return this.out.outputString(this.document);
    }

    public void writeToFile() throws IOException {
        File SaveDirCheck = new File(this.saveDir);
        if (!SaveDirCheck.exists()) {
            SaveDirCheck.mkdir();
        }
        FileWriter writer = new FileWriter(this.saveDir + "/" + this.fileName);
        this.out.output(this.document, (Writer)writer);
    }

    public void createInfoTag() {
        Element Info2 = new Element("information");
        Info2.addContent(new Element("title").setText("Cytoscape Webstart"));
        Info2.addContent(new Element("vendor").setText("Cytoscape Collaboration"));
        Info2.addContent(new Element("homepage").setAttribute("href", "http://cytoscape.org"));
        Info2.addContent(new Element("offline-allowed"));
        this.rootTag.addContent(new Element("security").addContent(new Element("all-permissions")));
        this.rootTag.addContent(Info2);
    }

    public void createResourcesTag() {
        Element Resources2 = new Element("resources");
        Element JSE = new Element("j2se");
        JSE.setAttribute("version", "1.5+");
        JSE.setAttribute("max-heap-size", "1024M");
        Resources2.addContent(JSE);
        Resources2.addContent(new Comment("All lib jars that cytoscape requires to run should be in this list"));
        Resources2.addContent(new Element("jar").setAttribute("href", "cytoscape.jar"));
        this.rootTag.addContent(Resources2);
    }

    public void addJars(String Prefix, ArrayList<String> Jars, String Comment2) {
        Element Resources2 = this.rootTag.getChild("resources");
        if (Comment2 != null) {
            Resources2.addContent(new Comment(Comment2));
        }
        for (int i = 0; i < Jars.size(); ++i) {
            Resources2.addContent(new Element("jar").setAttribute("href", Prefix + Jars.get(i)));
        }
    }

    public ArrayList<String> getLibJars() {
        return this.getJarList(this.libDir);
    }

    public ArrayList<String> getPluginJars() {
        return this.getJarList(this.pluginDir);
    }

    private ArrayList<String> getJarList(String Dir) {
        File JarDir = new File(Dir);
        if (!JarDir.exists()) {
            CyLogger.getLogger().warn("Required directory '" + JarDir.getAbsolutePath() + "' does not exist");
            System.exit(-1);
        }
        ArrayList<String> JarFiles = new ArrayList<String>();
        for (File Current : JarDir.listFiles()) {
            if (!Current.isFile() || !Current.getName().endsWith(".jar")) continue;
            JarFiles.add(Current.getName());
        }
        return JarFiles;
    }

    public ArrayList<String> getMainClass(ArrayList<String> JarFiles, String JarDir) {
        ArrayList<String> PluginMainClass = new ArrayList<String>();
        for (int i = 0; i < JarFiles.size(); ++i) {
            try {
                String className;
                JarFile jf = new JarFile(JarDir + "/" + JarFiles.get(i));
                Manifest m = jf.getManifest();
                if (m == null || (className = m.getMainAttributes().getValue("Cytoscape-Plugin")) == null) continue;
                PluginMainClass.add(className);
                continue;
            }
            catch (Exception E) {
                E.printStackTrace();
            }
        }
        return PluginMainClass;
    }

    private HashMap<String, String> getOptions(String[] args) {
        String Usage = "Usage: java " + this + " [parameters]\n" + "Option    : Description          Required\n" + "-filename : Name of jnlp file    yes\n" + "-cyto_dir : Cytoscape directory  yes\n" + "-url      : Webstart url         no\n" + "-save_dir : Save to dir          yes\n";
        HashMap<String, String> Opts = new HashMap<String, String>();
        if (args.length < 2) {
            CyLogger.getLogger().warn("Too few arguments (" + args.length + "). " + Usage);
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-filename")) {
                Opts.put("filename", args[i + 1]);
            }
            if (args[i].equals("-cyto_dir")) {
                Opts.put("cyto_dir", args[i + 1]);
            }
            if (args[i].equals("-url")) {
                Opts.put("url", args[i + 1]);
            }
            if (!args[i].equals("-save_dir")) continue;
            Opts.put("save_dir", args[i + 1]);
        }
        if (!(Opts.containsKey("filename") && Opts.containsKey("cyto_dir") && Opts.containsKey("save_dir"))) {
            CyLogger.getLogger().warn("Required arguments missing. " + Usage);
            System.exit(-1);
        }
        return Opts;
    }

    public void addArguments(ArrayList<String> Args) {
        Element Application2 = this.rootTag.getChild("application-desc");
        if (Application2 == null) {
            this.rootTag.addContent(new Comment("This starts-up Cytoscape, specify your plugins to load, and other command line arguments.  Plugins not specified here will not be loaded."));
            Application2 = new Element("application-desc").setAttribute("main-class", "cytoscape.CyMain");
            this.rootTag.addContent(Application2);
        }
        for (int i = 0; i < Args.size(); ++i) {
            Application2.addContent(new Element("argument").setText("-p"));
            Application2.addContent(new Element("argument").setText(Args.get(i)));
        }
    }
}

