/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.util.MathUtil;
import junit.framework.TestCase;

public class MathUtilTest
extends TestCase {
    public void testGetExponent() {
        MathUtilTest.assertEquals(-127, MathUtil.getExponent(0.0f));
        MathUtilTest.assertEquals(0, MathUtil.getExponent(1.0f));
        MathUtilTest.assertEquals(-1, MathUtil.getExponent(0.5f));
        MathUtilTest.assertEquals(-127, MathUtil.getExponent(Float.MIN_VALUE));
        MathUtilTest.assertEquals(127, MathUtil.getExponent(Float.MAX_VALUE));
    }

    public void testAlmostEqual() {
        MathUtilTest.assertTrue(MathUtil.almostEqual(1.2345614f, 1.234562f));
        MathUtilTest.assertTrue(MathUtil.almostEqual(1.2345615E30f, 1.234562E30f));
        MathUtilTest.assertTrue(MathUtil.almostEqual(0.0f, 0.0f));
        MathUtilTest.assertTrue(MathUtil.almostEqual(3.3f, 3.3f));
        MathUtilTest.assertFalse(MathUtil.almostEqual(0.0f, 1.0E-8f));
        MathUtilTest.assertFalse(MathUtil.almostEqual(-1.0E-7f, 1.0E-7f));
    }
}

