/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.intr.test;

import cytoscape.util.intr.IntEnumerator;
import cytoscape.util.intr.MinIntHeap;
import java.io.IOException;
import java.io.InputStream;

public class MinIntHeapPerformance {
    static MinIntHeap _THE_HEAP_ = null;

    public static void main(String[] args) throws Exception {
        int i;
        int read;
        int N = Integer.parseInt(args[0]);
        boolean repeat = false;
        if (args.length > 1 && args[1].equalsIgnoreCase("repeat")) {
            repeat = true;
        }
        int[] elements = new int[N];
        InputStream in = System.in;
        byte[] buff = new byte[4];
        int inx = 0;
        int off = 0;
        while (inx < N && (read = in.read(buff, off, buff.length - off)) > 0) {
            if ((off += read) < buff.length) continue;
            off = 0;
            elements[inx++] = (Integer.MAX_VALUE & MinIntHeapPerformance.assembleInt(buff)) % N;
        }
        if (inx < N) {
            throw new IOException("premature end of input");
        }
        in = null;
        buff = null;
        MinIntHeapPerformance._THE_TEST_CASE_(new int[]{0, 3, 4, 3, 9, 9, 1});
        Thread.sleep(1000L);
        for (int i2 = 0; i2 < 100; ++i2) {
            int foo = i2 * 4 / 8;
        }
        long millisBegin = System.currentTimeMillis();
        int[] uniqueElements = MinIntHeapPerformance._THE_TEST_CASE_(elements);
        long millisEnd = System.currentTimeMillis();
        if (!repeat) {
            System.err.println(millisEnd - millisBegin);
        }
        if (!repeat) {
            for (i = 0; i < uniqueElements.length; ++i) {
                System.out.println(uniqueElements[i]);
            }
        }
        if (repeat) {
            for (i = 0; i < uniqueElements.length; ++i) {
                uniqueElements[i] = 0;
            }
            millisBegin = System.currentTimeMillis();
            MinIntHeapPerformance._REPEAT_TEST_CASE_(elements, uniqueElements);
            millisEnd = System.currentTimeMillis();
            System.err.println(millisEnd - millisBegin + " (repeated test)");
            for (i = 0; i < uniqueElements.length; ++i) {
                System.out.println(uniqueElements[i]);
            }
        }
    }

    private static final int assembleInt(byte[] fourConsecutiveBytes) {
        int firstByte = (fourConsecutiveBytes[0] & 0xFF) << 24;
        int secondByte = (fourConsecutiveBytes[1] & 0xFF) << 16;
        int thirdByte = (fourConsecutiveBytes[2] & 0xFF) << 8;
        int fourthByte = (fourConsecutiveBytes[3] & 0xFF) << 0;
        return firstByte | secondByte | thirdByte | fourthByte;
    }

    private static final int[] _THE_TEST_CASE_(int[] elements) {
        _THE_HEAP_ = new MinIntHeap();
        _THE_HEAP_.toss(elements, 0, elements.length);
        IntEnumerator iter = _THE_HEAP_.orderedElements(true);
        int[] returnThis = new int[iter.numRemaining()];
        int numElements = returnThis.length;
        for (int i = 0; i < numElements; ++i) {
            returnThis[i] = iter.nextInt();
        }
        return returnThis;
    }

    private static final void _REPEAT_TEST_CASE_(int[] elements, int[] output) {
        _THE_HEAP_.empty();
        _THE_HEAP_.toss(elements, 0, elements.length);
        IntEnumerator iter = _THE_HEAP_.orderedElements(true);
        int numElements = iter.numRemaining();
        if (numElements != output.length) {
            throw new IllegalStateException("output array is incorrect size");
        }
        for (int i = 0; i < numElements; ++i) {
            output[i] = iter.nextInt();
        }
    }
}

