/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.swing;

import java.awt.Component;
import java.util.HashMap;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnResizer {
    private static final int DEFLMAX_WIDTH = 280;

    public static void adjustColumnPreferredWidths(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int col = 0; col < table.getColumnCount(); ++col) {
            int maxwidth = 0;
            for (int row = 0; row < table.getRowCount(); ++row) {
                TableCellRenderer rend = table.getCellRenderer(row, col);
                Object value = table.getValueAt(row, col);
                Component comp = rend.getTableCellRendererComponent(table, value, false, false, row, col);
                maxwidth = Math.max(comp.getPreferredSize().width, maxwidth);
            }
            TableColumn column = columnModel.getColumn(col);
            TableCellRenderer headerRenderer = column.getHeaderRenderer();
            if (headerRenderer == null) {
                headerRenderer = table.getTableHeader().getDefaultRenderer();
            }
            Object headerValue = column.getHeaderValue();
            Component headerComp = headerRenderer.getTableCellRendererComponent(table, headerValue, false, false, 0, col);
            if (280 < (maxwidth = Math.max(maxwidth, headerComp.getPreferredSize().width))) {
                maxwidth = 280;
            }
            column.setPreferredWidth(maxwidth + 20);
        }
    }

    public static HashMap<String, Integer> getColumnPreferredWidths(JTable table) {
        HashMap<String, Integer> retMap = new HashMap<String, Integer>();
        TableColumnModel columnModel = table.getColumnModel();
        for (int col = 0; col < table.getColumnCount(); ++col) {
            int maxwidth = 0;
            for (int row = 0; row < table.getRowCount(); ++row) {
                TableCellRenderer rend = table.getCellRenderer(row, col);
                Object value = table.getValueAt(row, col);
                Component comp = rend.getTableCellRendererComponent(table, value, false, false, row, col);
                maxwidth = Math.max(comp.getPreferredSize().width, maxwidth);
            }
            TableColumn column = columnModel.getColumn(col);
            TableCellRenderer headerRenderer = column.getHeaderRenderer();
            if (headerRenderer == null) {
                headerRenderer = table.getTableHeader().getDefaultRenderer();
            }
            Object headerValue = column.getHeaderValue();
            Component headerComp = headerRenderer.getTableCellRendererComponent(table, headerValue, false, false, 0, col);
            if (280 < (maxwidth = Math.max(maxwidth, headerComp.getPreferredSize().width))) {
                maxwidth = 280;
            }
            retMap.put(headerValue.toString(), new Integer(maxwidth + 20));
        }
        return retMap;
    }
}

