/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.visual.VisualPropertyDependency;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.converter.ValueToStringConverterManager;
import cytoscape.visual.parsers.ValueParser;
import giny.model.Edge;
import giny.model.GraphObject;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.Color;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Appearance {
    protected Map<VisualPropertyType, Object> vizProps = new EnumMap<VisualPropertyType, Object>(VisualPropertyType.class);

    public Appearance() {
        for (VisualPropertyType type : VisualPropertyType.values()) {
            this.vizProps.put(type, type.getVisualProperty().getDefaultAppearanceObject());
        }
    }

    public void set(VisualPropertyType p, Object o) {
        if (o != null) {
            this.vizProps.put(p, o);
        }
    }

    public Object get(VisualPropertyType p) {
        return this.vizProps.get((Object)p);
    }

    public void applyAppearance(NodeView nodeView, VisualPropertyDependency fdeps) {
        for (VisualPropertyType type : VisualPropertyType.values()) {
            if (!type.isNodeProp()) continue;
            type.getVisualProperty().applyToNodeView(nodeView, this.vizProps.get((Object)type), fdeps);
        }
    }

    public void applyAppearance(EdgeView edgeView, VisualPropertyDependency fdeps) {
        for (VisualPropertyType type : VisualPropertyType.values()) {
            if (type.isNodeProp()) continue;
            type.getVisualProperty().applyToEdgeView(edgeView, this.vizProps.get((Object)type), fdeps);
        }
    }

    public void applyDefaultProperties(Properties nacProps, String baseKey) {
        for (VisualPropertyType type : VisualPropertyType.values()) {
            Object o = type.getVisualProperty().parseProperty(nacProps, baseKey);
            if (o == null || !type.getVisualProperty().isValidValue(o)) continue;
            this.vizProps.put(type, o);
        }
    }

    public Properties getDefaultProperties(String baseKey) {
        Properties props = new Properties();
        for (VisualPropertyType type : VisualPropertyType.values()) {
            String key = type.getDefaultPropertyKey(baseKey);
            String value = ValueToStringConverterManager.manager.toString(this.vizProps.get((Object)type));
            if (key == null || value == null) continue;
            props.setProperty(key, value);
        }
        return props;
    }

    public String getDescription(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        String lineSep = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        for (VisualPropertyType type : VisualPropertyType.values()) {
            if (this.vizProps.get((Object)type) == null) continue;
            sb.append(prefix);
            sb.append(type.getName());
            sb.append(" = ");
            sb.append(ValueToStringConverterManager.manager.toString(this.vizProps.get((Object)type)));
            sb.append(lineSep);
        }
        return sb.toString();
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public void copy(Appearance na) {
        for (VisualPropertyType type : VisualPropertyType.values()) {
            this.vizProps.put(type, na.get(type));
        }
    }

    public Object clone() {
        Appearance ga = new Appearance();
        ga.copy(this);
        return ga;
    }

    public void applyBypass(GraphObject n, List<VisualPropertyType> bypassedVPs) {
        if (n == null) {
            return;
        }
        if (bypassedVPs == null || bypassedVPs.size() <= 0) {
            return;
        }
        String id = n.getIdentifier();
        CyAttributes attrs = null;
        if (n instanceof Node) {
            attrs = Cytoscape.getNodeAttributes();
        } else if (n instanceof Edge) {
            attrs = Cytoscape.getEdgeAttributes();
        } else {
            return;
        }
        for (VisualPropertyType type : bypassedVPs) {
            Object bypass = Appearance.getBypass(attrs, id, type);
            if (bypass == null) continue;
            this.vizProps.put(type, bypass);
        }
    }

    static Object getBypass(CyAttributes attrs, String id, VisualPropertyType type) {
        String attrName = type.getBypassAttrName();
        String value = attrs.getStringAttribute(id, attrName);
        if (value == null) {
            return null;
        }
        ValueParser p = type.getValueParser();
        Object ret = null;
        if (p == null) {
            return null;
        }
        ret = p.parseStringValue(value);
        if (ret == null || !(ret instanceof Color) || !ret.equals(Color.black)) {
            return ret;
        }
        String v = attrs.getStringAttribute(id, attrName);
        if (v == null) {
            return null;
        }
        if (v.equals("0,0,0")) {
            return ret;
        }
        return null;
    }
}

