/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.readers.CyAttributesReader;
import cytoscape.util.FileUtil;
import cytoscape.visual.ArrowShape;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorIO;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.LineStyle;
import cytoscape.visual.VisualPropertyDependencyImpl;
import cytoscape.visual.VisualPropertyType;
import java.awt.Color;
import java.awt.Font;
import java.io.FileReader;
import java.io.InputStream;
import java.util.Properties;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EdgeAppearanceCalculatorTest
extends TestCase {
    CyNetwork cyNet;
    CyNode a;
    CyNode b;
    CyEdge ab;
    CalculatorCatalog catalog;
    Properties props;

    public EdgeAppearanceCalculatorTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUp() {
        block5: {
            this.cyNet = Cytoscape.createNetworkFromFile("testData/small.sif");
            this.a = Cytoscape.getCyNode("a");
            this.b = Cytoscape.getCyNode("b");
            this.ab = Cytoscape.getCyEdge(this.a, this.b, "interaction", "pp", false);
            this.props = new Properties();
            try {
                CyAttributesReader.loadAttributes(Cytoscape.getEdgeAttributes(), new FileReader("testData/small.edgeAttr"));
                InputStream is = null;
                try {
                    is = FileUtil.getInputStream("testData/small.vizmap.props");
                    this.props.load(is);
                    Object var3_3 = null;
                    if (is == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.catalog = new CalculatorCatalog();
        CalculatorIO.loadCalculators(this.props, this.catalog, true);
    }

    public void testDefaultAppearance() {
        EdgeAppearanceCalculator eac = new EdgeAppearanceCalculator(new VisualPropertyDependencyImpl());
        EdgeAppearance ea = eac.calculateEdgeAppearance(this.ab, this.cyNet);
        EdgeAppearanceCalculatorTest.assertTrue("color", ((Color)ea.get(VisualPropertyType.EDGE_COLOR)).equals(Color.BLACK));
        EdgeAppearanceCalculatorTest.assertTrue("lineType", (LineStyle)((Object)ea.get(VisualPropertyType.EDGE_LINETYPE)) == LineStyle.SOLID);
        EdgeAppearanceCalculatorTest.assertTrue("src arrow", (ArrowShape)((Object)ea.get(VisualPropertyType.EDGE_SRCARROW_SHAPE)) == ArrowShape.NONE);
        EdgeAppearanceCalculatorTest.assertTrue("trg arrow", (ArrowShape)((Object)ea.get(VisualPropertyType.EDGE_TGTARROW_SHAPE)) == ArrowShape.NONE);
        EdgeAppearanceCalculatorTest.assertTrue("label", ((String)ea.get(VisualPropertyType.EDGE_LABEL)).equals(""));
        EdgeAppearanceCalculatorTest.assertTrue("tooltip", ((String)ea.get(VisualPropertyType.EDGE_TOOLTIP)).equals(""));
        EdgeAppearanceCalculatorTest.assertTrue("font size", ((Number)ea.get(VisualPropertyType.EDGE_FONT_SIZE)).intValue() == 10);
        EdgeAppearanceCalculatorTest.assertTrue("font style", ((Font)ea.get(VisualPropertyType.EDGE_FONT_FACE)).getStyle() == 0);
    }

    public void testApplyProperties() {
        EdgeAppearanceCalculator eac = new EdgeAppearanceCalculator(new VisualPropertyDependencyImpl());
        eac.applyProperties("homer", this.props, "edgeAppearanceCalculator.homer", this.catalog);
        EdgeAppearance ea = eac.calculateEdgeAppearance(this.ab, this.cyNet);
        System.out.println(eac.getDescription());
        System.out.println("color " + ea.get(VisualPropertyType.EDGE_COLOR));
        System.out.println("linetype " + ((LineStyle)((Object)ea.get(VisualPropertyType.EDGE_LINETYPE))).toString());
        System.out.println("src arrow " + ea.get(VisualPropertyType.EDGE_SRCARROW_SHAPE));
        System.out.println("trg arrow " + ea.get(VisualPropertyType.EDGE_TGTARROW_SHAPE));
        System.out.println("label " + (String)ea.get(VisualPropertyType.EDGE_LABEL));
        System.out.println("tooltip " + (String)ea.get(VisualPropertyType.EDGE_TOOLTIP));
        System.out.println("font size " + ((Number)ea.get(VisualPropertyType.EDGE_FONT_SIZE)).intValue());
        System.out.println("font style " + ((Font)ea.get(VisualPropertyType.EDGE_FONT_FACE)).getStyle());
        EdgeAppearanceCalculatorTest.assertTrue("color " + ea.get(VisualPropertyType.EDGE_COLOR), ((Color)ea.get(VisualPropertyType.EDGE_COLOR)).equals(new Color(132, 116, 144)));
        EdgeAppearanceCalculatorTest.assertTrue("src arrow " + ea.get(VisualPropertyType.EDGE_SRCARROW_SHAPE), (ArrowShape)((Object)ea.get(VisualPropertyType.EDGE_SRCARROW_SHAPE)) == ArrowShape.DIAMOND);
        EdgeAppearanceCalculatorTest.assertTrue("trg arrow " + ea.get(VisualPropertyType.EDGE_TGTARROW_SHAPE), (ArrowShape)((Object)ea.get(VisualPropertyType.EDGE_TGTARROW_SHAPE)) == ArrowShape.NONE);
        EdgeAppearanceCalculatorTest.assertTrue("label " + ea.get(VisualPropertyType.EDGE_LABEL), ((String)ea.get(VisualPropertyType.EDGE_LABEL)).equals("0.4"));
        EdgeAppearanceCalculatorTest.assertTrue("tooltip " + ea.get(VisualPropertyType.EDGE_TOOLTIP), ((String)ea.get(VisualPropertyType.EDGE_TOOLTIP)).equals(""));
        EdgeAppearanceCalculatorTest.assertTrue("font style " + ((Font)ea.get(VisualPropertyType.EDGE_FONT_FACE)).getStyle(), ((Font)ea.get(VisualPropertyType.EDGE_FONT_FACE)).getStyle() == 0);
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(EdgeAppearanceCalculatorTest.class));
    }
}

