/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.strokes.BackwardSlashStroke;
import cytoscape.visual.strokes.ContiguousArrowStroke;
import cytoscape.visual.strokes.DashDotStroke;
import cytoscape.visual.strokes.DotStroke;
import cytoscape.visual.strokes.EqualDashStroke;
import cytoscape.visual.strokes.ForwardSlashStroke;
import cytoscape.visual.strokes.LongDashStroke;
import cytoscape.visual.strokes.ParallelStroke;
import cytoscape.visual.strokes.PipeStroke;
import cytoscape.visual.strokes.SeparateArrowStroke;
import cytoscape.visual.strokes.SineWaveStroke;
import cytoscape.visual.strokes.SolidStroke;
import cytoscape.visual.strokes.VerticalSlashStroke;
import cytoscape.visual.strokes.WidthStroke;
import cytoscape.visual.strokes.ZeroStroke;
import cytoscape.visual.strokes.ZigzagStroke;
import cytoscape.visual.ui.icon.LineTypeIcon;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LineStyle {
    SOLID("line", new SolidStroke(1.0f)),
    LONG_DASH("dash", new LongDashStroke(1.0f)),
    EQUAL_DASH("equal_dash", new EqualDashStroke(1.0f)),
    DASH_DOT("dash_dot", new DashDotStroke(1.0f)),
    DOT("dot_dot", new DotStroke(1.0f)),
    ZIGZAG("zigzag", new ZigzagStroke(1.0f)),
    SINEWAVE("sinewave", new SineWaveStroke(1.0f)),
    VERTICAL_SLASH("vertical_slash", new VerticalSlashStroke(1.0f, PipeStroke.Type.VERTICAL)),
    FORWARD_SLASH("forward_slash", new ForwardSlashStroke(1.0f, PipeStroke.Type.FORWARD)),
    BACKWARD_SLASH("backward_slash", new BackwardSlashStroke(1.0f, PipeStroke.Type.BACKWARD)),
    PARALLEL_LINES("parallel_lines", new ParallelStroke(1.0f)),
    CONTIGUOUS_ARROW("contiguous_arrow", new ContiguousArrowStroke(1.0f)),
    SEPARATE_ARROW("separate_arrow", new SeparateArrowStroke(1.0f));

    private String regex;
    private WidthStroke stroke;

    private LineStyle(String regex, WidthStroke stroke) {
        this.regex = regex;
        this.stroke = stroke;
    }

    private String getRegex() {
        return this.regex;
    }

    public static LineStyle parse(String val) {
        for (LineStyle ls : LineStyle.values()) {
            if (!ls.toString().equals(val)) continue;
            return ls;
        }
        for (LineStyle ls : LineStyle.values()) {
            Pattern p = Pattern.compile(ls.getRegex(), 2);
            Matcher m = p.matcher(val);
            if (!m.matches()) continue;
            return ls;
        }
        return SOLID;
    }

    public static LineStyle extractLineStyle(Stroke s) {
        if (s instanceof WidthStroke) {
            return ((WidthStroke)s).getLineStyle();
        }
        return SOLID;
    }

    public Stroke getStroke(float width) {
        if (width <= 0.0f) {
            return new ZeroStroke(this.stroke);
        }
        return this.stroke.newInstanceForWidth(width);
    }

    public static Map<Object, Icon> getIconSet() {
        HashMap<Object, Icon> icons = new HashMap<Object, Icon>();
        for (LineStyle def : LineStyle.values()) {
            LineTypeIcon icon = new LineTypeIcon(def.getStroke(5.0f), 128, 32, def.name());
            icons.put((Object)def, icon);
        }
        return icons;
    }
}

