/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.customgraphic.ui;

import cytoscape.Cytoscape;
import cytoscape.visual.customgraphic.CyCustomGraphics;
import cytoscape.visual.customgraphic.Taggable;
import cytoscape.visual.customgraphic.impl.bitmap.URLImageCustomGraphics;
import cytoscape.visual.customgraphic.ui.CustomGraphicsBrowser;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXImageView;

public class CustomGraphicsDetailPanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = -412539582192509545L;
    private static final String TAG_DELIMITER = ",";
    private CyCustomGraphics cg;
    private JLabel heightLabel;
    private JTextField heightTextField;
    private JXImageView imageViewPanel;
    private JPanel infoPanel;
    private JCheckBox lockCheckBox;
    private JPanel modifyPanel;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JButton resetButton;
    private JLabel tagLabel;
    private JTextField tagTextField;
    private JLabel widthLabel;
    private JTextField widthTextField;
    private JButton searchButton;

    public CustomGraphicsDetailPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.infoPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.tagLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.tagTextField = new JTextField();
        this.imageViewPanel = new JXImageView();
        this.modifyPanel = new JPanel();
        this.widthLabel = new JLabel();
        this.widthTextField = new JTextField();
        this.heightLabel = new JLabel();
        this.lockCheckBox = new JCheckBox();
        this.heightTextField = new JTextField();
        this.resetButton = new JButton();
        this.searchButton = new JButton();
        this.infoPanel.setBorder(BorderFactory.createEtchedBorder());
        this.nameLabel.setText("Name:");
        this.tagLabel.setText("Tags:");
        this.nameTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomGraphicsDetailPanel.this.nameTextFieldActionPerformed(evt);
            }
        });
        this.tagTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomGraphicsDetailPanel.this.tagsTextFieldActionPerformed(evt);
            }
        });
        GroupLayout infoPanelLayout = new GroupLayout(this.infoPanel);
        this.infoPanel.setLayout(infoPanelLayout);
        infoPanelLayout.setHorizontalGroup(infoPanelLayout.createParallelGroup(1).add(infoPanelLayout.createSequentialGroup().addContainerGap().add(infoPanelLayout.createParallelGroup(1).add(this.tagLabel).add(this.nameLabel)).addPreferredGap(0).add(infoPanelLayout.createParallelGroup(1).add(this.nameTextField, -1, 491, Short.MAX_VALUE).add(this.tagTextField, -1, 491, Short.MAX_VALUE)).addContainerGap()));
        infoPanelLayout.setVerticalGroup(infoPanelLayout.createParallelGroup(1).add(infoPanelLayout.createSequentialGroup().addContainerGap().add(infoPanelLayout.createParallelGroup(3).add(this.nameLabel).add(this.nameTextField, -2, -1, -2)).addPreferredGap(0).add(infoPanelLayout.createParallelGroup(3).add(this.tagLabel).add(this.tagTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.imageViewPanel.setBorder(BorderFactory.createTitledBorder("Actual Size View"));
        GroupLayout imageViewPanelLayout = new GroupLayout(this.imageViewPanel);
        this.imageViewPanel.setLayout(imageViewPanelLayout);
        imageViewPanelLayout.setHorizontalGroup(imageViewPanelLayout.createParallelGroup(1).add(0, 573, Short.MAX_VALUE));
        imageViewPanelLayout.setVerticalGroup(imageViewPanelLayout.createParallelGroup(1).add(0, 228, Short.MAX_VALUE));
        this.modifyPanel.setBorder(BorderFactory.createEtchedBorder());
        this.widthLabel.setText("Width:");
        this.widthTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomGraphicsDetailPanel.this.widthTextFieldActionPerformed(evt);
            }
        });
        this.heightLabel.setText("Height:");
        this.lockCheckBox.setSelected(true);
        this.lockCheckBox.setText("Aspect Ratio");
        this.lockCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
            }
        });
        this.heightTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomGraphicsDetailPanel.this.heightTextFieldActionPerformed(evt);
            }
        });
        this.resetButton.setText("Original");
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomGraphicsDetailPanel.this.resetButtonActionPerformed(evt);
            }
        });
        this.searchButton.setText("Search");
        this.searchButton.setToolTipText("This function is not implemented yet.");
        this.searchButton.setEnabled(false);
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomGraphicsDetailPanel.this.optionButtonActionPerformed(evt);
            }
        });
        GroupLayout modifyPanelLayout = new GroupLayout(this.modifyPanel);
        this.modifyPanel.setLayout(modifyPanelLayout);
        modifyPanelLayout.setHorizontalGroup(modifyPanelLayout.createParallelGroup(1).add(modifyPanelLayout.createSequentialGroup().addContainerGap().add(this.widthLabel).addPreferredGap(0).add(this.widthTextField, -2, 60, -2).addPreferredGap(0).add(this.heightLabel).addPreferredGap(0).add(this.heightTextField, -2, 60, -2).addPreferredGap(0).add(this.lockCheckBox).addPreferredGap(0).add(this.resetButton).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.searchButton).add(8, 8, 8)));
        modifyPanelLayout.setVerticalGroup(modifyPanelLayout.createParallelGroup(1).add(modifyPanelLayout.createSequentialGroup().addContainerGap().add(modifyPanelLayout.createParallelGroup(3).add(this.widthLabel).add(this.widthTextField, -2, -1, -2).add(this.heightLabel).add(this.heightTextField, -2, -1, -2).add(this.lockCheckBox).add(this.resetButton).add(this.searchButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.infoPanel, -1, -1, Short.MAX_VALUE).add(2, this.modifyPanel, -1, -1, Short.MAX_VALUE).add(this.imageViewPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.infoPanel, -2, -1, -2).addPreferredGap(0).add(this.imageViewPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add(this.modifyPanel, -2, -1, -2)));
    }

    private void nameTextFieldActionPerformed(ActionEvent evt) {
        String newName = this.nameTextField.getText();
        if (newName != null && newName.trim().length() != 0 && this.cg != null) {
            this.cg.setDisplayName(this.nameTextField.getText());
        }
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        if (this.cg == null || this.cg.getRenderedImage() == null) {
            return;
        }
        if (this.cg instanceof URLImageCustomGraphics) {
            Image image = ((URLImageCustomGraphics)this.cg).resetImage();
            this.imageViewPanel.setImage(image);
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            this.widthTextField.setText(Integer.toString(w));
            this.heightTextField.setText(Integer.toString(h));
            this.cg.setWidth(w);
            this.cg.setHeight(h);
            Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
        }
    }

    private void widthTextFieldActionPerformed(ActionEvent evt) {
        this.resizeImage(true);
    }

    private void heightTextFieldActionPerformed(ActionEvent evt) {
        this.resizeImage(false);
    }

    private void resizeImage(boolean isWidth) {
        Integer h;
        Integer w;
        String width = this.widthTextField.getText();
        String height = this.heightTextField.getText();
        Image currentImage = this.cg.getRenderedImage();
        if (currentImage == null) {
            return;
        }
        boolean lock = this.lockCheckBox.isSelected();
        int currentW = currentImage.getWidth(null);
        int currentH = currentImage.getHeight(null);
        try {
            w = Integer.parseInt(width);
            h = Integer.parseInt(height);
        }
        catch (NumberFormatException e) {
            this.widthTextField.setText(Integer.toString(currentW));
            this.heightTextField.setText(Integer.toString(currentH));
            return;
        }
        if (!lock) {
            this.cg.setWidth(w);
            this.cg.setHeight(h);
            this.imageViewPanel.setImage(this.cg.getRenderedImage());
        } else if (isWidth) {
            float ratio = (float)currentH / (float)currentW;
            int converted = (int)((float)w.intValue() * ratio);
            this.cg.setWidth(w);
            this.cg.setHeight(converted);
            this.imageViewPanel.setImage(this.cg.getRenderedImage());
            this.heightTextField.setText(Integer.toString(converted));
        } else {
            float ratio = (float)currentW / (float)currentH;
            int converted = (int)((float)h.intValue() * ratio);
            this.cg.setWidth(converted);
            this.cg.setHeight(h);
            this.imageViewPanel.setImage(this.cg.getRenderedImage());
            this.widthTextField.setText(Integer.toString(converted));
        }
        Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
    }

    private void tagsTextFieldActionPerformed(ActionEvent evt) {
        String tagStr = this.tagTextField.getText();
        if (tagStr != null && tagStr.trim().length() != 0 && this.cg instanceof Taggable) {
            String[] tags;
            for (String tag : tags = tagStr.split(TAG_DELIMITER)) {
                ((Taggable)((Object)this.cg)).getTags().add(tag.trim());
            }
        }
    }

    private void optionButtonActionPerformed(ActionEvent evt) {
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!(e.getSource() instanceof CustomGraphicsBrowser) || e.getValueIsAdjusting()) {
            return;
        }
        CustomGraphicsBrowser browser = (CustomGraphicsBrowser)e.getSource();
        this.cg = (CyCustomGraphics)browser.getSelectedValue();
        if (this.cg == null) {
            this.imageViewPanel.setImage((Image)null);
            this.heightTextField.setText(null);
            this.widthTextField.setText(null);
            this.nameTextField.setText(null);
            this.nameTextField.setToolTipText(null);
            this.tagTextField.setText(null);
            return;
        }
        Image img = this.cg.getRenderedImage();
        this.imageViewPanel.setImage(img);
        this.heightTextField.setText(Integer.toString(img.getHeight(null)));
        this.widthTextField.setText(Integer.toString(img.getWidth(null)));
        this.nameTextField.setText(this.cg.getDisplayName());
        this.nameTextField.setToolTipText(this.cg.getDisplayName());
        if (this.cg instanceof Taggable) {
            Collection<String> tags = ((Taggable)((Object)this.cg)).getTags();
            int tagCount = tags.size();
            int counter = 0;
            StringBuilder tagBuilder = new StringBuilder();
            for (String tag : tags) {
                tagBuilder.append(tag);
                if (tagCount == ++counter) continue;
                tagBuilder.append(", ");
            }
            this.tagTextField.setText(tagBuilder.toString());
            this.tagTextField.setToolTipText(tagBuilder.toString());
        }
    }
}

