/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.parsers;

import cytoscape.visual.parsers.ValueParser;
import java.awt.Font;

public class FontParser
implements ValueParser {
    public Font parseStringValue(String value) {
        return this.parseFont(value);
    }

    public Font parseFont(String value) {
        if (value == null) {
            return null;
        }
        int comma1 = value.indexOf(",");
        if (comma1 < 1 || comma1 >= value.length() - 1) {
            return null;
        }
        int comma2 = value.indexOf(",", comma1 + 1);
        if (comma2 == -1 || comma2 == comma1 + 1 || comma2 >= value.length() - 1) {
            return null;
        }
        String name = value.substring(0, comma1);
        String typeString = value.substring(comma1 + 1, comma2);
        String sizeString = value.substring(comma2 + 1, value.length());
        int type = 0;
        if (typeString.equalsIgnoreCase("bold")) {
            type = 1;
        } else if (typeString.equalsIgnoreCase("italic")) {
            type = 2;
        } else if (typeString.equalsIgnoreCase("bold|italic")) {
            type = 3;
        } else if (typeString.equalsIgnoreCase("italic|bold")) {
            type = 3;
        }
        int size = 0;
        try {
            size = Integer.parseInt(sizeString);
        }
        catch (NumberFormatException e) {
            return null;
        }
        Font f = new Font(name, type, size);
        return f;
    }
}

