/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.visual.ArrowShape;
import cytoscape.visual.LineStyle;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.customgraphic.CyCustomGraphics;
import cytoscape.visual.ui.editors.discrete.CustomGraphicsCellRenderer;
import cytoscape.visual.ui.editors.discrete.CyColorCellRenderer;
import cytoscape.visual.ui.editors.discrete.FontCellRenderer;
import cytoscape.visual.ui.editors.discrete.ObjectPositionCellRenderer;
import cytoscape.visual.ui.editors.discrete.ShapeCellRenderer;
import giny.view.ObjectPosition;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellRendererFactory {
    private final Map<Class<?>, TableCellRenderer> rendererMap = new HashMap();
    protected static final TableCellRenderer DEF_RENDERER = new DefaultTableCellRenderer();

    CellRendererFactory() {
        this.registerDefaultRenderers();
    }

    private void registerDefaultRenderers() {
        this.rendererMap.put(Color.class, new CyColorCellRenderer());
        this.rendererMap.put(NodeShape.class, new ShapeCellRenderer(VisualPropertyType.NODE_SHAPE));
        this.rendererMap.put(LineStyle.class, new ShapeCellRenderer(VisualPropertyType.EDGE_LINE_STYLE));
        this.rendererMap.put(ArrowShape.class, new ShapeCellRenderer(VisualPropertyType.EDGE_TGTARROW_SHAPE));
        this.rendererMap.put(Font.class, new FontCellRenderer());
        this.rendererMap.put(ObjectPosition.class, new ObjectPositionCellRenderer());
        this.rendererMap.put(CyCustomGraphics.class, new CustomGraphicsCellRenderer());
        this.rendererMap.put(String.class, DEF_RENDERER);
        this.rendererMap.put(Number.class, DEF_RENDERER);
    }

    protected TableCellRenderer getCellRenderer(Class<?> type) {
        TableCellRenderer rend = this.rendererMap.get(type);
        if (rend == null) {
            return DEF_RENDERER;
        }
        return rend;
    }

    protected void register(Class<?> type, TableCellRenderer renderer) {
        this.rendererMap.put(type, renderer);
    }
}

