/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.Cytoscape;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.ui.icon.VisualPropertyIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.JXTitledPanel;
import org.jdesktop.swingx.border.DropShadowBorder;

public class ValueSelectDialog
extends JDialog {
    private static final long serialVersionUID = 1201804212862509435L;
    private final VisualPropertyType type;
    private Map<Object, Icon> iconMap;
    private List orderedKeyList;
    private Object originalValue;
    private boolean canceled = false;
    private static final int WIDTH = 480;
    private final int height;
    private final String listTitle;
    private static final int ICON_CELL_HEIGHT = 140;
    private JButton applyButton;
    private JButton cancelButton;
    private JXList iconList;
    private JScrollPane iconListScrollPane;
    private JXTitledPanel mainPanel;
    private DefaultListModel model;

    public static Object showDialog(VisualPropertyType type, Window parent) {
        ValueSelectDialog dialog = new ValueSelectDialog(type, parent, true);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.getValue();
    }

    private ValueSelectDialog(VisualPropertyType type, Window parent, boolean modal) {
        super((Frame)Cytoscape.getDesktop(), modal);
        Toolkit toolkit = this.getToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        this.height = (int)(screenSize.getHeight() * 0.7);
        this.type = type;
        this.iconMap = this.type.getVisualProperty().getIconSet();
        this.initComponents();
        this.setList();
        if (type.equals((Object)VisualPropertyType.NODE_CUSTOM_GRAPHICS_1)) {
            this.iconList.setFixedCellHeight(140);
            this.listTitle = "Custom Graphics";
        } else {
            this.listTitle = type.getName();
        }
        this.mainPanel.setTitle(this.listTitle);
        this.originalValue = type.isNodeProp() ? Cytoscape.getVisualMappingManager().getVisualStyle().getNodeAppearanceCalculator().getDefaultAppearance().get(type) : Cytoscape.getVisualMappingManager().getVisualStyle().getEdgeAppearanceCalculator().getDefaultAppearance().get(type);
    }

    private void initComponents() {
        this.mainPanel = new JXTitledPanel();
        this.iconListScrollPane = new JScrollPane();
        this.iconList = new JXList(true);
        this.applyButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Select New Value");
        this.mainPanel.setTitle(this.listTitle);
        this.mainPanel.setTitleFont(new Font("SansSerif", 1, 14));
        this.iconList.setSelectionMode(0);
        this.iconListScrollPane.setViewportView(this.iconList);
        this.applyButton.setText("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValueSelectDialog.this.applyButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValueSelectDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setVisible(true);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel.getContentContainer());
        this.mainPanel.getContentContainer().setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(1).add(2, mainPanelLayout.createSequentialGroup().addContainerGap(128, Short.MAX_VALUE).add(this.cancelButton).addPreferredGap(0).add(this.applyButton).addContainerGap()).add(this.iconListScrollPane, -1, 480, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(1).add(2, mainPanelLayout.createSequentialGroup().add(this.iconListScrollPane, -1, this.height, Short.MAX_VALUE).addPreferredGap(0).add(mainPanelLayout.createParallelGroup(3).add(this.applyButton).add(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.mainPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(this.mainPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
        this.canceled = true;
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public Object getValue() {
        if (this.canceled) {
            return this.originalValue;
        }
        int selectedIndex = this.iconList.getSelectedIndex();
        if (0 <= selectedIndex && selectedIndex < this.orderedKeyList.size()) {
            return this.orderedKeyList.get(selectedIndex);
        }
        return this.originalValue;
    }

    private void setList() {
        this.orderedKeyList = new ArrayList();
        this.model = new DefaultListModel();
        this.iconList.setModel((ListModel)this.model);
        HashMap<String, VisualPropertyIcon> name2icon = new HashMap<String, VisualPropertyIcon>();
        HashMap<String, Object> name2value = new HashMap<String, Object>();
        for (Object key : this.iconMap.keySet()) {
            VisualPropertyIcon icon = (VisualPropertyIcon)this.iconMap.get(key);
            if (this.type == VisualPropertyType.EDGE_SRCARROW_SHAPE || this.type == VisualPropertyType.EDGE_TGTARROW_SHAPE) {
                icon.setIconWidth(icon.getIconWidth() * 3);
            }
            if (this.type.equals((Object)VisualPropertyType.NODE_SHAPE) && !((NodeShape)((Object)key)).isSupported()) continue;
            String keyName = icon.getName();
            if (name2icon.containsKey(keyName)) {
                name2icon.put(keyName + key.hashCode(), icon);
                name2value.put(keyName + key.hashCode(), key);
                continue;
            }
            name2icon.put(keyName, icon);
            name2value.put(keyName, key);
        }
        TreeSet sortedSet = new TreeSet(name2icon.keySet());
        for (String key : sortedSet) {
            this.orderedKeyList.add(name2value.get(key));
            this.model.addElement(name2icon.get(key));
        }
        this.iconList.setCellRenderer((ListCellRenderer)new IconCellRenderer());
        this.iconList.repaint();
    }

    private static final class IconCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -7235212695832080213L;
        private final Font SELECTED_FONT = new Font("SansSerif", 2, 18);
        private final Font NORMAL_FONT = new Font("SansSerif", 1, 14);
        private final Color SELECTED_COLOR = new Color(30, 30, 80, 25);
        private final Color SELECTED_FONT_COLOR = new Color(0, 150, 255, 120);
        private final Border DROPHSADOW = new DropShadowBorder();

        public IconCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            VisualPropertyIcon icon = (VisualPropertyIcon)value;
            if (value != null) {
                this.setText(icon.getName());
            }
            if (icon != null) {
                this.setIcon(icon);
                this.setFont(isSelected ? this.SELECTED_FONT : this.NORMAL_FONT);
                icon.setLeftPadding(30);
                this.setPreferredSize(new Dimension(icon.getIconWidth() + 300, icon.getIconHeight() + 20));
            }
            this.setVerticalTextPosition(0);
            this.setVerticalAlignment(0);
            this.setIconTextGap(60);
            this.setBackground(isSelected ? this.SELECTED_COLOR : list.getBackground());
            this.setForeground(isSelected ? this.SELECTED_FONT_COLOR : list.getForeground());
            this.setBorder(this.DROPHSADOW);
            return this;
        }
    }
}

