/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyEditorRegistry;
import com.l2fprod.common.propertysheet.PropertyRendererRegistry;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import com.l2fprod.common.propertysheet.PropertySheetTable;
import com.l2fprod.common.propertysheet.PropertySheetTableModel;
import com.l2fprod.common.swing.plaf.blue.BlueishButtonUI;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.CyAttributesUtils;
import cytoscape.data.attr.MultiHashMapDefinitionListener;
import cytoscape.logger.CyLogger;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.util.SwingWorker;
import cytoscape.util.swing.DropDownMenuButton;
import cytoscape.view.CyNetworkView;
import cytoscape.view.NetworkPanel;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualPropertyDependency;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import cytoscape.visual.ui.CellEditorFactory;
import cytoscape.visual.ui.CellRendererFactory;
import cytoscape.visual.ui.DefaultAppearenceBuilder;
import cytoscape.visual.ui.DefaultViewPanel;
import cytoscape.visual.ui.DiscretePropertySetter;
import cytoscape.visual.ui.LegendDialog;
import cytoscape.visual.ui.MappingKeyFactory;
import cytoscape.visual.ui.NewMappingBuilder;
import cytoscape.visual.ui.RedrawTask;
import cytoscape.visual.ui.VizMapperProperty;
import cytoscape.visual.ui.editors.continuous.ContinuousMappingEditorPanel;
import cytoscape.visual.ui.editors.discrete.CyComboBoxPropertyEditor;
import ding.view.DGraphView;
import giny.model.GraphObject;
import giny.model.Node;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VizMapperMainPanel
extends JPanel
implements PropertyChangeListener,
PopupMenuListener,
ChangeListener,
MultiHashMapDefinitionListener {
    private static final long serialVersionUID = 2010449914223315524L;
    private static final Color UNUSED_COLOR = new Color(100, 100, 100, 50);
    private static final int ROW_HEIGHT = 20;
    private static final int ROW_HEIGHT_POSITION = 50;
    private static final int ROW_HEIGHT_GRAPHICS = 100;
    private static JPopupMenu menu;
    private static JMenuItem delete;
    private static JMenuItem rainbow1;
    private static JMenuItem rainbow2;
    private static JMenuItem randomize;
    private static JMenuItem series;
    private static JMenuItem fit;
    private static JMenuItem editAll;
    private static JPopupMenu optionMenu;
    private static JMenuItem newVS;
    private static JMenuItem renameVS;
    private static JMenuItem deleteVS;
    private static JMenuItem duplicateVS;
    private static JMenuItem createLegend;
    private static JMenu generateValues;
    private static JMenu modifyValues;
    private static JMenuItem brighter;
    private static JMenuItem darker;
    private static JMenu dependencies;
    private static Map<VisualPropertyDependency.Definition, JCheckBoxMenuItem> dependencyMenuItems;
    private static final ImageIcon optionIcon;
    private static final ImageIcon delIcon;
    private static final ImageIcon addIcon;
    private static final ImageIcon rndIcon;
    private static final ImageIcon renameIcon;
    private static final ImageIcon duplicateIcon;
    private static final ImageIcon legendIcon;
    private static final ImageIcon editIcon;
    private static final String DEFAULT_VS_NAME = "default";
    private static VizMapperMainPanel panel;
    private final VisualMappingManager vmm;
    private Map<String, List<Property>> propertyMap;
    private final Map<String, Map<Object, Object>> discMapBuffer = new HashMap<String, Map<Object, Object>>();
    private String lastVSName = null;
    private JScrollPane noMapListScrollPane;
    private List<VisualPropertyType> noMapping;
    private JPanel buttonPanel;
    private JButton addButton;
    private JPanel bottomPanel;
    private Map<VisualPropertyType, JDialog> editorWindowManager = new HashMap<VisualPropertyType, JDialog>();
    private Map<String, Image> defaultImageManager = new HashMap<String, Image>();
    private boolean ignore = false;
    private CyLogger logger = CyLogger.getLogger(VizMapperMainPanel.class);
    private Set<VizMapperProperty> hiddenProperties = new HashSet<VizMapperProperty>();
    private JPanel defaultAppearencePanel;
    private JSplitPane mainSplitPane;
    private JSplitPane listSplitPane;
    private DropDownMenuButton optionButton;
    private PropertySheetPanel visualPropertySheetPanel;
    private JComboBox vsNameComboBox;
    private JPanel vsSelectPanel;
    private CyComboBoxPropertyEditor nodeAttrEditor = new CyComboBoxPropertyEditor();
    private CyComboBoxPropertyEditor edgeAttrEditor = new CyComboBoxPropertyEditor();
    private CyComboBoxPropertyEditor nodeNumericalAttrEditor = new CyComboBoxPropertyEditor();
    private CyComboBoxPropertyEditor edgeNumericalAttrEditor = new CyComboBoxPropertyEditor();
    private CyComboBoxPropertyEditor mappingTypeEditor = new CyComboBoxPropertyEditor();
    private PropertyRendererRegistry rendReg = new PropertyRendererRegistry();
    private PropertyEditorRegistry editorReg = new PropertyEditorRegistry();
    private final CellRendererFactory rendFactory = new CellRendererFactory();
    private final CellEditorFactory editorFactory = new CellEditorFactory(this);
    private final DiscretePropertySetter discretePropSetter = new DiscretePropertySetter(this, this.rendReg, this.editorReg, this.rendFactory, this.editorFactory);
    private static final String CATEGORY_UNUSED = "Unused Properties";
    private static final String GRAPHICAL_MAP_VIEW = "Graphical View";
    private static final String NODE_VISUAL_MAPPING = "Node Visual Mapping";
    private static final String EDGE_VISUAL_MAPPING = "Edge Visual Mapping";

    private VizMapperMainPanel() {
        this.vmm = Cytoscape.getVisualMappingManager();
        this.vmm.addChangeListener(this);
        this.propertyMap = new HashMap<String, List<Property>>();
        this.setMenu();
        menu.addPopupMenuListener(this);
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        this.initComponents();
        this.registerCellEditorListeners();
        this.visualPropertySheetPanel.setSorting(true);
        Cytoscape.getNodeAttributes().getMultiHashMapDefinition().addDataDefinitionListener(this);
        Cytoscape.getEdgeAttributes().getMultiHashMapDefinition().addDataDefinitionListener(this);
    }

    private void registerCellEditorListeners() {
        this.nodeAttrEditor.addPropertyChangeListener(this);
        this.edgeAttrEditor.addPropertyChangeListener(this);
        this.mappingTypeEditor.addPropertyChangeListener(this);
    }

    public static VizMapperMainPanel getVizMapperUI() {
        if (panel == null) {
            panel = new VizMapperMainPanel();
        }
        return panel;
    }

    void syncDependencyStates(VisualPropertyDependency deps, VisualPropertyDependency.Definition def) {
        dependencyMenuItems.get((Object)def).setSelected(deps.check(def));
        this.updateDependencyStates(deps);
        this.visualPropertySheetPanel.repaint();
        String vsName = this.vmm.getVisualStyle().getName();
        this.updateDefaultImage(vsName, (DGraphView)((DefaultViewPanel)DefaultAppearenceBuilder.getDefaultView(vsName)).getView(), this.defaultAppearencePanel.getSize());
        this.setDefaultPanel(this.defaultImageManager.get(vsName), true);
    }

    private void updateDependencyStates(VisualPropertyDependency deps) {
        for (Property tmpprop : this.visualPropertySheetPanel.getProperties()) {
            if (!(tmpprop instanceof VizMapperProperty)) continue;
            this.updateDependentProperty((VizMapperProperty)tmpprop, deps);
        }
        ArrayList<VizMapperProperty> propl = new ArrayList<VizMapperProperty>(this.hiddenProperties);
        for (VizMapperProperty prop : propl) {
            this.updateDependentProperty(prop, deps);
        }
    }

    private void updateDependentProperty(VizMapperProperty prop, VisualPropertyDependency deps) {
        Object hidden = prop.getHiddenObject();
        if (!(hidden instanceof VisualPropertyType)) {
            return;
        }
        VisualPropertyType type = (VisualPropertyType)((Object)hidden);
        if (type.getVisualProperty().constrained(deps)) {
            this.hiddenProperties.add(prop);
            this.visualPropertySheetPanel.removeProperty(prop);
        } else if (this.hiddenProperties.remove(prop)) {
            this.visualPropertySheetPanel.addProperty(prop);
        }
    }

    private void setMenu() {
        newVS = new JMenuItem("Create new Visual Style...");
        newVS.setIcon(addIcon);
        newVS.addActionListener(new NewStyleListener());
        deleteVS = new JMenuItem("Delete Visual Style...");
        deleteVS.setIcon(delIcon);
        deleteVS.addActionListener(new RemoveStyleListener());
        renameVS = new JMenuItem("Rename Visual Style...");
        renameVS.setIcon(renameIcon);
        renameVS.addActionListener(new RenameStyleListener());
        duplicateVS = new JMenuItem("Copy existing Visual Style...");
        duplicateVS.setIcon(duplicateIcon);
        duplicateVS.addActionListener(new CopyStyleListener());
        createLegend = new JMenuItem("Create legend from current Visual Style");
        createLegend.setIcon(legendIcon);
        createLegend.addActionListener(new CreateLegendListener());
        optionMenu = new JPopupMenu();
        optionMenu.add(newVS);
        optionMenu.add(deleteVS);
        optionMenu.add(renameVS);
        optionMenu.add(duplicateVS);
        optionMenu.add(createLegend);
        generateValues = new JMenu("Generate Discrete Values");
        generateValues.setIcon(rndIcon);
        modifyValues = new JMenu("Modify Discrete Values");
        dependencies = new JMenu("Visual Property Dependencies");
        dependencyMenuItems = new HashMap<VisualPropertyDependency.Definition, JCheckBoxMenuItem>();
        this.setupDependencyMenus(dependencies);
        delete = new JMenuItem("Delete mapping");
        Font italicMenu = new Font("SansSerif", 2, 14);
        rainbow1 = new JMenuItem("Rainbow 1");
        rainbow2 = new JMenuItem("Rainbow 2 (w/modulations)");
        randomize = new JMenuItem("Randomize");
        rainbow1.setFont(italicMenu);
        rainbow2.setFont(italicMenu);
        series = new JMenuItem("Series (Number Only)");
        fit = new JMenuItem("Fit Node Width to Label");
        brighter = new JMenuItem("Brighter");
        darker = new JMenuItem("Darker");
        editAll = new JMenuItem("Edit selected values at once...");
        delete.setIcon(delIcon);
        editAll.setIcon(editIcon);
        rainbow1.addActionListener(new GenerateValueListener(1));
        rainbow2.addActionListener(new GenerateValueListener(2));
        randomize.addActionListener(new GenerateValueListener(3));
        series.addActionListener(new GenerateSeriesListener());
        fit.addActionListener(new FitLabelListener());
        brighter.addActionListener(new BrightnessListener(2));
        darker.addActionListener(new BrightnessListener(1));
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VizMapperMainPanel.this.removeMapping();
            }
        });
        editAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                VizMapperMainPanel.this.editSelectedCells();
            }
        });
        menu = new JPopupMenu();
        generateValues.add(rainbow1);
        generateValues.add(rainbow2);
        generateValues.add(randomize);
        generateValues.add(series);
        generateValues.add(fit);
        modifyValues.add(brighter);
        modifyValues.add(darker);
        rainbow1.setEnabled(false);
        rainbow2.setEnabled(false);
        randomize.setEnabled(false);
        series.setEnabled(false);
        fit.setEnabled(false);
        brighter.setEnabled(false);
        darker.setEnabled(false);
        menu.add(delete);
        menu.add(new JSeparator());
        menu.add(generateValues);
        menu.add(modifyValues);
        menu.add(editAll);
        menu.add(new JSeparator());
        menu.add(dependencies);
        delete.setEnabled(false);
    }

    private void setupDependencyMenus(JMenu parentMenu) {
        for (final VisualPropertyDependency.Definition def : VisualPropertyDependency.Definition.values()) {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem(def.getTitle());
            item.setSelected(def.getDefault());
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VisualPropertyDependency deps = VizMapperMainPanel.this.vmm.getVisualStyle().getDependency();
                    deps.set(def, item.isSelected());
                    VizMapperMainPanel.this.syncDependencyStates(deps, def);
                    Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
                }
            });
            parentMenu.add(item);
            dependencyMenuItems.put(def, item);
        }
    }

    public static void apply(Object newValue, VisualPropertyType type) {
        if (newValue != null) {
            type.setDefault(Cytoscape.getVisualMappingManager().getVisualStyle(), newValue);
        }
    }

    public static Object showValueSelectDialog(VisualPropertyType type, Component caller) throws Exception {
        return type.showDiscreteEditor();
    }

    private void initComponents() {
        this.mainSplitPane = new JSplitPane();
        this.listSplitPane = new JSplitPane();
        this.bottomPanel = new JPanel();
        this.defaultAppearencePanel = new JPanel();
        this.visualPropertySheetPanel = new PropertySheetPanel();
        this.visualPropertySheetPanel.setTable(new PropertySheetTable());
        this.vsSelectPanel = new JPanel();
        this.vsNameComboBox = new JComboBox();
        this.buttonPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.buttonPanel.setLayout(gridbag);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 0;
        this.addButton = new JButton();
        this.addButton.setUI(new BlueishButtonUI());
        gridbag.setConstraints(this.addButton, constraints);
        this.buttonPanel.add(this.addButton);
        constraints.gridx = 2;
        constraints.gridy = 0;
        this.defaultAppearencePanel.setMinimumSize(new Dimension(100, 100));
        this.defaultAppearencePanel.setPreferredSize(new Dimension(this.mainSplitPane.getWidth(), this.mainSplitPane.getDividerLocation()));
        this.defaultAppearencePanel.setSize(this.defaultAppearencePanel.getPreferredSize());
        this.defaultAppearencePanel.setLayout(new BorderLayout());
        this.mainSplitPane.setDividerLocation(120);
        this.mainSplitPane.setDividerSize(4);
        this.listSplitPane.setDividerLocation(400);
        this.listSplitPane.setDividerSize(5);
        this.listSplitPane.setOrientation(0);
        this.noMapListScrollPane = new JScrollPane();
        this.noMapListScrollPane.setBorder(BorderFactory.createTitledBorder(null, "Unused Visual Properties", 2, 0, new Font("SansSerif", 1, 12)));
        this.noMapListScrollPane.setToolTipText("To Create New Mapping, Drag & Drop List Item to Browser.");
        GroupLayout bottomPanelLayout = new GroupLayout(this.bottomPanel);
        this.bottomPanel.setLayout(bottomPanelLayout);
        bottomPanelLayout.setHorizontalGroup(bottomPanelLayout.createParallelGroup(1).add(this.noMapListScrollPane, -1, 272, Short.MAX_VALUE).add(this.buttonPanel, -1, -1, Short.MAX_VALUE));
        bottomPanelLayout.setVerticalGroup(bottomPanelLayout.createParallelGroup(1).add(bottomPanelLayout.createSequentialGroup().add(this.buttonPanel, -2, 25, -2).add(this.noMapListScrollPane, -1, 135, Short.MAX_VALUE)));
        this.listSplitPane.setLeftComponent(this.mainSplitPane);
        this.listSplitPane.setRightComponent(this.bottomPanel);
        this.mainSplitPane.setOrientation(0);
        this.defaultAppearencePanel.setBorder(BorderFactory.createTitledBorder(null, "Defaults", 0, 0, new Font("SansSerif", 1, 12), Color.darkGray));
        this.mainSplitPane.setLeftComponent(this.defaultAppearencePanel);
        this.visualPropertySheetPanel.setBorder(BorderFactory.createTitledBorder(null, "Visual Mapping Browser", 0, 0, new Font("SansSerif", 1, 12), Color.darkGray));
        this.mainSplitPane.setRightComponent(this.visualPropertySheetPanel);
        this.vsSelectPanel.setBorder(BorderFactory.createTitledBorder(null, "Current Visual Style", 0, 0, new Font("SansSerif", 1, 12), Color.darkGray));
        this.vsNameComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VizMapperMainPanel.this.vsNameComboBoxActionPerformed(evt);
            }
        });
        this.optionButton = new DropDownMenuButton(new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                DropDownMenuButton b = (DropDownMenuButton)ae.getSource();
                optionMenu.show(b, 0, b.getHeight());
            }
        });
        this.optionButton.setToolTipText("Options...");
        this.optionButton.setIcon(optionIcon);
        this.optionButton.setMargin(new Insets(2, 2, 2, 2));
        this.optionButton.setComponentPopupMenu(optionMenu);
        GroupLayout vsSelectPanelLayout = new GroupLayout(this.vsSelectPanel);
        this.vsSelectPanel.setLayout(vsSelectPanelLayout);
        vsSelectPanelLayout.setHorizontalGroup(vsSelectPanelLayout.createParallelGroup(1).add(vsSelectPanelLayout.createSequentialGroup().addContainerGap().add(this.vsNameComboBox, 0, 146, Short.MAX_VALUE).addPreferredGap(0).add(this.optionButton, -2, 64, -2).addContainerGap()));
        vsSelectPanelLayout.setVerticalGroup(vsSelectPanelLayout.createParallelGroup(1).add(vsSelectPanelLayout.createSequentialGroup().add(vsSelectPanelLayout.createParallelGroup(3).add(this.vsNameComboBox, -2, -1, -2).add(this.optionButton))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.vsSelectPanel, -1, -1, Short.MAX_VALUE).add(this.mainSplitPane, -1, 280, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.vsSelectPanel, -2, -1, -2).addPreferredGap(0).add(this.mainSplitPane, -1, 510, Short.MAX_VALUE)));
    }

    private void vsNameComboBoxActionPerformed(ActionEvent evt) {
        String vsName = (String)this.vsNameComboBox.getSelectedItem();
        CyNetworkView currentView = Cytoscape.getCurrentNetworkView();
        if (vsName != null) {
            if (currentView.equals(Cytoscape.getNullNetworkView()) || vsName.equals(this.lastVSName) || currentView.getVisualStyle().getName().equals(vsName)) {
                this.switchVS(vsName, false);
            } else {
                this.switchVS(vsName, true);
            }
        }
    }

    private void switchVS(String vsName) {
        this.switchVS(vsName, true);
    }

    private void switchVS(String vsName, boolean redraw) {
        Image defImg;
        if (this.ignore) {
            return;
        }
        if (this.lastVSName == vsName) {
            return;
        }
        this.closeEditorWindow();
        this.logger.debug("VS Switched --> " + vsName + ", Last = " + this.lastVSName);
        this.vmm.setNetworkView(Cytoscape.getCurrentNetworkView());
        this.vmm.setVisualStyle(vsName);
        if (this.propertyMap.containsKey(vsName)) {
            List<Property> props = this.propertyMap.get(vsName);
            TreeMap<String, Property> unused = new TreeMap<String, Property>();
            Property[] propertyArray = this.visualPropertySheetPanel.getProperties();
            int len$ = propertyArray.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Property property = propertyArray[i$];
                this.visualPropertySheetPanel.removeProperty(property);
            }
            for (Property prop : props) {
                if (!prop.getCategory().startsWith(CATEGORY_UNUSED)) {
                    if (prop.getCategory().equals(NODE_VISUAL_MAPPING)) {
                        this.visualPropertySheetPanel.addProperty(0, prop);
                        continue;
                    }
                    this.visualPropertySheetPanel.addProperty(prop);
                    continue;
                }
                unused.put(prop.getDisplayName(), prop);
            }
            ArrayList arrayList = new ArrayList(unused.keySet());
            Collections.sort(arrayList);
            for (String key : arrayList) {
                this.visualPropertySheetPanel.addProperty((Property)unused.get(key));
            }
        } else {
            this.setPropertyTable();
        }
        Cytoscape.getCurrentNetworkView().setVisualStyle(vsName);
        if (redraw && Cytoscape.getCurrentNetworkView() != Cytoscape.getNullNetworkView()) {
            Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
        }
        if ((defImg = this.defaultImageManager.get(vsName)) == null) {
            this.updateDefaultImage(vsName, (DGraphView)((DefaultViewPanel)DefaultAppearenceBuilder.getDefaultView(vsName)).getView(), this.defaultAppearencePanel.getSize());
            defImg = this.defaultImageManager.get(vsName);
        }
        this.setDefaultPanel(defImg, false);
        VisualPropertyDependency dep = this.vmm.getVisualStyle().getDependency();
        for (VisualPropertyDependency.Definition definition : VisualPropertyDependency.Definition.values()) {
            JCheckBoxMenuItem jcbmi = dependencyMenuItems.get((Object)definition);
            jcbmi.setSelected(dep.check(definition));
            this.syncDependencyStates(dep, definition);
        }
        this.visualPropertySheetPanel.setSorting(true);
        Cytoscape.getDesktop().repaint();
        this.vsNameComboBox.setSelectedItem(vsName);
        this.lastVSName = vsName;
    }

    public void initVizmapperGUI() {
        ArrayList<String> vsNames = new ArrayList<String>(this.vmm.getCalculatorCatalog().getVisualStyleNames());
        VisualStyle style = this.vmm.getVisualStyle();
        ActionListener[] li = this.vsNameComboBox.getActionListeners();
        for (int i = 0; i < li.length; ++i) {
            this.vsNameComboBox.removeActionListener(li[i]);
        }
        this.vsNameComboBox.removeAllItems();
        Dimension panelSize = this.defaultAppearencePanel.getSize();
        Collections.sort(vsNames);
        for (String name : vsNames) {
            this.vsNameComboBox.addItem(name);
            JPanel defPanel = DefaultAppearenceBuilder.getDefaultView(name);
            DGraphView view = (DGraphView)((DefaultViewPanel)defPanel).getView();
            if (view == null) continue;
            this.logger.debug("Creating Default Image for " + name);
            this.updateDefaultImage(name, view, panelSize);
        }
        this.vmm.setNetworkView(Cytoscape.getCurrentNetworkView());
        this.switchVS(style.getName(), false);
        this.updateDependencyStates(this.vmm.getVisualStyle().getDependency());
        for (int i = 0; i < li.length; ++i) {
            this.vsNameComboBox.addActionListener(li[i]);
        }
    }

    private void updateDefaultImage(String vsName, DGraphView view, Dimension size) {
        Image image = this.defaultImageManager.remove(vsName);
        if (image != null) {
            image.flush();
            image = null;
        }
        this.defaultImageManager.put(vsName, view.createImage((int)size.getWidth(), (int)size.getHeight(), 0.9));
    }

    private void setPropertySheetAppearence() {
        this.visualPropertySheetPanel.setTable(new PropertySheetTable(){

            public String getToolTipText(MouseEvent me) {
                Point pt = me.getPoint();
                int row = this.rowAtPoint(pt);
                if (row < 0) {
                    return null;
                }
                Property prop = ((PropertySheetTableModel.Item)this.getValueAt(row, 0)).getProperty();
                Color fontColor = prop != null && prop.getValue() != null && prop.getValue().getClass() == Color.class ? (Color)prop.getValue() : Color.DARK_GRAY;
                String colorString = Integer.toHexString(fontColor.getRGB());
                if (prop == null) {
                    return null;
                }
                if (prop.getDisplayName().equals(VizMapperMainPanel.GRAPHICAL_MAP_VIEW)) {
                    return "Click to edit this mapping...";
                }
                if (prop.getDisplayName() == "Controlling Attribute" || prop.getDisplayName() == "Mapping Type") {
                    return "<html><Body BgColor=\"white\"><font Size=\"4\" Color=\"#" + colorString.substring(2, 8) + "\"><strong>" + prop.getDisplayName() + " = " + prop.getValue() + "</font></strong></body></html>";
                }
                if (prop.getSubProperties() == null || prop.getSubProperties().length == 0) {
                    return "<html><Body BgColor=\"white\"><font Size=\"4\" Color=\"#" + colorString.substring(2, 8) + "\"><strong>" + prop.getDisplayName() + "</font></strong></body></html>";
                }
                return null;
            }
        });
        this.visualPropertySheetPanel.getTable().getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent arg0) {
            }

            public void columnMarginChanged(ChangeEvent e) {
                VizMapperMainPanel.this.updateTableView();
            }

            public void columnMoved(TableColumnModelEvent e) {
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.visualPropertySheetPanel.setMode(1);
        this.visualPropertySheetPanel.getTable().setComponentPopupMenu(menu);
        this.visualPropertySheetPanel.getTable().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                VizMapperMainPanel.this.processMouseClick(e);
            }
        });
        PropertySheetTable table = this.visualPropertySheetPanel.getTable();
        table.setRowHeight(20);
        table.setSelectionMode(2);
        table.setCategoryBackground(new Color(10, 10, 50, 20));
        table.setCategoryForeground(Color.black);
        table.setSelectionBackground(Color.white);
        table.setSelectionForeground(Color.blue);
        Set<String> mappingTypes = Cytoscape.getVisualMappingManager().getCalculatorCatalog().getMappingNames();
        this.mappingTypeEditor.setAvailableValues(mappingTypes.toArray());
    }

    private void updateTableView() {
        PropertySheetTable table = this.visualPropertySheetPanel.getTable();
        Property shownProp = null;
        DefaultTableCellRenderer emptyCellRenderer = new DefaultTableCellRenderer();
        int rowCount = table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            try {
                shownProp = ((PropertySheetTableModel.Item)table.getValueAt(i, 0)).getProperty();
            }
            catch (IndexOutOfBoundsException ex) {
                shownProp = null;
            }
            catch (NullPointerException ex) {
                shownProp = null;
            }
            if (shownProp != null && shownProp.getParentProperty() != null && !shownProp.getDisplayName().equals(GRAPHICAL_MAP_VIEW)) {
                String parentText = shownProp.getParentProperty().getDisplayName();
                String displayName = shownProp.getDisplayName();
                if (displayName.equals("Mapping Type")) continue;
                if (parentText.contains("Position")) {
                    table.setRowHeight(i, 50);
                    continue;
                }
                if (!shownProp.getParentProperty().getDisplayName().startsWith("Node Custom Graphics")) continue;
                table.setRowHeight(i, 100);
                continue;
            }
            if (shownProp != null && shownProp.getDisplayName().equals(GRAPHICAL_MAP_VIEW)) {
                ObjectMapping mapping;
                Property parent = shownProp.getParentProperty();
                Object type = ((VizMapperProperty)parent).getHiddenObject();
                if (!(type instanceof VisualPropertyType) || !((mapping = ((VisualPropertyType)((Object)type)).isNodeProp() ? this.vmm.getVisualStyle().getNodeAppearanceCalculator().getCalculator((VisualPropertyType)((Object)type)).getMapping(0) : this.vmm.getVisualStyle().getEdgeAppearanceCalculator().getCalculator((VisualPropertyType)((Object)type)).getMapping(0)) instanceof ContinuousMapping)) continue;
                table.setRowHeight(i, 100);
                int wi = table.getCellRect((int)0, (int)1, (boolean)true).width;
                ImageIcon icon = ContinuousMappingEditorPanel.getIcon(wi, 70, (VisualPropertyType)((Object)type));
                Class<?> dataType = ((VisualPropertyType)((Object)type)).getDataType();
                if (dataType == Color.class) {
                    DefaultTableCellRenderer gradientRenderer = new DefaultTableCellRenderer();
                    gradientRenderer.setIcon(icon);
                    this.rendReg.registerRenderer(shownProp, (TableCellRenderer)gradientRenderer);
                    continue;
                }
                if (dataType == Number.class) {
                    DefaultTableCellRenderer cRenderer = new DefaultTableCellRenderer();
                    cRenderer.setIcon(icon);
                    this.rendReg.registerRenderer(shownProp, (TableCellRenderer)cRenderer);
                    continue;
                }
                DefaultTableCellRenderer dRenderer = new DefaultTableCellRenderer();
                dRenderer.setIcon(icon);
                this.rendReg.registerRenderer(shownProp, (TableCellRenderer)dRenderer);
                continue;
            }
            if (shownProp == null || shownProp.getCategory() == null || !shownProp.getCategory().equals(CATEGORY_UNUSED)) continue;
            emptyCellRenderer.setForeground(UNUSED_COLOR);
            this.rendReg.registerRenderer(shownProp, (TableCellRenderer)emptyCellRenderer);
        }
    }

    private void setAttrComboBox() {
        Class dataClass;
        ArrayList<Object> names = new ArrayList<Object>();
        CyAttributes attr = Cytoscape.getNodeAttributes();
        Object[] nameArray = attr.getAttributeNames();
        Arrays.sort(nameArray);
        names.add("ID");
        for (Object name : nameArray) {
            if (!attr.getUserVisible((String)name) || attr.getType((String)name) == -1 || attr.getType((String)name) == -4) continue;
            names.add(name);
        }
        this.nodeAttrEditor.setAvailableValues(names.toArray());
        names.clear();
        for (Object name : nameArray) {
            dataClass = CyAttributesUtils.getClass((String)name, attr);
            if (dataClass != Integer.class && dataClass != Double.class && dataClass != Float.class) continue;
            names.add(name);
        }
        this.nodeNumericalAttrEditor.setAvailableValues(names.toArray());
        names.clear();
        attr = Cytoscape.getEdgeAttributes();
        nameArray = attr.getAttributeNames();
        Arrays.sort(nameArray);
        names.add("ID");
        for (Object name : nameArray) {
            if (!attr.getUserVisible((String)name) || attr.getType((String)name) == -1 || attr.getType((String)name) == -4) continue;
            names.add(name);
        }
        this.edgeAttrEditor.setAvailableValues(names.toArray());
        names.clear();
        for (Object name : nameArray) {
            dataClass = CyAttributesUtils.getClass((String)name, attr);
            if (dataClass != Integer.class && dataClass != Double.class && dataClass != Float.class) continue;
            names.add(name);
        }
        this.edgeNumericalAttrEditor.setAvailableValues(names.toArray());
        this.repaint();
    }

    private void processMouseClick(MouseEvent e) {
        int selected = this.visualPropertySheetPanel.getTable().getSelectedRow();
        this.updateTableView();
        if (SwingUtilities.isLeftMouseButton(e) && 0 <= selected) {
            PropertySheetTableModel.Item item = (PropertySheetTableModel.Item)this.visualPropertySheetPanel.getTable().getValueAt(selected, 0);
            Property curProp = item.getProperty();
            if (curProp == null) {
                return;
            }
            String category = curProp.getCategory();
            if (e.getClickCount() == 2 && category != null && category.equalsIgnoreCase(CATEGORY_UNUSED)) {
                VisualPropertyType type = (VisualPropertyType)((Object)((VizMapperProperty)curProp).getHiddenObject());
                this.visualPropertySheetPanel.removeProperty(curProp);
                VizMapperProperty newProp = new VizMapperProperty();
                VizMapperProperty mapProp = new VizMapperProperty();
                newProp.setDisplayName(type.getName());
                newProp.setHiddenObject((Object)type);
                newProp.setValue("Please select a value!");
                if (type.isNodeProp()) {
                    newProp.setCategory(NODE_VISUAL_MAPPING);
                    this.editorReg.registerEditor((Property)newProp, (PropertyEditor)this.nodeAttrEditor);
                } else {
                    newProp.setCategory(EDGE_VISUAL_MAPPING);
                    this.editorReg.registerEditor((Property)newProp, (PropertyEditor)this.edgeAttrEditor);
                }
                mapProp.setDisplayName("Mapping Type");
                mapProp.setValue("Please select a mapping type!");
                newProp.addSubProperty(mapProp);
                mapProp.setParentProperty(newProp);
                this.visualPropertySheetPanel.addProperty(0, newProp);
                this.expandLastSelectedItem(type.getName());
                this.visualPropertySheetPanel.getTable().scrollRectToVisible(new Rectangle(0, 0, 10, 10));
                this.visualPropertySheetPanel.repaint();
                this.editorReg.registerEditor((Property)mapProp, (PropertyEditor)this.mappingTypeEditor);
                return;
            }
            if (e.getClickCount() == 1 && category == null) {
                VisualPropertyType type = null;
                if (curProp.getParentProperty() == null && ((VizMapperProperty)curProp).getHiddenObject() instanceof VisualPropertyType) {
                    type = (VisualPropertyType)((Object)((VizMapperProperty)curProp).getHiddenObject());
                } else if (curProp.getParentProperty() != null) {
                    type = (VisualPropertyType)((Object)((VizMapperProperty)curProp.getParentProperty()).getHiddenObject());
                } else {
                    return;
                }
                Calculator calc = null;
                calc = type.isNodeProp() ? this.vmm.getVisualStyle().getNodeAppearanceCalculator().getCalculator(type) : this.vmm.getVisualStyle().getEdgeAppearanceCalculator().getCalculator(type);
                if (calc == null) {
                    return;
                }
                ObjectMapping selectedMapping = calc.getMapping(0);
                if (selectedMapping instanceof ContinuousMapping) {
                    if (this.editorWindowManager.containsKey((Object)type)) {
                        this.editorWindowManager.get((Object)type).requestFocus();
                        return;
                    }
                    try {
                        ((JDialog)type.showContinuousEditor()).addPropertyChangeListener(this);
                    }
                    catch (Exception e1) {
                        this.logger.warn("Unable to add listener to the contiuous editor", e1);
                    }
                }
            }
        }
    }

    private void setPropertyTable() {
        this.setPropertySheetAppearence();
        for (Property item : this.visualPropertySheetPanel.getProperties()) {
            this.visualPropertySheetPanel.removeProperty(item);
        }
        NodeAppearanceCalculator nac = Cytoscape.getVisualMappingManager().getVisualStyle().getNodeAppearanceCalculator();
        EdgeAppearanceCalculator eac = Cytoscape.getVisualMappingManager().getVisualStyle().getEdgeAppearanceCalculator();
        List nacList = nac.getCalculators();
        List eacList = eac.getCalculators();
        this.editorReg.registerDefaults();
        ArrayList<Property> propRecord = new ArrayList<Property>();
        this.setPropertyFromCalculator(nacList, NODE_VISUAL_MAPPING, propRecord);
        this.setPropertyFromCalculator(eacList, EDGE_VISUAL_MAPPING, propRecord);
        this.propertyMap.put(this.vmm.getVisualStyle().getName(), propRecord);
        this.setUnused(propRecord);
    }

    private void setUnused(List<Property> propList) {
        this.buildList();
        Collections.sort(this.noMapping);
        for (VisualPropertyType type : this.noMapping) {
            VizMapperProperty prop = new VizMapperProperty();
            prop.setCategory(CATEGORY_UNUSED);
            prop.setDisplayName(type.getName());
            prop.setHiddenObject((Object)type);
            prop.setValue("Double-Click to create...");
            this.visualPropertySheetPanel.addProperty(prop);
            propList.add(prop);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void buildProperty(Calculator calc, VizMapperProperty calculatorTypeProp, String rootCategory) {
        block12: {
            Iterator it;
            CyAttributes attr;
            String attrName;
            ObjectMapping firstMap;
            block14: {
                Class<?> dataType;
                block15: {
                    VisualPropertyType type;
                    block13: {
                        type = calc.getVisualPropertyType();
                        calculatorTypeProp.setCategory(rootCategory);
                        calculatorTypeProp.setDisplayName(type.getName());
                        calculatorTypeProp.setHiddenObject((Object)type);
                        firstMap = calc.getMapping(0);
                        if (firstMap == null) break block12;
                        VizMapperProperty mappingHeader = new VizMapperProperty();
                        attrName = firstMap.getControllingAttributeName();
                        if (attrName == null) {
                            calculatorTypeProp.setValue("Select Value");
                        } else {
                            calculatorTypeProp.setValue(attrName);
                        }
                        this.rendReg.registerRenderer((Property)calculatorTypeProp, CellRendererFactory.DEF_RENDERER);
                        mappingHeader.setDisplayName("Mapping Type");
                        mappingHeader.setHiddenObject(firstMap.getClass());
                        if (firstMap.getClass() == DiscreteMapping.class) {
                            mappingHeader.setValue("Discrete Mapping");
                        } else if (firstMap.getClass() == ContinuousMapping.class) {
                            mappingHeader.setValue("Continuous Mapping");
                        } else {
                            mappingHeader.setValue("Passthrough Mapping");
                        }
                        mappingHeader.setHiddenObject(firstMap);
                        mappingHeader.setParentProperty(calculatorTypeProp);
                        calculatorTypeProp.addSubProperty(mappingHeader);
                        this.editorReg.registerEditor((Property)mappingHeader, (PropertyEditor)this.mappingTypeEditor);
                        boolean isNode = false;
                        if (calc.getVisualPropertyType().isNodeProp()) {
                            attr = Cytoscape.getNodeAttributes();
                            it = Cytoscape.getCurrentNetwork().nodesIterator();
                            this.editorReg.registerEditor((Property)calculatorTypeProp, (PropertyEditor)this.nodeAttrEditor);
                            isNode = true;
                        } else {
                            attr = Cytoscape.getEdgeAttributes();
                            it = Cytoscape.getCurrentNetwork().edgesIterator();
                            this.editorReg.registerEditor((Property)calculatorTypeProp, (PropertyEditor)this.edgeAttrEditor);
                            isNode = false;
                        }
                        if (firstMap.getClass() != DiscreteMapping.class || attrName == null) break block13;
                        Map discMapping = ((DiscreteMapping)firstMap).getAll();
                        Set<Object> attrSet = MappingKeyFactory.getKeySet(attrName, attr, firstMap, isNode);
                        this.discretePropSetter.setDiscreteProps(type, discMapping, attrSet, calculatorTypeProp);
                        break block12;
                    }
                    if (firstMap.getClass() != ContinuousMapping.class || attrName == null) break block14;
                    int wi = this.visualPropertySheetPanel.getTable().getCellRect((int)0, (int)1, (boolean)true).width;
                    VizMapperProperty graphicalView = new VizMapperProperty();
                    graphicalView.setDisplayName(GRAPHICAL_MAP_VIEW);
                    graphicalView.setName(type.getName());
                    graphicalView.setParentProperty(calculatorTypeProp);
                    calculatorTypeProp.addSubProperty(graphicalView);
                    dataType = type.getDataType();
                    ImageIcon icon = ContinuousMappingEditorPanel.getIcon(wi, 70, type);
                    if (dataType != Color.class) break block15;
                    DefaultTableCellRenderer gradientRenderer = new DefaultTableCellRenderer();
                    gradientRenderer.setIcon(icon);
                    this.rendReg.registerRenderer((Property)graphicalView, (TableCellRenderer)gradientRenderer);
                    break block12;
                }
                if (dataType == Number.class) break block12;
                break block12;
            }
            if (firstMap.getClass() == PassThroughMapping.class && attrName != null && attr.getType(attrName) == 4) {
                while (it.hasNext()) {
                    String id = ((GraphObject)it.next()).getIdentifier();
                    String value = attr.getStringAttribute(id, attrName);
                    VizMapperProperty oneProperty = new VizMapperProperty();
                    if (attrName.equals("ID")) {
                        oneProperty.setValue(id);
                    } else {
                        oneProperty.setValue(value);
                    }
                    oneProperty.setEditable(false);
                    oneProperty.setParentProperty(calculatorTypeProp);
                    oneProperty.setDisplayName(id);
                    oneProperty.setType(String.class);
                    calculatorTypeProp.addSubProperty(oneProperty);
                }
            }
        }
        this.visualPropertySheetPanel.addProperty(0, calculatorTypeProp);
        this.visualPropertySheetPanel.setRendererFactory(this.rendReg);
        this.visualPropertySheetPanel.setEditorFactory(this.editorReg);
    }

    private void setPropertyFromCalculator(List<Calculator> calcList, String rootCategory, List<Property> propRecord) {
        VisualPropertyType type = null;
        for (Calculator calc : calcList) {
            VizMapperProperty calculatorTypeProp = new VizMapperProperty();
            this.buildProperty(calc, calculatorTypeProp, rootCategory);
            PropertyEditor editor = this.editorReg.getEditor(calculatorTypeProp);
            if (editor == null && !calculatorTypeProp.getCategory().equals(CATEGORY_UNUSED)) {
                type = (VisualPropertyType)((Object)calculatorTypeProp.getHiddenObject());
                if (type.isNodeProp()) {
                    this.editorReg.registerEditor((Property)calculatorTypeProp, (PropertyEditor)this.nodeAttrEditor);
                } else {
                    this.editorReg.registerEditor((Property)calculatorTypeProp, (PropertyEditor)this.edgeAttrEditor);
                }
            }
            propRecord.add(calculatorTypeProp);
        }
    }

    private void setDefaultPanel(Image defImage, boolean repaint) {
        if (defImage == null) {
            return;
        }
        this.defaultAppearencePanel.removeAll();
        JButton defaultImageButton = new JButton();
        defaultImageButton.setUI(new BlueishButtonUI());
        defaultImageButton.setCursor(Cursor.getPredefinedCursor(12));
        defaultImageButton.setIcon(new ImageIcon(defImage));
        this.defaultAppearencePanel.add((Component)defaultImageButton, "Center");
        defaultImageButton.addMouseListener(new DefaultMouseListener());
        if (repaint) {
            Cytoscape.getDesktop().repaint();
        }
    }

    public void enableListeners(boolean on) {
        if (on) {
            Cytoscape.getVisualMappingManager().addChangeListener(this);
            this.syncStyleBox();
            this.ignore = false;
        } else {
            Cytoscape.getVisualMappingManager().removeChangeListener(this);
        }
    }

    public void initializeTableState() {
        this.propertyMap = new HashMap<String, List<Property>>();
        this.editorWindowManager = new HashMap<VisualPropertyType, JDialog>();
        this.defaultImageManager = new HashMap<String, Image>();
    }

    private void manageWindow(String status2, VisualPropertyType vpt, Object source) {
        if (status2.equals("EDITOR_WINDOW_OPENED")) {
            this.editorWindowManager.put(vpt, (JDialog)source);
        } else if (status2.equals("EDITOR_WINDOW_CLOSED")) {
            VisualPropertyType type = vpt;
            Property[] props = this.visualPropertySheetPanel.getProperties();
            DefaultProperty vprop = null;
            for (Property prop : props) {
                vprop = (VizMapperProperty)prop;
                if (((VizMapperProperty)vprop).getHiddenObject() == null || type != ((VizMapperProperty)vprop).getHiddenObject()) continue;
                vprop = (VizMapperProperty)prop;
                break;
            }
            Property[] subProps = vprop.getSubProperties();
            vprop = null;
            String name = null;
            for (Property prop : subProps) {
                name = prop.getName();
                if (name == null || !name.equals(type.getName())) continue;
                vprop = (VizMapperProperty)prop;
                break;
            }
            int width = this.visualPropertySheetPanel.getTable().getCellRect((int)0, (int)1, (boolean)true).width;
            DefaultTableCellRenderer cRenderer = new DefaultTableCellRenderer();
            cRenderer.setIcon(ContinuousMappingEditorPanel.getIcon(width, 70, type));
            this.rendReg.registerRenderer((Property)vprop, (TableCellRenderer)cRenderer);
            this.visualPropertySheetPanel.getTable().repaint();
        }
    }

    private void closeEditorWindow() {
        Set<VisualPropertyType> typeSet = this.editorWindowManager.keySet();
        HashSet<VisualPropertyType> keySet = new HashSet<VisualPropertyType>();
        for (VisualPropertyType vpt : typeSet) {
            JDialog window = this.editorWindowManager.get((Object)vpt);
            this.manageWindow("EDITOR_WINDOW_CLOSED", vpt, null);
            window.dispose();
            keySet.add(vpt);
        }
        for (VisualPropertyType type : keySet) {
            this.editorWindowManager.remove((Object)type);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object newValue;
        if (e.getPropertyName().equals(Integer.toString(Cytoscape.SESSION_OPENED))) {
            this.ignore = true;
            this.enableListeners(false);
        }
        if (this.ignore) {
            return;
        }
        if (e.getPropertyName().equals("EDITOR_WINDOW_OPENED") || e.getPropertyName().equals("EDITOR_WINDOW_CLOSED")) {
            this.manageWindow(e.getPropertyName(), (VisualPropertyType)((Object)e.getNewValue()), e.getSource());
            if (e.getPropertyName().equals("EDITOR_WINDOW_CLOSED")) {
                this.editorWindowManager.remove((Object)((VisualPropertyType)((Object)e.getNewValue())));
            }
            return;
        }
        if (e.getPropertyName().equals(Cytoscape.SESSION_LOADED) || e.getPropertyName().equals(Cytoscape.VIZMAP_LOADED)) {
            String vsName = this.vmm.getVisualStyle().getName();
            this.lastVSName = null;
            this.initVizmapperGUI();
            this.switchVS(vsName, false);
            this.vsNameComboBox.setSelectedItem(vsName);
            this.vmm.setVisualStyle(vsName);
            return;
        }
        if (e.getPropertyName().equals("NETWORK_VIEW_FOCUS") && e.getSource().getClass() == NetworkPanel.class) {
            VisualStyle vs = this.vmm.getNetworkView().getVisualStyle();
            if (vs != null) {
                this.vmm.setNetworkView(Cytoscape.getCurrentNetworkView());
                if (!vs.getName().equals(this.vsNameComboBox.getSelectedItem())) {
                    this.switchVS(vs.getName(), false);
                    this.vsNameComboBox.setSelectedItem(vs.getName());
                    this.setDefaultPanel(this.defaultImageManager.get(vs.getName()), false);
                }
            }
            return;
        }
        if (!e.getPropertyName().equalsIgnoreCase("value")) {
            return;
        }
        if (e.getNewValue() != null && e.getNewValue().equals(e.getOldValue())) {
            return;
        }
        PropertySheetTable table = this.visualPropertySheetPanel.getTable();
        int selected = table.getSelectedRow();
        if (selected < 0) {
            return;
        }
        PropertySheetTableModel.Item selectedItem = (PropertySheetTableModel.Item)this.visualPropertySheetPanel.getTable().getValueAt(selected, 0);
        VizMapperProperty prop = (VizMapperProperty)selectedItem.getProperty();
        VisualPropertyType type = null;
        String ctrAttrName = null;
        VizMapperProperty typeRootProp = null;
        if (prop.getParentProperty() == null && e.getNewValue() instanceof String) {
            typeRootProp = prop;
            type = (VisualPropertyType)((Object)prop.getHiddenObject());
            ctrAttrName = (String)e.getNewValue();
        } else {
            if (prop.getParentProperty() == null && e.getNewValue() == null) {
                return;
            }
            typeRootProp = (VizMapperProperty)prop.getParentProperty();
            if (prop.getParentProperty() == null) {
                return;
            }
            type = (VisualPropertyType)((Object)((VizMapperProperty)prop.getParentProperty()).getHiddenObject());
        }
        if (prop.getHiddenObject() instanceof ObjectMapping || prop.getDisplayName().equals("Mapping Type")) {
            this.logger.debug("Mapping type changed: " + prop.getHiddenObject());
            if (e.getNewValue() == null) {
                return;
            }
            Object parentValue = prop.getParentProperty().getValue();
            if (parentValue != null) {
                ctrAttrName = parentValue.toString();
                Class dataClass = type.isNodeProp() ? CyAttributesUtils.getClass(ctrAttrName, Cytoscape.getNodeAttributes()) : CyAttributesUtils.getClass(ctrAttrName, Cytoscape.getEdgeAttributes());
                if (e.getNewValue().equals("Continuous Mapper") && dataClass != Integer.class && dataClass != Double.class && dataClass != Float.class) {
                    JOptionPane.showMessageDialog(Cytoscape.getDesktop().getCytoPanel(7).getSelectedComponent(), "Continuous Mapper can be used with Numbers only.", "Incompatible Mapping Type!", 0);
                    return;
                }
            } else {
                return;
            }
            if (!e.getNewValue().toString().endsWith("Mapper")) {
                return;
            }
            this.switchMapping(prop, e.getNewValue().toString(), prop.getParentProperty().getValue());
            this.expandLastSelectedItem(type.getName());
            this.updateTableView();
            return;
        }
        Calculator curCalc = type.isNodeProp() ? this.vmm.getVisualStyle().getNodeAppearanceCalculator().getCalculator(type) : this.vmm.getVisualStyle().getEdgeAppearanceCalculator().getCalculator(type);
        if (curCalc == null) {
            return;
        }
        ObjectMapping mapping = curCalc.getMapping(0);
        if (ctrAttrName != null) {
            CyAttributes attrForTest = type.isNodeProp() ? Cytoscape.getNodeAttributes() : Cytoscape.getEdgeAttributes();
            Byte dataType = attrForTest.getType(ctrAttrName);
            if (mapping instanceof ContinuousMapping && dataType != 2 && dataType != 3) {
                JOptionPane.showMessageDialog(this, "Continuous Mapper can be used with Numbers only.\nPlease select numerical attributes.", "Incompatible Mapping Type!", 1);
                return;
            }
            if (ctrAttrName.equals(mapping.getControllingAttributeName())) {
                return;
            }
            if (mapping instanceof DiscreteMapping) {
                String curMappingName = ((Object)curCalc).toString() + "-" + mapping.getControllingAttributeName();
                String newMappingName = ((Object)curCalc).toString() + "-" + ctrAttrName;
                Map<Object, Object> saved = this.discMapBuffer.get(newMappingName);
                if (saved == null) {
                    this.discMapBuffer.put(curMappingName, ((DiscreteMapping)mapping).getAll());
                    mapping.setControllingAttributeName(ctrAttrName);
                } else if (saved != null) {
                    this.discMapBuffer.put(curMappingName, ((DiscreteMapping)mapping).getAll());
                    mapping.setControllingAttributeName(ctrAttrName);
                    ((DiscreteMapping)mapping).putAll(saved);
                }
            } else {
                mapping.setControllingAttributeName(ctrAttrName);
            }
            this.visualPropertySheetPanel.removeProperty(typeRootProp);
            VizMapperProperty newRootProp = new VizMapperProperty();
            if (type.isNodeProp()) {
                this.buildProperty(this.vmm.getVisualStyle().getNodeAppearanceCalculator().getCalculator(type), newRootProp, NODE_VISUAL_MAPPING);
            } else {
                this.buildProperty(this.vmm.getVisualStyle().getEdgeAppearanceCalculator().getCalculator(type), newRootProp, EDGE_VISUAL_MAPPING);
            }
            this.removeProperty(typeRootProp);
            if (this.propertyMap.get(this.vmm.getVisualStyle().getName()) != null) {
                this.propertyMap.get(this.vmm.getVisualStyle().getName()).add(newRootProp);
            }
            typeRootProp = null;
            this.expandLastSelectedItem(type.getName());
            this.updateTableView();
            this.vmm.setNetworkView(Cytoscape.getCurrentNetworkView());
            Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
            return;
        }
        if (mapping instanceof ContinuousMapping || mapping instanceof PassThroughMapping) {
            return;
        }
        Object key = null;
        if (type.getDataType() == Number.class || type.getDataType() == String.class) {
            key = e.getOldValue();
            if (type.getDataType() == Number.class) {
                this.editorReg.registerEditor((Property)prop, this.editorFactory.getPropertyEditor(Number.class));
            }
        } else {
            key = ((PropertySheetTableModel.Item)this.visualPropertySheetPanel.getTable().getValueAt(selected, 0)).getProperty().getDisplayName();
        }
        ctrAttrName = mapping.getControllingAttributeName();
        CyAttributes attr = type.isNodeProp() ? Cytoscape.getNodeAttributes() : Cytoscape.getEdgeAttributes();
        Byte attrType = attr.getType(ctrAttrName);
        if (attrType != 4) {
            switch (attrType) {
                case 1: {
                    key = Boolean.valueOf((String)key);
                    break;
                }
                case 3: {
                    key = Integer.valueOf((String)key);
                    break;
                }
                case 2: {
                    key = Double.valueOf((String)key);
                    break;
                }
            }
        }
        if ((newValue = e.getNewValue()) == null) {
            ((DiscreteMapping)mapping).putMapValue(key, newValue);
            Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
            return;
        }
        if (type.getDataType() == Number.class && newValue instanceof Number && !type.getVisualProperty().isValidValue(newValue)) {
            int shownPropCount = table.getRowCount();
            Property p = null;
            String val = null;
            for (int i = 0; i < shownPropCount; ++i) {
                p = ((PropertySheetTableModel.Item)table.getValueAt(i, 0)).getProperty();
                if (p == null || (val = p.getDisplayName()) == null || !val.equals(key.toString())) continue;
                p.setValue(((DiscreteMapping)mapping).getMapValue(key));
                return;
            }
            return;
        }
        ((DiscreteMapping)mapping).putMapValue(key, newValue);
        this.updateTableView();
        this.visualPropertySheetPanel.repaint();
        this.vmm.setNetworkView(Cytoscape.getCurrentNetworkView());
        Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
    }

    private void switchMapping(VizMapperProperty prop, String newMapName, Object attrName) {
        if (attrName == null) {
            return;
        }
        VisualPropertyType type = (VisualPropertyType)((Object)((VizMapperProperty)prop.getParentProperty()).getHiddenObject());
        String newCalcName = this.vmm.getVisualStyle().getName() + "-" + type.getName() + "-" + newMapName;
        Calculator newCalc = this.vmm.getCalculatorCatalog().getCalculator(type, newCalcName);
        Calculator oldCalc = null;
        oldCalc = type.isNodeProp() ? this.vmm.getVisualStyle().getNodeAppearanceCalculator().getCalculator(type) : this.vmm.getVisualStyle().getEdgeAppearanceCalculator().getCalculator(type);
        if (newCalc == null) {
            NewMappingBuilder.createNewCalculator(type, newMapName, newCalcName, attrName.toString());
            newCalc = this.vmm.getCalculatorCatalog().getCalculator(type, newCalcName);
        }
        newCalc.getMapping(0).setControllingAttributeName((String)attrName);
        if (type.isNodeProp()) {
            this.vmm.getVisualStyle().getNodeAppearanceCalculator().setCalculator(newCalc);
        } else {
            this.vmm.getVisualStyle().getEdgeAppearanceCalculator().setCalculator(newCalc);
        }
        if (oldCalc != null) {
            String oldMappingTypeName = oldCalc.getMapping(0) instanceof DiscreteMapping ? "Discrete Mapper" : (oldCalc.getMapping(0) instanceof ContinuousMapping ? "Continuous Mapper" : (oldCalc.getMapping(0) instanceof PassThroughMapping ? "Passthrough Mapper" : null));
            String oldCalcName = type.getName() + "-" + oldMappingTypeName;
            if (this.vmm.getCalculatorCatalog().getCalculator(type, oldCalcName) == null) {
                NewMappingBuilder.createNewCalculator(type, oldMappingTypeName, oldCalcName, attrName.toString());
            }
        }
        Property parent = prop.getParentProperty();
        this.visualPropertySheetPanel.removeProperty(parent);
        VizMapperProperty newRootProp = new VizMapperProperty();
        if (type.isNodeProp()) {
            this.buildProperty(this.vmm.getVisualStyle().getNodeAppearanceCalculator().getCalculator(type), newRootProp, NODE_VISUAL_MAPPING);
        } else {
            this.buildProperty(this.vmm.getVisualStyle().getEdgeAppearanceCalculator().getCalculator(type), newRootProp, EDGE_VISUAL_MAPPING);
        }
        this.expandLastSelectedItem(type.getName());
        this.removeProperty(parent);
        if (this.propertyMap.get(this.vmm.getVisualStyle().getName()) != null) {
            this.propertyMap.get(this.vmm.getVisualStyle().getName()).add(newRootProp);
        }
        this.redraw(Cytoscape.getCurrentNetworkView());
        parent = null;
    }

    private void expandLastSelectedItem(String name) {
        PropertySheetTable table = this.visualPropertySheetPanel.getTable();
        PropertySheetTableModel.Item item = null;
        for (int i = 0; i < table.getRowCount(); ++i) {
            item = (PropertySheetTableModel.Item)table.getValueAt(i, 0);
            Property curProp = item.getProperty();
            if (curProp == null || !curProp.getDisplayName().equals(name)) continue;
            table.setRowSelectionInterval(i, i);
            if (!item.isVisible()) {
                item.toggle();
            }
            return;
        }
    }

    private void redraw(CyNetworkView view) {
        RedrawTask task = new RedrawTask(view);
        JTaskConfig jTaskConfig = new JTaskConfig();
        jTaskConfig.displayCancelButton(false);
        jTaskConfig.setOwner(Cytoscape.getDesktop());
        jTaskConfig.displayCloseButton(false);
        jTaskConfig.displayStatus(true);
        jTaskConfig.setAutoDispose(true);
        TaskManager.executeTask(task, jTaskConfig);
    }

    public void setCurrentVS(String vsName) {
        this.vsNameComboBox.setSelectedItem(vsName);
    }

    private void buildList() {
        this.noMapping = new ArrayList<VisualPropertyType>();
        VisualStyle vs = this.vmm.getVisualStyle();
        NodeAppearanceCalculator nac = vs.getNodeAppearanceCalculator();
        EdgeAppearanceCalculator eac = vs.getEdgeAppearanceCalculator();
        ObjectMapping mapping = null;
        for (VisualPropertyType type : VisualPropertyType.values()) {
            Calculator calc = nac.getCalculator(type);
            if (calc == null) {
                calc = eac.getCalculator(type);
                if (calc != null) {
                    mapping = calc.getMapping(0);
                }
            } else {
                mapping = calc.getMapping(0);
            }
            if (mapping == null && type.isAllowed()) {
                this.noMapping.add(type);
            }
            mapping = null;
        }
    }

    private String getStyleName(VisualStyle s) {
        String newName;
        String ret;
        int alt;
        String suggestedName = null;
        if (s != null) {
            suggestedName = this.vmm.getCalculatorCatalog().checkVisualStyleName(s.getName());
        }
        do {
            if ((ret = (String)JOptionPane.showInputDialog(Cytoscape.getDesktop(), "Please enter new name for the visual style.", "Enter Visual Style Name", 3, null, null, suggestedName)) == null) {
                return null;
            }
            newName = this.vmm.getCalculatorCatalog().checkVisualStyleName(ret);
            if (!newName.equals(ret)) continue;
            return ret;
        } while ((alt = JOptionPane.showConfirmDialog(Cytoscape.getDesktop(), "Visual style with name " + ret + " already exists,\nrename to " + newName + " okay?", "Duplicate visual style name", 0, 2, null)) != 0);
        return newName;
    }

    private void removeMapping() {
        PropertySheetTableModel.Item item;
        Property curProp;
        int selected = this.visualPropertySheetPanel.getTable().getSelectedRow();
        if (0 <= selected && (curProp = (item = (PropertySheetTableModel.Item)this.visualPropertySheetPanel.getTable().getValueAt(selected, 0)).getProperty()) instanceof VizMapperProperty) {
            VisualPropertyType type = (VisualPropertyType)((Object)((VizMapperProperty)curProp).getHiddenObject());
            if (type == null) {
                return;
            }
            String[] message = new String[]{"The Mapping for " + type.getName() + " will be removed.", "Proceed?"};
            int value = JOptionPane.showConfirmDialog(Cytoscape.getDesktop(), message, "Remove Mapping", 0);
            if (value == 0) {
                if (this.editorWindowManager.get((Object)type) != null) {
                    JDialog editor = this.editorWindowManager.get((Object)type);
                    editor.dispose();
                    this.editorWindowManager.remove((Object)type);
                }
                if (type.isNodeProp()) {
                    this.vmm.getVisualStyle().getNodeAppearanceCalculator().removeCalculator(type);
                } else {
                    this.vmm.getVisualStyle().getEdgeAppearanceCalculator().removeCalculator(type);
                }
                Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
                this.noMapping.add(type);
                VizMapperProperty prop = new VizMapperProperty();
                prop.setCategory(CATEGORY_UNUSED);
                prop.setDisplayName(type.getName());
                prop.setHiddenObject((Object)type);
                prop.setValue("Double-Click to create...");
                this.visualPropertySheetPanel.addProperty(prop);
                this.visualPropertySheetPanel.removeProperty(curProp);
                this.removeProperty(curProp);
                this.propertyMap.get(this.vmm.getVisualStyle().getName()).add(prop);
                this.visualPropertySheetPanel.repaint();
            }
        }
    }

    private void removeMapping(VisualPropertyType type) {
        if (type.isNodeProp()) {
            this.vmm.getVisualStyle().getNodeAppearanceCalculator().removeCalculator(type);
        } else {
            this.vmm.getVisualStyle().getEdgeAppearanceCalculator().removeCalculator(type);
        }
        Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
        Property[] props = this.visualPropertySheetPanel.getProperties();
        Property toBeRemoved = null;
        for (Property p : props) {
            if (!p.getDisplayName().equals(type.getName())) continue;
            toBeRemoved = p;
            break;
        }
        this.visualPropertySheetPanel.removeProperty(toBeRemoved);
        this.removeProperty(toBeRemoved);
        this.noMapping.add(type);
        VizMapperProperty prop = new VizMapperProperty();
        prop.setCategory(CATEGORY_UNUSED);
        prop.setDisplayName(type.getName());
        prop.setHiddenObject((Object)type);
        prop.setValue("Double-Click to create...");
        this.visualPropertySheetPanel.addProperty(prop);
        if (this.propertyMap.get(this.vmm.getVisualStyle().getName()) != null) {
            this.propertyMap.get(this.vmm.getVisualStyle().getName()).add(prop);
        }
        this.visualPropertySheetPanel.repaint();
    }

    private void editSelectedCells() {
        CyAttributes attr;
        ObjectMapping mapping;
        PropertySheetTable table = this.visualPropertySheetPanel.getTable();
        int[] selected = table.getSelectedRows();
        PropertySheetTableModel.Item item = null;
        if (selected == null || selected.length == 0) {
            return;
        }
        item = (PropertySheetTableModel.Item)this.visualPropertySheetPanel.getTable().getValueAt(selected[0], 0);
        VizMapperProperty prop = (VizMapperProperty)item.getProperty();
        if (prop == null || prop.getParentProperty() == null) {
            return;
        }
        VisualPropertyType type = (VisualPropertyType)((Object)((VizMapperProperty)prop.getParentProperty()).getHiddenObject());
        if (type.isNodeProp()) {
            mapping = this.vmm.getVisualStyle().getNodeAppearanceCalculator().getCalculator(type).getMapping(0);
            attr = Cytoscape.getNodeAttributes();
        } else {
            mapping = this.vmm.getVisualStyle().getEdgeAppearanceCalculator().getCalculator(type).getMapping(0);
            attr = Cytoscape.getEdgeAttributes();
        }
        if (mapping instanceof ContinuousMapping || mapping instanceof PassThroughMapping) {
            return;
        }
        Object newValue = null;
        try {
            newValue = type.showDiscreteEditor();
        }
        catch (Exception e1) {
            this.logger.warn("Unable to show the descrete editor", e1);
        }
        if (newValue == null) {
            return;
        }
        Object key = null;
        Class keyClass = CyAttributesUtils.getClass(mapping.getControllingAttributeName(), attr);
        for (int i = 0; i < selected.length; ++i) {
            ((PropertySheetTableModel.Item)this.visualPropertySheetPanel.getTable().getValueAt(selected[i], 0)).getProperty().setValue(newValue);
            key = ((PropertySheetTableModel.Item)this.visualPropertySheetPanel.getTable().getValueAt(selected[i], 0)).getProperty().getDisplayName();
            if (keyClass == Integer.class) {
                key = Integer.valueOf((String)key);
            } else if (keyClass == Double.class) {
                key = Double.valueOf((String)key);
            } else if (keyClass == Boolean.class) {
                key = Boolean.valueOf((String)key);
            }
            ((DiscreteMapping)mapping).putMapValue(key, newValue);
        }
        table.repaint();
        this.vmm.setNetworkView(Cytoscape.getCurrentNetworkView());
        Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
    }

    private void removeProperty(Property prop) {
        ArrayList<Property> targets = new ArrayList<Property>();
        if (this.propertyMap.get(this.vmm.getVisualStyle().getName()) == null) {
            return;
        }
        for (Property p : this.propertyMap.get(this.vmm.getVisualStyle().getName())) {
            if (!p.getDisplayName().equals(prop.getDisplayName())) continue;
            targets.add(p);
        }
        for (Property p : targets) {
            this.logger.debug("Removed: " + p.getDisplayName());
            this.propertyMap.get(this.vmm.getVisualStyle().getName()).remove(p);
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent arg0) {
        this.disableAllPopup();
    }

    private void disableAllPopup() {
        rainbow1.setEnabled(false);
        rainbow2.setEnabled(false);
        randomize.setEnabled(false);
        series.setEnabled(false);
        fit.setEnabled(false);
        brighter.setEnabled(false);
        darker.setEnabled(false);
        delete.setEnabled(false);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.disableAllPopup();
        int selected = this.visualPropertySheetPanel.getTable().getSelectedRow();
        if (0 > selected) {
            return;
        }
        PropertySheetTableModel.Item item = (PropertySheetTableModel.Item)this.visualPropertySheetPanel.getTable().getValueAt(selected, 0);
        Property curProp = item.getProperty();
        if (curProp == null) {
            return;
        }
        VizMapperProperty prop = (VizMapperProperty)curProp;
        if (prop.getHiddenObject() instanceof VisualPropertyType && !prop.getDisplayName().contains("Mapping Type") && prop.getValue() != null && !prop.getValue().toString().startsWith("Please select")) {
            Property[] children;
            delete.setEnabled(true);
            for (Property p : children = prop.getSubProperties()) {
                if (p.getDisplayName() == null || !p.getDisplayName().contains("Mapping Type") || p.getValue() != null && p.getValue().equals("Discrete Mapping")) continue;
                return;
            }
            VisualPropertyType type = (VisualPropertyType)((Object)prop.getHiddenObject());
            Class<?> dataType = type.getDataType();
            if (dataType == Color.class) {
                rainbow1.setEnabled(true);
                rainbow2.setEnabled(true);
                randomize.setEnabled(true);
                brighter.setEnabled(true);
                darker.setEnabled(true);
            } else if (dataType == Number.class) {
                randomize.setEnabled(true);
                series.setEnabled(true);
            }
            if (type == VisualPropertyType.NODE_WIDTH || type == VisualPropertyType.NODE_HEIGHT) {
                fit.setEnabled(true);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.ignore) {
            return;
        }
        String currentName = this.vmm.getVisualStyle().getName();
        Object selected = this.vsNameComboBox.getSelectedItem();
        if (selected != null && selected.toString().equals(currentName)) {
            return;
        }
        if (!this.findVSName(currentName)) {
            this.syncStyleBox();
        } else {
            this.vsNameComboBox.setSelectedItem(currentName);
        }
        this.lastVSName = currentName;
    }

    private void syncStyleBox() {
        String curStyleName = this.vmm.getVisualStyle().getName();
        CalculatorCatalog catalog = this.vmm.getCalculatorCatalog();
        ArrayList<String> namesInBox = new ArrayList<String>();
        namesInBox.addAll(catalog.getVisualStyleNames());
        for (int i = 0; i < this.vsNameComboBox.getItemCount(); ++i) {
            String styleName = this.vsNameComboBox.getItemAt(i).toString();
            if (catalog.getVisualStyle(styleName) != null) continue;
            this.vsNameComboBox.removeItem(styleName);
            this.defaultImageManager.remove(styleName);
            this.propertyMap.remove(styleName);
        }
        Collections.sort(namesInBox);
        this.vsNameComboBox.removeAllItems();
        for (String name : namesInBox) {
            this.vsNameComboBox.addItem(name);
        }
        this.switchVS(curStyleName);
    }

    private boolean findVSName(String match) {
        for (int i = 0; i < this.vsNameComboBox.getItemCount(); ++i) {
            if (!this.vsNameComboBox.getItemAt(i).equals(match)) continue;
            return true;
        }
        return false;
    }

    public Object getSelectedItem() {
        PropertySheetTable table = this.visualPropertySheetPanel.getTable();
        return table.getModel().getValueAt(table.getSelectedRow(), 0);
    }

    @Override
    public void attributeDefined(String attributeName) {
        this.setAttrComboBox();
    }

    @Override
    public void attributeUndefined(String attributeName) {
        this.setAttrComboBox();
    }

    static {
        optionIcon = new ImageIcon(Cytoscape.class.getResource("/cytoscape/images/ximian/stock_form-properties.png"));
        delIcon = new ImageIcon(Cytoscape.class.getResource("/cytoscape/images/ximian/stock_delete-16.png"));
        addIcon = new ImageIcon(Cytoscape.class.getResource("/cytoscape/images/ximian/stock_data-new-table-16.png"));
        rndIcon = new ImageIcon(Cytoscape.class.getResource("/cytoscape/images/ximian/stock_filters-16.png"));
        renameIcon = new ImageIcon(Cytoscape.class.getResource("/cytoscape/images/ximian/stock_redo-16.png"));
        duplicateIcon = new ImageIcon(Cytoscape.class.getResource("/cytoscape/images/ximian/stock_slide-duplicate.png"));
        legendIcon = new ImageIcon(Cytoscape.class.getResource("/cytoscape/images/ximian/stock_graphic-styles-16.png"));
        editIcon = new ImageIcon(Cytoscape.class.getResource("/cytoscape/images/ximian/stock_edit-16.png"));
    }

    private class BrightnessListener
    extends AbstractAction {
        private DiscreteMapping dm;
        protected static final int DARKER = 1;
        protected static final int BRIGHTER = 2;
        private final int functionType;

        public BrightnessListener(int type) {
            this.functionType = type;
        }

        public void actionPerformed(ActionEvent e) {
            int selectedRow = VizMapperMainPanel.this.visualPropertySheetPanel.getTable().getSelectedRow();
            if (selectedRow < 0) {
                return;
            }
            PropertySheetTableModel.Item item = (PropertySheetTableModel.Item)VizMapperMainPanel.this.visualPropertySheetPanel.getTable().getValueAt(selectedRow, 0);
            VizMapperProperty prop = (VizMapperProperty)item.getProperty();
            Object hidden = prop.getHiddenObject();
            if (hidden instanceof VisualPropertyType) {
                boolean nOre;
                ObjectMapping oMap;
                CyAttributes attr;
                VisualPropertyType type = (VisualPropertyType)((Object)hidden);
                HashMap<Object, Color> valueMap = new HashMap<Object, Color>();
                if (type.isNodeProp()) {
                    attr = Cytoscape.getNodeAttributes();
                    oMap = VizMapperMainPanel.this.vmm.getVisualStyle().getNodeAppearanceCalculator().getCalculator(type).getMapping(0);
                    nOre = true;
                } else {
                    attr = Cytoscape.getEdgeAttributes();
                    oMap = VizMapperMainPanel.this.vmm.getVisualStyle().getEdgeAppearanceCalculator().getCalculator(type).getMapping(0);
                    nOre = false;
                }
                if (!(oMap instanceof DiscreteMapping)) {
                    return;
                }
                this.dm = (DiscreteMapping)oMap;
                Set<Object> attrSet = MappingKeyFactory.getKeySet(oMap.getControllingAttributeName(), attr, oMap, nOre);
                if (type.getDataType() == Color.class) {
                    Object c;
                    if (this.functionType == 2) {
                        for (Object key : attrSet) {
                            c = this.dm.getMapValue(key);
                            if (c == null || !(c instanceof Color)) continue;
                            valueMap.put(key, ((Color)c).brighter());
                        }
                    } else if (this.functionType == 1) {
                        for (Object key : attrSet) {
                            c = this.dm.getMapValue(key);
                            if (c == null || !(c instanceof Color)) continue;
                            valueMap.put(key, ((Color)c).darker());
                        }
                    }
                }
                this.dm.putAll(valueMap);
                VizMapperMainPanel.this.vmm.setNetworkView(Cytoscape.getCurrentNetworkView());
                Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
                VizMapperMainPanel.this.visualPropertySheetPanel.removeProperty(prop);
                VizMapperProperty newRootProp = new VizMapperProperty();
                if (type.isNodeProp()) {
                    VizMapperMainPanel.this.buildProperty(VizMapperMainPanel.this.vmm.getVisualStyle().getNodeAppearanceCalculator().getCalculator(type), newRootProp, VizMapperMainPanel.NODE_VISUAL_MAPPING);
                } else {
                    VizMapperMainPanel.this.buildProperty(VizMapperMainPanel.this.vmm.getVisualStyle().getEdgeAppearanceCalculator().getCalculator(type), newRootProp, VizMapperMainPanel.EDGE_VISUAL_MAPPING);
                }
                VizMapperMainPanel.this.removeProperty(prop);
                ((List)VizMapperMainPanel.this.propertyMap.get(VizMapperMainPanel.this.vmm.getVisualStyle().getName())).add(newRootProp);
                VizMapperMainPanel.this.expandLastSelectedItem(type.getName());
            } else {
                VizMapperMainPanel.this.logger.info("Invalid.");
            }
        }
    }

    private class FitLabelListener
    extends AbstractAction {
        private DiscreteMapping dm;

        private FitLabelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int selectedRow = VizMapperMainPanel.this.visualPropertySheetPanel.getTable().getSelectedRow();
            if (selectedRow < 0) {
                return;
            }
            PropertySheetTableModel.Item item = (PropertySheetTableModel.Item)VizMapperMainPanel.this.visualPropertySheetPanel.getTable().getValueAt(selectedRow, 0);
            VizMapperProperty prop = (VizMapperProperty)item.getProperty();
            Object hidden = prop.getHiddenObject();
            if (hidden instanceof VisualPropertyType) {
                Set<Object> attrSet1;
                ObjectMapping oMap;
                CyAttributes attr;
                VisualPropertyType type = (VisualPropertyType)((Object)hidden);
                HashMap<Object, Double> valueMap = new HashMap<Object, Double>();
                if (type.isNodeProp()) {
                    attr = Cytoscape.getNodeAttributes();
                    oMap = VizMapperMainPanel.this.vmm.getVisualStyle().getNodeAppearanceCalculator().getCalculator(type).getMapping(0);
                } else {
                    attr = Cytoscape.getEdgeAttributes();
                    oMap = VizMapperMainPanel.this.vmm.getVisualStyle().getEdgeAppearanceCalculator().getCalculator(type).getMapping(0);
                }
                if (!(oMap instanceof DiscreteMapping)) {
                    return;
                }
                this.dm = (DiscreteMapping)oMap;
                Calculator nodeLabelCalc = VizMapperMainPanel.this.vmm.getVisualStyle().getNodeAppearanceCalculator().getCalculator(VisualPropertyType.NODE_LABEL);
                if (nodeLabelCalc == null) {
                    return;
                }
                String ctrAttrName = nodeLabelCalc.getMapping(0).getControllingAttributeName();
                this.dm.setControllingAttributeName(ctrAttrName);
                if (VizMapperMainPanel.this.vmm.getVisualStyle().getDependency().check(VisualPropertyDependency.Definition.NODE_SIZE_LOCKED)) {
                    return;
                }
                DiscreteMapping wm = null;
                if (type == VisualPropertyType.NODE_WIDTH) {
                    wm = (DiscreteMapping)VizMapperMainPanel.this.vmm.getVisualStyle().getNodeAppearanceCalculator().getCalculator(VisualPropertyType.NODE_WIDTH).getMapping(0);
                    wm.setControllingAttributeName(ctrAttrName);
                    if (ctrAttrName.equals("ID")) {
                        attrSet1 = new TreeSet();
                        for (Object node : Cytoscape.getCurrentNetwork().nodesList()) {
                            attrSet1.add(((Node)node).getIdentifier());
                        }
                    } else {
                        attrSet1 = MappingKeyFactory.getKeySet(wm.getControllingAttributeName(), attr, wm, true);
                    }
                    Integer height = ((Number)VizMapperMainPanel.this.vmm.getVisualStyle().getNodeAppearanceCalculator().getDefaultAppearance().get(VisualPropertyType.NODE_FONT_SIZE)).intValue();
                    VizMapperMainPanel.this.vmm.getVisualStyle().getNodeAppearanceCalculator().getDefaultAppearance().set(VisualPropertyType.NODE_HEIGHT, (double)height.intValue() * 2.5);
                    Integer fontSize = ((Number)VizMapperMainPanel.this.vmm.getVisualStyle().getNodeAppearanceCalculator().getDefaultAppearance().get(VisualPropertyType.NODE_FONT_SIZE)).intValue();
                    String labelString = null;
                    int longest = 0;
                    if (attr.getType(ctrAttrName) == -2) {
                        wm.setControllingAttributeName("ID");
                        attrSet1 = new TreeSet();
                        for (Object node : Cytoscape.getCurrentNetwork().nodesList()) {
                            attrSet1.add(((Node)node).getIdentifier());
                        }
                        CyNetworkView net = Cytoscape.getCurrentNetworkView();
                        for (Object node : net.getNetwork().nodesList()) {
                            String text = net.getNodeView((Node)node).getLabel().getText();
                            int strLen = text.length();
                            if (strLen == 0) continue;
                            String[] listObj = text.split("\\n");
                            longest = 0;
                            for (String s : listObj) {
                                if (s.length() <= longest) continue;
                                longest = s.length();
                            }
                            strLen = longest;
                            if (strLen > 25) {
                                valueMap.put(((Node)node).getIdentifier(), (double)(strLen * fontSize) * 0.6);
                                continue;
                            }
                            valueMap.put(((Node)node).getIdentifier(), (double)(strLen * fontSize) * 0.8);
                        }
                    } else {
                        for (Object label : attrSet1) {
                            labelString = label.toString();
                            int strLen = labelString.length();
                            if (strLen == 0) continue;
                            if (labelString.contains("\n")) {
                                String[] listObj = labelString.split("\\n");
                                longest = 0;
                                for (String s : listObj) {
                                    if (s.length() <= longest) continue;
                                    longest = s.length();
                                }
                                strLen = longest;
                            }
                            if (strLen > 25) {
                                valueMap.put(label, (double)(strLen * fontSize) * 0.6);
                                continue;
                            }
                            valueMap.put(label, (double)(strLen * fontSize) * 0.8);
                        }
                    }
                } else if (type == VisualPropertyType.NODE_HEIGHT) {
                    wm = (DiscreteMapping)VizMapperMainPanel.this.vmm.getVisualStyle().getNodeAppearanceCalculator().getCalculator(VisualPropertyType.NODE_HEIGHT).getMapping(0);
                    wm.setControllingAttributeName(ctrAttrName);
                    if (ctrAttrName.equals("ID")) {
                        attrSet1 = new TreeSet();
                        for (Object node : Cytoscape.getCurrentNetwork().nodesList()) {
                            attrSet1.add(((Node)node).getIdentifier());
                        }
                    } else {
                        attrSet1 = MappingKeyFactory.getKeySet(wm.getControllingAttributeName(), attr, wm, true);
                    }
                    Integer fontSize = ((Number)VizMapperMainPanel.this.vmm.getVisualStyle().getNodeAppearanceCalculator().getDefaultAppearance().get(VisualPropertyType.NODE_FONT_SIZE)).intValue();
                    String labelString = null;
                    if (attr.getType(ctrAttrName) == -2) {
                        wm.setControllingAttributeName("ID");
                        attrSet1 = new TreeSet();
                        for (Object node : Cytoscape.getCurrentNetwork().nodesList()) {
                            attrSet1.add(((Node)node).getIdentifier());
                        }
                        CyNetworkView net = Cytoscape.getCurrentNetworkView();
                        for (Object node : net.getNetwork().nodesList()) {
                            String text = net.getNodeView((Node)node).getLabel().getText();
                            int strLen = text.length();
                            if (strLen == 0) continue;
                            String[] listObj = text.split("\\n");
                            valueMap.put(((Node)node).getIdentifier(), (double)(listObj.length * fontSize) * 1.6);
                        }
                    } else {
                        for (Object label : attrSet1) {
                            labelString = label.toString();
                            int strLen = labelString.length();
                            if (strLen == 0) continue;
                            if (labelString.contains("\n")) {
                                String[] listObj = labelString.split("\\n");
                                strLen = listObj.length;
                            } else {
                                strLen = 1;
                            }
                            valueMap.put(label, (double)(strLen * fontSize) * 1.6);
                        }
                    }
                }
                wm.putAll(valueMap);
                VizMapperMainPanel.this.vmm.setNetworkView(Cytoscape.getCurrentNetworkView());
                Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
                VizMapperMainPanel.this.visualPropertySheetPanel.removeProperty(prop);
                VizMapperProperty newRootProp = new VizMapperProperty();
                if (type.isNodeProp()) {
                    VizMapperMainPanel.this.buildProperty(VizMapperMainPanel.this.vmm.getVisualStyle().getNodeAppearanceCalculator().getCalculator(type), newRootProp, VizMapperMainPanel.NODE_VISUAL_MAPPING);
                } else {
                    VizMapperMainPanel.this.buildProperty(VizMapperMainPanel.this.vmm.getVisualStyle().getEdgeAppearanceCalculator().getCalculator(type), newRootProp, VizMapperMainPanel.EDGE_VISUAL_MAPPING);
                }
                VizMapperMainPanel.this.removeProperty(prop);
                ((List)VizMapperMainPanel.this.propertyMap.get(VizMapperMainPanel.this.vmm.getVisualStyle().getName())).add(newRootProp);
                VizMapperMainPanel.this.expandLastSelectedItem(type.getName());
            } else {
                VizMapperMainPanel.this.logger.info("Invalid.");
            }
        }
    }

    private class GenerateSeriesListener
    extends AbstractAction {
        private DiscreteMapping dm;

        private GenerateSeriesListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int selectedRow = VizMapperMainPanel.this.visualPropertySheetPanel.getTable().getSelectedRow();
            if (selectedRow < 0) {
                return;
            }
            PropertySheetTableModel.Item item = (PropertySheetTableModel.Item)VizMapperMainPanel.this.visualPropertySheetPanel.getTable().getValueAt(selectedRow, 0);
            VizMapperProperty prop = (VizMapperProperty)item.getProperty();
            Object hidden = prop.getHiddenObject();
            if (hidden instanceof VisualPropertyType) {
                Float st;
                Float inc;
                boolean isNode;
                ObjectMapping oMap;
                CyAttributes attr;
                VisualPropertyType type = (VisualPropertyType)((Object)hidden);
                HashMap<Object, Float> valueMap = new HashMap<Object, Float>();
                if (type.isNodeProp()) {
                    attr = Cytoscape.getNodeAttributes();
                    oMap = VizMapperMainPanel.this.vmm.getVisualStyle().getNodeAppearanceCalculator().getCalculator(type).getMapping(0);
                    isNode = true;
                } else {
                    attr = Cytoscape.getEdgeAttributes();
                    oMap = VizMapperMainPanel.this.vmm.getVisualStyle().getEdgeAppearanceCalculator().getCalculator(type).getMapping(0);
                    isNode = false;
                }
                if (!(oMap instanceof DiscreteMapping)) {
                    return;
                }
                this.dm = (DiscreteMapping)oMap;
                Set<Object> attrSet = MappingKeyFactory.getKeySet(oMap.getControllingAttributeName(), attr, oMap, isNode);
                String start = JOptionPane.showInputDialog(VizMapperMainPanel.this.visualPropertySheetPanel, "Please enter start value (1st number in the series)", "0");
                String increment = JOptionPane.showInputDialog(VizMapperMainPanel.this.visualPropertySheetPanel, "Please enter increment", "1");
                if (increment == null || start == null) {
                    return;
                }
                try {
                    inc = Float.valueOf(increment);
                    st = Float.valueOf(start);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(VizMapperMainPanel.this.visualPropertySheetPanel, "Start value and increment must be numeric values!", "Non-numeric input error", 0);
                    inc = null;
                    st = null;
                }
                if (inc == null || inc.floatValue() < 0.0f || st == null || st == null) {
                    return;
                }
                if (type.getDataType() == Number.class) {
                    for (Object key : attrSet) {
                        valueMap.put(key, st);
                        st = Float.valueOf(st.floatValue() + inc.floatValue());
                    }
                }
                this.dm.putAll(valueMap);
                VizMapperMainPanel.this.vmm.setNetworkView(Cytoscape.getCurrentNetworkView());
                Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
                VizMapperMainPanel.this.visualPropertySheetPanel.removeProperty(prop);
                VizMapperProperty newRootProp = new VizMapperProperty();
                if (type.isNodeProp()) {
                    VizMapperMainPanel.this.buildProperty(VizMapperMainPanel.this.vmm.getVisualStyle().getNodeAppearanceCalculator().getCalculator(type), newRootProp, VizMapperMainPanel.NODE_VISUAL_MAPPING);
                } else {
                    VizMapperMainPanel.this.buildProperty(VizMapperMainPanel.this.vmm.getVisualStyle().getEdgeAppearanceCalculator().getCalculator(type), newRootProp, VizMapperMainPanel.EDGE_VISUAL_MAPPING);
                }
                VizMapperMainPanel.this.removeProperty(prop);
                ((List)VizMapperMainPanel.this.propertyMap.get(VizMapperMainPanel.this.vmm.getVisualStyle().getName())).add(newRootProp);
                VizMapperMainPanel.this.expandLastSelectedItem(type.getName());
            } else {
                VizMapperMainPanel.this.logger.info("Invalid.");
            }
        }
    }

    private class GenerateValueListener
    extends AbstractAction {
        private static final long serialVersionUID = -4852790777403019117L;
        private static final int MAX_COLOR = 0x1000000;
        private DiscreteMapping dm;
        protected static final int RAINBOW1 = 1;
        protected static final int RAINBOW2 = 2;
        protected static final int RANDOM = 3;
        private final int functionType;

        public GenerateValueListener(int type) {
            this.functionType = type;
        }

        public void actionPerformed(ActionEvent e) {
            int selectedRow = VizMapperMainPanel.this.visualPropertySheetPanel.getTable().getSelectedRow();
            if (selectedRow < 0) {
                return;
            }
            PropertySheetTableModel.Item item = (PropertySheetTableModel.Item)VizMapperMainPanel.this.visualPropertySheetPanel.getTable().getValueAt(selectedRow, 0);
            VizMapperProperty prop = (VizMapperProperty)item.getProperty();
            Object hidden = prop.getHiddenObject();
            if (hidden instanceof VisualPropertyType) {
                boolean isNode;
                ObjectMapping oMap;
                CyAttributes attr;
                VisualPropertyType type = (VisualPropertyType)((Object)hidden);
                HashMap<Object, Serializable> valueMap = new HashMap<Object, Serializable>();
                long seed = System.currentTimeMillis();
                Random rand = new Random(seed);
                if (type.isNodeProp()) {
                    attr = Cytoscape.getNodeAttributes();
                    oMap = VizMapperMainPanel.this.vmm.getVisualStyle().getNodeAppearanceCalculator().getCalculator(type).getMapping(0);
                    isNode = true;
                } else {
                    attr = Cytoscape.getEdgeAttributes();
                    oMap = VizMapperMainPanel.this.vmm.getVisualStyle().getEdgeAppearanceCalculator().getCalculator(type).getMapping(0);
                    isNode = false;
                }
                if (!(oMap instanceof DiscreteMapping)) {
                    return;
                }
                this.dm = (DiscreteMapping)oMap;
                Set<Object> attrSet = MappingKeyFactory.getKeySet(oMap.getControllingAttributeName(), attr, oMap, isNode);
                if (attrSet.size() == 0) {
                    JOptionPane.showMessageDialog(panel, "No attribute value is available.", "Cannot generate values", 0);
                }
                float increment = 1.0f / ((Number)attrSet.size()).floatValue();
                float hue = 0.0f;
                float sat = 0.0f;
                float br = 0.0f;
                if (type.getDataType() == Color.class) {
                    int i = 0;
                    if (this.functionType == 1) {
                        for (Object key : attrSet) {
                            valueMap.put(key, new Color(Color.HSBtoRGB(hue += increment, 1.0f, 1.0f)));
                        }
                    } else if (this.functionType == 2) {
                        for (Object key : attrSet) {
                            sat = Math.abs(((Number)Math.cos((double)(8 * i) / (Math.PI * 2))).floatValue()) * 0.7f + 0.3f;
                            br = Math.abs(((Number)Math.sin((double)i / (Math.PI * 2) + 1.5707963267948966)).floatValue()) * 0.7f + 0.3f;
                            valueMap.put(key, new Color(Color.HSBtoRGB(hue += increment, sat, br)));
                            ++i;
                        }
                    } else {
                        for (Object key : attrSet) {
                            valueMap.put(key, new Color(((Number)Float.valueOf(rand.nextFloat() * 1.6777216E7f)).intValue()));
                        }
                    }
                } else if (type.getDataType() == Number.class && this.functionType == 3) {
                    String range = JOptionPane.showInputDialog(VizMapperMainPanel.this.visualPropertySheetPanel, "Please enter the value range (example: 30-100)", "Assign Random Numbers", -1);
                    String[] rangeVals = range.split("-");
                    if (rangeVals.length != 2) {
                        return;
                    }
                    Float min = Float.valueOf(rangeVals[0]);
                    Float max = Float.valueOf(rangeVals[1]);
                    Float valueRange = Float.valueOf(max.floatValue() - min.floatValue());
                    for (Object key : attrSet) {
                        valueMap.put(key, Float.valueOf(rand.nextFloat() * valueRange.floatValue() + min.floatValue()));
                    }
                }
                this.dm.putAll(valueMap);
                VizMapperMainPanel.this.vmm.setNetworkView(Cytoscape.getCurrentNetworkView());
                Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
                VizMapperMainPanel.this.visualPropertySheetPanel.removeProperty(prop);
                VizMapperProperty newRootProp = new VizMapperProperty();
                if (type.isNodeProp()) {
                    VizMapperMainPanel.this.buildProperty(VizMapperMainPanel.this.vmm.getVisualStyle().getNodeAppearanceCalculator().getCalculator(type), newRootProp, VizMapperMainPanel.NODE_VISUAL_MAPPING);
                } else {
                    VizMapperMainPanel.this.buildProperty(VizMapperMainPanel.this.vmm.getVisualStyle().getEdgeAppearanceCalculator().getCalculator(type), newRootProp, VizMapperMainPanel.EDGE_VISUAL_MAPPING);
                }
                VizMapperMainPanel.this.removeProperty(prop);
                ((List)VizMapperMainPanel.this.propertyMap.get(VizMapperMainPanel.this.vmm.getVisualStyle().getName())).add(newRootProp);
                VizMapperMainPanel.this.expandLastSelectedItem(type.getName());
            } else {
                VizMapperMainPanel.this.logger.info("Invalid.");
            }
        }
    }

    protected class CopyStyleListener
    extends AbstractAction {
        protected CopyStyleListener() {
        }

        public void actionPerformed(ActionEvent e) {
            VisualStyle currentStyle = VizMapperMainPanel.this.vmm.getVisualStyle();
            VisualStyle clone = null;
            try {
                clone = (VisualStyle)currentStyle.clone();
            }
            catch (CloneNotSupportedException exc) {
                VizMapperMainPanel.this.logger.warn("Clone not supported exception!");
            }
            String newName = VizMapperMainPanel.this.getStyleName(clone);
            if (newName == null || newName.trim().length() == 0) {
                return;
            }
            clone.setName(newName);
            VizMapperMainPanel.this.vmm.getCalculatorCatalog().addVisualStyle(clone);
            VizMapperMainPanel.this.vmm.setVisualStyle(clone);
            JPanel defPanel = DefaultAppearenceBuilder.getDefaultView(newName);
            DGraphView view = (DGraphView)((DefaultViewPanel)defPanel).getView();
            Dimension panelSize = VizMapperMainPanel.this.defaultAppearencePanel.getSize();
            if (view != null) {
                VizMapperMainPanel.this.logger.debug("Creating Default Image for new visual style " + newName);
                VizMapperMainPanel.this.updateDefaultImage(newName, view, panelSize);
                VizMapperMainPanel.this.setDefaultPanel((Image)VizMapperMainPanel.this.defaultImageManager.get(newName), false);
            }
            VizMapperMainPanel.this.vmm.setNetworkView(Cytoscape.getCurrentNetworkView());
            VizMapperMainPanel.this.switchVS(newName);
        }
    }

    private class RemoveStyleListener
    extends AbstractAction {
        private RemoveStyleListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (VizMapperMainPanel.this.vmm.getVisualStyle().getName().equals(VizMapperMainPanel.DEFAULT_VS_NAME)) {
                JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "You cannot delete default style.", "Cannot remove style!", 0);
                return;
            }
            String styleName = VizMapperMainPanel.this.vmm.getVisualStyle().getName();
            String checkString = "Are you sure you want to permanently delete the visual style '" + styleName + "'?";
            int ich = JOptionPane.showConfirmDialog(Cytoscape.getDesktop(), checkString, "Confirm Delete Style", 0);
            if (ich == 0) {
                CalculatorCatalog catalog = VizMapperMainPanel.this.vmm.getCalculatorCatalog();
                catalog.removeVisualStyle(styleName);
                VisualStyle currentStyle = catalog.getVisualStyle(VizMapperMainPanel.DEFAULT_VS_NAME);
                VizMapperMainPanel.this.vsNameComboBox.removeItem(styleName);
                VizMapperMainPanel.this.vsNameComboBox.setSelectedItem(currentStyle.getName());
                VizMapperMainPanel.this.switchVS(currentStyle.getName());
                VizMapperMainPanel.this.defaultImageManager.remove(styleName);
                VizMapperMainPanel.this.propertyMap.remove(styleName);
                VizMapperMainPanel.this.vmm.setVisualStyle(currentStyle);
                VizMapperMainPanel.this.vmm.getNetworkView().setVisualStyle(currentStyle.getName());
                Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
            }
        }
    }

    private class RenameStyleListener
    extends AbstractAction {
        private RenameStyleListener() {
        }

        public void actionPerformed(ActionEvent e) {
            VisualStyle currentStyle = VizMapperMainPanel.this.vmm.getVisualStyle();
            String oldName = currentStyle.getName();
            String name = VizMapperMainPanel.this.getStyleName(currentStyle);
            if (name == null) {
                return;
            }
            VizMapperMainPanel.this.lastVSName = name;
            Image img = (Image)VizMapperMainPanel.this.defaultImageManager.get(oldName);
            VizMapperMainPanel.this.defaultImageManager.put(name, img);
            VizMapperMainPanel.this.defaultImageManager.remove(oldName);
            currentStyle.setName(name);
            VizMapperMainPanel.this.vmm.getCalculatorCatalog().removeVisualStyle(oldName);
            VizMapperMainPanel.this.vmm.getCalculatorCatalog().addVisualStyle(currentStyle);
            VizMapperMainPanel.this.vmm.setVisualStyle(currentStyle);
            VizMapperMainPanel.this.vmm.getNetworkView().setVisualStyle(name);
            VizMapperMainPanel.this.vsNameComboBox.addItem(name);
            VizMapperMainPanel.this.vsNameComboBox.setSelectedItem(name);
            VizMapperMainPanel.this.vsNameComboBox.removeItem(oldName);
            List props = (List)VizMapperMainPanel.this.propertyMap.get(oldName);
            VizMapperMainPanel.this.propertyMap.put(name, props);
            VizMapperMainPanel.this.propertyMap.remove(oldName);
        }
    }

    private class NewStyleListener
    extends AbstractAction {
        private static final long serialVersionUID = -401235126133833279L;

        private NewStyleListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String name = VizMapperMainPanel.this.getStyleName(null);
            if (name == null) {
                return;
            }
            VisualStyle newStyle = new VisualStyle(name);
            ArrayList<Calculator> calcs = new ArrayList<Calculator>(VizMapperMainPanel.this.vmm.getCalculatorCatalog().getCalculators());
            Calculator dummy = (Calculator)calcs.get(0);
            newStyle.getNodeAppearanceCalculator().setCalculator(dummy);
            VizMapperMainPanel.this.vmm.getCalculatorCatalog().addVisualStyle(newStyle);
            VizMapperMainPanel.this.vmm.setVisualStyle(newStyle);
            Cytoscape.getCurrentNetworkView().setVisualStyle(newStyle.getName());
            VizMapperMainPanel.this.removeMapping(dummy.getVisualPropertyType());
            JPanel defPanel = DefaultAppearenceBuilder.getDefaultView(name);
            DGraphView view = (DGraphView)((DefaultViewPanel)defPanel).getView();
            Dimension panelSize = VizMapperMainPanel.this.defaultAppearencePanel.getSize();
            if (view != null) {
                VizMapperMainPanel.this.logger.debug("Creating Default Image for new visual style " + name);
                VizMapperMainPanel.this.updateDefaultImage(name, view, panelSize);
                VizMapperMainPanel.this.setDefaultPanel((Image)VizMapperMainPanel.this.defaultImageManager.get(name), false);
            }
            VizMapperMainPanel.this.vmm.setNetworkView(Cytoscape.getCurrentNetworkView());
            VizMapperMainPanel.this.switchVS(name);
        }
    }

    protected class CreateLegendListener
    extends AbstractAction {
        protected CreateLegendListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    LegendDialog ld = new LegendDialog(Cytoscape.getDesktop(), VizMapperMainPanel.this.vmm.getVisualStyle());
                    ld.setLocationRelativeTo(Cytoscape.getDesktop());
                    ld.setVisible(true);
                    return null;
                }
            };
            worker.start();
        }
    }

    class DefaultMouseListener
    extends MouseAdapter {
        DefaultMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                String targetName = VizMapperMainPanel.this.vmm.getVisualStyle().getName();
                DefaultViewPanel panel = (DefaultViewPanel)DefaultAppearenceBuilder.showDialog(Cytoscape.getDesktop());
                VizMapperMainPanel.this.updateDefaultImage(targetName, (DGraphView)panel.getView(), VizMapperMainPanel.this.defaultAppearencePanel.getSize());
                VizMapperMainPanel.this.setDefaultPanel((Image)VizMapperMainPanel.this.defaultImageManager.get(targetName), false);
                Cytoscape.getDesktop().repaint();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DefaultEditor {
        NODE,
        EDGE,
        GLOBAL;

    }
}

