/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.editors.continuous;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.attr.CountedIterator;
import cytoscape.data.attr.MultiHashMap;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class MinMaxDialog
extends JDialog {
    private static final long serialVersionUID = 7350824820761046009L;
    private static MinMaxDialog dialog;
    private Double min;
    private Double max;
    private CyAttributes attr;
    private String attrName;
    private JButton cancelButton;
    private JLabel maxLabel;
    private JTextField maxTextField;
    private JLabel minLabel;
    private JTextField minTextField;
    private JButton okButton;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JButton restoreButton;

    private MinMaxDialog(Frame parent, boolean modal, Double min, Double max, CyAttributes attr, String attrName) {
        super(parent, modal);
        this.min = min;
        this.max = max;
        this.attr = attr;
        this.attrName = attrName;
        this.initComponents();
        this.minTextField.setText(min.toString());
        this.maxTextField.setText(max.toString());
    }

    public static Double[] getMinMax(double min, double max, CyAttributes attr, String attrName) {
        Double[] minMax = new Double[2];
        dialog = new MinMaxDialog(Cytoscape.getDesktop(), true, min, max, attr, attrName);
        dialog.setLocationRelativeTo(Cytoscape.getDesktop());
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
        if (MinMaxDialog.dialog.min == null || MinMaxDialog.dialog.max == null) {
            return null;
        }
        minMax[0] = MinMaxDialog.dialog.min;
        minMax[1] = MinMaxDialog.dialog.max;
        return minMax;
    }

    private void initComponents() {
        this.minLabel = new JLabel();
        this.maxLabel = new JLabel();
        this.minTextField = new JTextField();
        this.maxTextField = new JTextField();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.restoreButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Set Range");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.minLabel.setFont(new Font("SansSerif", 1, 12));
        this.minLabel.setText("Min");
        this.maxLabel.setFont(new Font("SansSerif", 1, 12));
        this.maxLabel.setText("Max");
        this.okButton.setText("OK");
        this.okButton.setMargin(new Insets(2, 2, 2, 2));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MinMaxDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMargin(new Insets(2, 2, 2, 2));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MinMaxDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.restoreButton.setText("Restore");
        this.restoreButton.setToolTipText("Set range by current attribute's min and max.");
        this.restoreButton.setMargin(new Insets(2, 2, 2, 2));
        this.restoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MinMaxDialog.this.restoreButtonActionPerformed(evt);
            }
        });
        this.titlePanel.setBackground(new Color(255, 255, 255));
        this.titleLabel.setFont(new Font("SansSerif", 1, 14));
        this.titleLabel.setText("Set Value Range");
        GroupLayout titlePanelLayout = new GroupLayout(this.titlePanel);
        this.titlePanel.setLayout(titlePanelLayout);
        titlePanelLayout.setHorizontalGroup(titlePanelLayout.createParallelGroup(1).add(titlePanelLayout.createSequentialGroup().addContainerGap().add(this.titleLabel).addContainerGap(125, Short.MAX_VALUE)));
        titlePanelLayout.setVerticalGroup(titlePanelLayout.createParallelGroup(1).add(titlePanelLayout.createSequentialGroup().addContainerGap().add(this.titleLabel).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.titlePanel, -1, -1, Short.MAX_VALUE).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.minLabel, -2, 35, -2).add(this.maxLabel, -1, 35, Short.MAX_VALUE)).addPreferredGap(0).add(layout.createParallelGroup(1).add(this.minTextField, -1, 182, Short.MAX_VALUE).add(this.maxTextField, -1, 182, Short.MAX_VALUE)).addContainerGap()).add(2, layout.createSequentialGroup().addContainerGap(163, Short.MAX_VALUE).add(this.cancelButton).add(this.restoreButton).add(this.okButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.titlePanel, -2, -1, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.minLabel).add(this.minTextField, -2, 18, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.maxLabel).add(this.maxTextField, -2, 18, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.okButton).add(this.restoreButton).add(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        try {
            this.min = Double.valueOf(this.minTextField.getText());
            this.max = Double.valueOf(this.maxTextField.getText());
        }
        catch (NumberFormatException e) {
            this.min = null;
            this.max = null;
        }
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.min = null;
        this.max = null;
        this.dispose();
    }

    private void restoreButtonActionPerformed(ActionEvent evt) {
        MultiHashMap mhm = this.attr.getMultiHashMap();
        CountedIterator it = mhm.getObjectKeys(this.attrName);
        Double val = null;
        Double maxValue = Double.NEGATIVE_INFINITY;
        Double minValue = Double.POSITIVE_INFINITY;
        while (it.hasNext()) {
            Object key = it.next();
            try {
                val = Double.parseDouble(mhm.getAttributeValue(key.toString(), this.attrName, null).toString());
            }
            catch (NumberFormatException nfe) {
                continue;
            }
            if (val > maxValue) {
                maxValue = val;
            }
            if (!(val < minValue)) continue;
            minValue = val;
        }
        this.minTextField.setText(minValue.toString());
        this.maxTextField.setText(maxValue.toString());
    }
}

