/*
 * Decompiled with CFR 0.152.
 */
package ding.view;

import cytoscape.graph.fixed.FixedGraph;
import cytoscape.render.immed.EdgeAnchors;
import ding.view.DGraphView;
import ding.view.GraphViewEdgesSelectedEvent;
import ding.view.GraphViewEdgesUnselectedEvent;
import giny.model.Edge;
import giny.view.Bend;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.GraphViewChangeListener;
import giny.view.Label;
import giny.view.ObjectPosition;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

class DEdgeView
implements EdgeView,
Label,
Bend,
EdgeAnchors {
    static final float DEFAULT_ARROW_SIZE = 5.0f;
    static final Paint DEFAULT_ARROW_PAINT = Color.black;
    static final float DEFAULT_EDGE_THICKNESS = 1.0f;
    static final Stroke DEFAULT_EDGE_STROKE = new BasicStroke();
    static final Color DEFAULT_EDGE_PAINT = Color.black;
    static final String DEFAULT_LABEL_TEXT = "";
    static final Font DEFAULT_LABEL_FONT = new Font(null, 0, 1);
    static final Paint DEFAULT_LABEL_PAINT = Color.black;
    DGraphView m_view;
    final int m_inx;
    boolean m_selected;
    Paint m_unselectedPaint;
    Paint m_selectedPaint;
    Paint m_sourceUnselectedPaint;
    Paint m_sourceSelectedPaint;
    Paint m_targetUnselectedPaint;
    Paint m_targetSelectedPaint;
    int m_sourceEdgeEnd;
    int m_targetEdgeEnd;
    ArrayList m_anchors;
    int m_lineType;
    String m_toolTipText = null;

    DEdgeView(DGraphView view, int inx) {
        this.m_view = view;
        this.m_inx = ~inx;
        this.m_selected = false;
        this.m_unselectedPaint = this.m_view.m_edgeDetails.segmentPaint(this.m_inx);
        this.m_selectedPaint = Color.red;
        this.m_sourceUnselectedPaint = this.m_view.m_edgeDetails.sourceArrowPaint(this.m_inx);
        this.m_sourceSelectedPaint = Color.red;
        this.m_targetUnselectedPaint = this.m_view.m_edgeDetails.targetArrowPaint(this.m_inx);
        this.m_targetSelectedPaint = Color.red;
        this.m_sourceEdgeEnd = 0;
        this.m_targetEdgeEnd = 0;
        this.m_anchors = null;
        this.m_lineType = 2;
    }

    public int getGraphPerspectiveIndex() {
        return ~this.m_inx;
    }

    public int getRootGraphIndex() {
        return ~this.m_inx;
    }

    public Edge getEdge() {
        return this.m_view.getGraphPerspective().getEdge(~this.m_inx);
    }

    public GraphView getGraphView() {
        return this.m_view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeWidth(float width) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.m_view.m_edgeDetails.overrideSegmentThickness(this.m_inx, width);
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getStrokeWidth() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            return this.m_view.m_edgeDetails.segmentThickness(this.m_inx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStroke(Stroke stroke) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.m_view.m_edgeDetails.overrideSegmentStroke(this.m_inx, stroke);
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stroke getStroke() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            return this.m_view.m_edgeDetails.segmentStroke(this.m_inx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineType(int lineType) {
        if (lineType == 1 || lineType == 2) {
            Object object = this.m_view.m_lock;
            synchronized (object) {
                this.m_lineType = lineType;
                this.m_view.m_contentChanged = true;
            }
        } else {
            throw new IllegalArgumentException("unrecognized line type");
        }
    }

    public int getLineType() {
        return this.m_lineType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnselectedPaint(Paint paint) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (paint == null) {
                throw new NullPointerException("paint is null");
            }
            this.m_unselectedPaint = paint;
            if (!this.isSelected()) {
                this.m_view.m_edgeDetails.overrideSegmentPaint(this.m_inx, this.m_unselectedPaint);
                if (this.m_unselectedPaint instanceof Color) {
                    this.m_view.m_edgeDetails.overrideColorLowDetail(this.m_inx, (Color)this.m_unselectedPaint);
                }
                this.m_view.m_contentChanged = true;
            }
            this.setSourceEdgeEnd(this.m_sourceEdgeEnd);
            this.setTargetEdgeEnd(this.m_targetEdgeEnd);
        }
    }

    public Paint getUnselectedPaint() {
        return this.m_unselectedPaint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedPaint(Paint paint) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (paint == null) {
                throw new NullPointerException("paint is null");
            }
            this.m_selectedPaint = paint;
            if (this.isSelected()) {
                this.m_view.m_edgeDetails.overrideSegmentPaint(this.m_inx, this.m_selectedPaint);
                if (this.m_selectedPaint instanceof Color) {
                    this.m_view.m_edgeDetails.overrideColorLowDetail(this.m_inx, (Color)this.m_selectedPaint);
                }
                this.m_view.m_contentChanged = true;
            }
        }
    }

    public Paint getSelectedPaint() {
        return this.m_selectedPaint;
    }

    public Paint getSourceEdgeEndPaint() {
        return this.m_sourceUnselectedPaint;
    }

    public Paint getSourceEdgeEndSelectedPaint() {
        return this.m_sourceSelectedPaint;
    }

    public Paint getTargetEdgeEndPaint() {
        return this.m_targetUnselectedPaint;
    }

    public Paint getTargetEdgeEndSelectedPaint() {
        return this.m_targetSelectedPaint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceEdgeEndSelectedPaint(Paint paint) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (paint == null) {
                throw new NullPointerException("paint is null");
            }
            this.m_sourceSelectedPaint = paint;
            if (this.isSelected()) {
                this.m_view.m_edgeDetails.overrideSourceArrowPaint(this.m_inx, this.m_sourceSelectedPaint);
                this.m_view.m_contentChanged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetEdgeEndSelectedPaint(Paint paint) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (paint == null) {
                throw new NullPointerException("paint is null");
            }
            this.m_targetSelectedPaint = paint;
            if (this.isSelected()) {
                this.m_view.m_edgeDetails.overrideTargetArrowPaint(this.m_inx, this.m_targetSelectedPaint);
                this.m_view.m_contentChanged = true;
            }
        }
    }

    public void setSourceEdgeEndStrokePaint(Paint paint) {
    }

    public void setTargetEdgeEndStrokePaint(Paint paint) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceEdgeEndPaint(Paint paint) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (paint == null) {
                throw new NullPointerException("paint is null");
            }
            this.m_sourceUnselectedPaint = paint;
            if (!this.isSelected()) {
                this.m_view.m_edgeDetails.overrideSourceArrowPaint(this.m_inx, this.m_sourceUnselectedPaint);
                this.m_view.m_contentChanged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetEdgeEndPaint(Paint paint) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (paint == null) {
                throw new NullPointerException("paint is null");
            }
            this.m_targetUnselectedPaint = paint;
            if (!this.isSelected()) {
                this.m_view.m_edgeDetails.overrideTargetArrowPaint(this.m_inx, this.m_targetUnselectedPaint);
                this.m_view.m_contentChanged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select() {
        GraphViewChangeListener listener;
        boolean somethingChanged;
        Object object = this.m_view.m_lock;
        synchronized (object) {
            somethingChanged = this.selectInternal(true);
            if (somethingChanged) {
                this.m_view.m_contentChanged = true;
            }
        }
        if (somethingChanged && (listener = this.m_view.m_lis[0]) != null) {
            listener.graphViewChanged(new GraphViewEdgesSelectedEvent(this.m_view, new int[]{~this.m_inx}));
        }
    }

    boolean selectInternal(boolean selectAnchors) {
        if (this.m_selected) {
            return false;
        }
        this.m_selected = true;
        this.m_view.m_edgeDetails.overrideSegmentPaint(this.m_inx, this.m_selectedPaint);
        this.m_view.m_edgeDetails.overrideSourceArrowPaint(this.m_inx, this.m_sourceSelectedPaint);
        this.m_view.m_edgeDetails.overrideTargetArrowPaint(this.m_inx, this.m_targetSelectedPaint);
        if (this.m_selectedPaint instanceof Color) {
            this.m_view.m_edgeDetails.overrideColorLowDetail(this.m_inx, (Color)this.m_selectedPaint);
        }
        this.m_view.m_selectedEdges.insert(this.m_inx);
        for (int j = 0; j < this.numHandles(); ++j) {
            this.getHandleInternal(j, this.m_view.m_anchorsBuff);
            this.m_view.m_spacialA.insert(this.m_inx << 6 | j, (float)((double)this.m_view.m_anchorsBuff[0] - (double)this.m_view.getAnchorSize() / 2.0), (float)((double)this.m_view.m_anchorsBuff[1] - (double)this.m_view.getAnchorSize() / 2.0), (float)((double)this.m_view.m_anchorsBuff[0] + (double)this.m_view.getAnchorSize() / 2.0), (float)((double)this.m_view.m_anchorsBuff[1] + (double)this.m_view.getAnchorSize() / 2.0));
            if (!selectAnchors) continue;
            this.m_view.m_selectedAnchors.insert(this.m_inx << 6 | j);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselect() {
        GraphViewChangeListener listener;
        boolean somethingChanged;
        Object object = this.m_view.m_lock;
        synchronized (object) {
            somethingChanged = this.unselectInternal();
            if (somethingChanged) {
                this.m_view.m_contentChanged = true;
            }
        }
        if (somethingChanged && (listener = this.m_view.m_lis[0]) != null) {
            listener.graphViewChanged(new GraphViewEdgesUnselectedEvent(this.m_view, new int[]{~this.m_inx}));
        }
    }

    boolean unselectInternal() {
        if (!this.m_selected) {
            return false;
        }
        this.m_selected = false;
        this.m_view.m_edgeDetails.overrideSegmentPaint(this.m_inx, this.m_unselectedPaint);
        this.m_view.m_edgeDetails.overrideSourceArrowPaint(this.m_inx, this.m_sourceUnselectedPaint);
        this.m_view.m_edgeDetails.overrideTargetArrowPaint(this.m_inx, this.m_targetUnselectedPaint);
        if (this.m_unselectedPaint instanceof Color) {
            this.m_view.m_edgeDetails.overrideColorLowDetail(this.m_inx, (Color)this.m_unselectedPaint);
        }
        this.m_view.m_selectedEdges.delete(this.m_inx);
        for (int j = 0; j < this.numHandles(); ++j) {
            this.m_view.m_selectedAnchors.delete(this.m_inx << 6 | j);
            this.m_view.m_spacialA.delete(this.m_inx << 6 | j);
        }
        return true;
    }

    public boolean setSelected(boolean state) {
        if (state) {
            this.select();
        } else {
            this.unselect();
        }
        return true;
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public boolean getSelected() {
        return this.m_selected;
    }

    public void updateEdgeView() {
    }

    public void updateTargetArrow() {
    }

    public void updateSourceArrow() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceEdgeEnd(int type) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            switch (type) {
                case 0: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-1);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-8);
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-3);
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-4);
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-5);
                    break;
                }
                case 17: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-7);
                    break;
                }
                case 16: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-6);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unrecognized edge end type");
                }
            }
            this.m_sourceEdgeEnd = type;
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetEdgeEnd(int type) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            switch (type) {
                case 0: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-1);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-8);
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-3);
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-4);
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-5);
                    break;
                }
                case 17: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-7);
                    break;
                }
                case 16: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-6);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unrecognized edge end type");
                }
            }
            this.m_targetEdgeEnd = type;
            this.m_view.m_contentChanged = true;
        }
    }

    public int getSourceEdgeEnd() {
        return this.m_sourceEdgeEnd;
    }

    public int getTargetEdgeEnd() {
        return this.m_targetEdgeEnd;
    }

    public void updateLine() {
    }

    public void drawSelected() {
        this.select();
    }

    public void drawUnselected() {
        this.unselect();
    }

    public Bend getBend() {
        return this;
    }

    public void clearBends() {
        this.removeAllHandles();
    }

    public Label getLabel() {
        return this;
    }

    public void setToolTip(String tip) {
        this.m_toolTipText = tip;
    }

    public String getToolTip() {
        return this.m_toolTipText;
    }

    public void setPositionHint(int position) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Paint getTextPaint() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            return this.m_view.m_edgeDetails.labelPaint(this.m_inx, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextPaint(Paint textPaint) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.m_view.m_edgeDetails.overrideLabelPaint(this.m_inx, 0, textPaint);
            this.m_view.m_contentChanged = true;
        }
    }

    public double getGreekThreshold() {
        return 0.0;
    }

    public void setGreekThreshold(double threshold) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            return this.m_view.m_edgeDetails.labelText(this.m_inx, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.m_view.m_edgeDetails.overrideLabelText(this.m_inx, 0, text);
            if (DEFAULT_LABEL_TEXT.equals(this.m_view.m_edgeDetails.labelText(this.m_inx, 0))) {
                this.m_view.m_edgeDetails.overrideLabelCount(this.m_inx, 0);
            } else {
                this.m_view.m_edgeDetails.overrideLabelCount(this.m_inx, 1);
            }
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            return this.m_view.m_edgeDetails.labelFont(this.m_inx, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(Font font) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.m_view.m_edgeDetails.overrideLabelFont(this.m_inx, 0, font);
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numHandles() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (this.m_anchors == null) {
                return 0;
            }
            return this.m_anchors.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHandles(List bendPoints) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.removeAllHandles();
            for (int i = 0; i < bendPoints.size(); ++i) {
                Point2D nextPt = (Point2D)bendPoints.get(i);
                this.addHandle(i, nextPt);
            }
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getHandles() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            ArrayList<Point2D.Float> returnThis = new ArrayList<Point2D.Float>();
            if (this.m_anchors == null) {
                return returnThis;
            }
            for (int i = 0; i < this.m_anchors.size(); ++i) {
                Point2D.Float addThis = new Point2D.Float();
                addThis.setLocation((Point2D)this.m_anchors.get(i));
                returnThis.add(addThis);
            }
            return returnThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveHandle(int inx, Point2D pt) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.moveHandleInternal(inx, pt.getX(), pt.getY());
            this.m_view.m_contentChanged = true;
        }
    }

    final void moveHandleInternal(int inx, double x, double y) {
        Point2D movePt = (Point2D)this.m_anchors.get(inx);
        movePt.setLocation(x, y);
        if (this.m_view.m_spacialA.delete(this.m_inx << 6 | inx)) {
            this.m_view.m_spacialA.insert(this.m_inx << 6 | inx, (float)(x - (double)this.m_view.getAnchorSize() / 2.0), (float)(y - (double)this.m_view.getAnchorSize() / 2.0), (float)(x + (double)this.m_view.getAnchorSize() / 2.0), (float)(y + (double)this.m_view.getAnchorSize() / 2.0));
        }
    }

    final void getHandleInternal(int inx, float[] buff) {
        Point2D.Float pt = (Point2D.Float)this.m_anchors.get(inx);
        buff[0] = pt.x;
        buff[1] = pt.y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point2D getSourceHandlePoint() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (this.m_anchors == null || this.m_anchors.size() == 0) {
                return null;
            }
            Point2D.Float returnThis = new Point2D.Float();
            returnThis.setLocation((Point2D)this.m_anchors.get(0));
            return returnThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point2D getTargetHandlePoint() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (this.m_anchors == null || this.m_anchors.size() == 0) {
                return null;
            }
            Point2D.Float returnThis = new Point2D.Float();
            returnThis.setLocation((Point2D)this.m_anchors.get(this.m_anchors.size() - 1));
            return returnThis;
        }
    }

    public void addHandle(Point2D pt) {
        this.addHandleFoo(pt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addHandleFoo(Point2D pt) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (this.m_anchors == null || this.m_anchors.size() == 0) {
                this.addHandle(0, pt);
                return 0;
            }
            Point2D sourcePt = this.m_view.getNodeView(~((FixedGraph)((Object)this.m_view.m_structPersp)).edgeSource(this.m_inx)).getOffset();
            Point2D targetPt = this.m_view.getNodeView(~((FixedGraph)((Object)this.m_view.m_structPersp)).edgeTarget(this.m_inx)).getOffset();
            double bestDist = pt.distance(sourcePt) + pt.distance((Point2D)this.m_anchors.get(0)) - sourcePt.distance((Point2D)this.m_anchors.get(0));
            int bestInx = 0;
            for (int i = 1; i < this.m_anchors.size(); ++i) {
                double distCand = pt.distance((Point2D)this.m_anchors.get(i - 1)) + pt.distance((Point2D)this.m_anchors.get(i)) - ((Point2D)this.m_anchors.get(i)).distance((Point2D)this.m_anchors.get(i - 1));
                if (!(distCand < bestDist)) continue;
                bestDist = distCand;
                bestInx = i;
            }
            double lastCand = pt.distance(targetPt) + pt.distance((Point2D)this.m_anchors.get(this.m_anchors.size() - 1)) - targetPt.distance((Point2D)this.m_anchors.get(this.m_anchors.size() - 1));
            if (lastCand < bestDist) {
                bestDist = lastCand;
                bestInx = this.m_anchors.size();
            }
            this.addHandle(bestInx, pt);
            return bestInx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandle(int insertInx, Point2D pt) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            Point2D.Float addThis = new Point2D.Float();
            addThis.setLocation(pt);
            if (this.m_anchors == null) {
                this.m_anchors = new ArrayList();
            }
            this.m_anchors.add(insertInx, addThis);
            if (this.m_selected) {
                for (int j = this.m_anchors.size() - 1; j > insertInx; --j) {
                    this.m_view.m_spacialA.exists(this.m_inx << 6 | j - 1, this.m_view.m_extentsBuff, 0);
                    this.m_view.m_spacialA.delete(this.m_inx << 6 | j - 1);
                    this.m_view.m_spacialA.insert(this.m_inx << 6 | j, this.m_view.m_extentsBuff[0], this.m_view.m_extentsBuff[1], this.m_view.m_extentsBuff[2], this.m_view.m_extentsBuff[3]);
                    if (!this.m_view.m_selectedAnchors.delete(this.m_inx << 6 | j - 1)) continue;
                    this.m_view.m_selectedAnchors.insert(this.m_inx << 6 | j);
                }
                this.m_view.m_spacialA.insert(this.m_inx << 6 | insertInx, (float)((double)addThis.x - (double)this.m_view.getAnchorSize() / 2.0), (float)((double)addThis.y - (double)this.m_view.getAnchorSize() / 2.0), (float)((double)addThis.x + (double)this.m_view.getAnchorSize() / 2.0), (float)((double)addThis.y + (double)this.m_view.getAnchorSize() / 2.0));
            }
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandle(Point2D pt) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            float x = (float)pt.getX();
            float y = (float)pt.getY();
            if (this.m_anchors == null) {
                return;
            }
            for (int i = 0; i < this.m_anchors.size(); ++i) {
                Point2D.Float currPt = (Point2D.Float)this.m_anchors.get(i);
                if (x != currPt.x || y != currPt.y) continue;
                this.removeHandle(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandle(int inx) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.m_anchors.remove(inx);
            if (this.m_selected) {
                this.m_view.m_spacialA.delete(this.m_inx << 6 | inx);
                this.m_view.m_selectedAnchors.delete(this.m_inx << 6 | inx);
                for (int j = inx; j < this.m_anchors.size(); ++j) {
                    this.m_view.m_spacialA.exists(this.m_inx << 6 | j + 1, this.m_view.m_extentsBuff, 0);
                    this.m_view.m_spacialA.delete(this.m_inx << 6 | j + 1);
                    this.m_view.m_spacialA.insert(this.m_inx << 6 | j, this.m_view.m_extentsBuff[0], this.m_view.m_extentsBuff[1], this.m_view.m_extentsBuff[2], this.m_view.m_extentsBuff[3]);
                    if (!this.m_view.m_selectedAnchors.delete(this.m_inx << 6 | j + 1)) continue;
                    this.m_view.m_selectedAnchors.insert(this.m_inx << 6 | j);
                }
            }
            if (this.m_anchors.size() == 0) {
                this.m_anchors = null;
            }
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllHandles() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (this.m_anchors == null) {
                return;
            }
            if (this.m_selected) {
                for (int j = 0; j < this.m_anchors.size(); ++j) {
                    this.m_view.m_spacialA.delete(this.m_inx << 6 | j);
                    this.m_view.m_selectedAnchors.delete(this.m_inx << 6 | j);
                }
            }
            this.m_anchors = null;
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleAlreadyExists(Point2D pt) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            float x = (float)pt.getX();
            float y = (float)pt.getY();
            if (this.m_anchors == null) {
                return false;
            }
            for (int i = 0; i < this.m_anchors.size(); ++i) {
                Point2D.Float currPt = (Point2D.Float)this.m_anchors.get(i);
                if (x != currPt.x || y != currPt.y) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point2D[] getDrawPoints() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            Point2D[] returnThis = new Point2D[this.m_anchors == null ? 0 : this.m_anchors.size()];
            for (int i = 0; i < returnThis.length; ++i) {
                returnThis[i] = new Point2D.Float();
                returnThis[i].setLocation((Point2D)this.m_anchors.get(i));
            }
            return returnThis;
        }
    }

    public int numAnchors() {
        if (this.m_anchors == null) {
            return 0;
        }
        if (this.m_lineType == 1) {
            return this.m_anchors.size();
        }
        return 2 * this.m_anchors.size();
    }

    public void getAnchor(int anchorIndex, float[] anchorArr, int offset) {
        Point2D.Float anchor = this.m_lineType == 1 ? (Point2D.Float)this.m_anchors.get(anchorIndex) : (Point2D.Float)this.m_anchors.get(anchorIndex / 2);
        anchorArr[offset] = anchor.x;
        anchorArr[offset + 1] = anchor.y;
    }

    public void setTextAnchor(int position) {
        System.out.println("setTextAnchor");
    }

    public void setJustify(int justify) {
        System.out.println("setJustify");
    }

    public int getTextAnchor() {
        System.out.println("getTextAnchor");
        return 0;
    }

    public int getJustify() {
        System.out.println("getJustify");
        return 0;
    }

    public void setLabelOffsetX(double x) {
        System.out.println("setLabelOffsetX");
    }

    public void setLabelOffsetY(double y) {
        System.out.println("setLabelOffsetY");
    }

    public void setEdgeLabelAnchor(int position) {
        System.out.println("setEdgeLabelAnchor");
    }

    public double getLabelOffsetX() {
        System.out.println("getLabelOffsetX");
        return 0.0;
    }

    public double getLabelOffsetY() {
        System.out.println("getLabelOffsetY");
        return 0.0;
    }

    public int getEdgeLabelAnchor() {
        System.out.println("getEdgeLabelAnchor");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabelWidth(double width) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.m_view.m_edgeDetails.overrideLabelWidth(this.m_inx, width);
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLabelWidth() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            return this.m_view.m_edgeDetails.labelWidth(this.m_inx);
        }
    }

    public ObjectPosition getPosition() {
        return null;
    }

    public void setPosition(ObjectPosition arg0) {
    }
}

