/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class PDebug {
    public static boolean debugRegionManagement = false;
    public static boolean debugPaintCalls = false;
    public static boolean debugPrintFrameRate = false;
    public static boolean debugPrintUsedMemory = false;
    public static boolean debugBounds = false;
    public static boolean debugFullBounds = false;
    public static int printResultsFrameRate = 10;
    private static int debugPaintColor;
    private static long framesProcessed;
    private static long startProcessingOutputTime;
    private static long startProcessingInputTime;
    private static long processOutputTime;
    private static long processInputTime;
    private static boolean processingOutput;

    private PDebug() {
    }

    public static Color getDebugPaintColor() {
        int n = 100 + debugPaintColor++ % 10 * 10;
        return new Color(n, n, n, 150);
    }

    public static void processRepaint() {
        if (processingOutput && debugPaintCalls) {
            System.err.println("Got repaint while painting scene. This can result in a recursive process that degrades performance.");
        }
    }

    public static void startProcessingOutput() {
        processingOutput = true;
        startProcessingOutputTime = System.currentTimeMillis();
    }

    public static void endProcessingOutput(Graphics graphics) {
        processOutputTime += System.currentTimeMillis() - startProcessingOutputTime;
        if (debugPrintFrameRate && ++framesProcessed % (long)printResultsFrameRate == 0L) {
            System.out.println("Process output frame rate: " + PDebug.getOutputFPS() + " fps");
            System.out.println("Process input frame rate: " + PDebug.getInputFPS() + " fps");
            System.out.println("Total frame rate: " + PDebug.getTotalFPS() + " fps");
            System.out.println();
            PDebug.resetFPSTiming();
        }
        if (debugPrintUsedMemory && framesProcessed % (long)printResultsFrameRate == 0L) {
            System.out.println("Approximate used memory: " + PDebug.getApproximateUsedMemory() / 1024L + " k");
        }
        if (debugRegionManagement) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.setColor(PDebug.getDebugPaintColor());
            graphics2D.fill(graphics.getClipBounds().getBounds2D());
        }
        processingOutput = false;
    }

    public static void startProcessingInput() {
        startProcessingInputTime = System.currentTimeMillis();
    }

    public static void endProcessingInput() {
        processInputTime += System.currentTimeMillis() - startProcessingInputTime;
    }

    public static double getTotalFPS() {
        if (framesProcessed > 0L) {
            return 1000.0 / ((double)(processInputTime + processOutputTime) / (double)framesProcessed);
        }
        return 0.0;
    }

    public static double getInputFPS() {
        if (processInputTime > 0L && framesProcessed > 0L) {
            return 1000.0 / ((double)processInputTime / (double)framesProcessed);
        }
        return 0.0;
    }

    public static double getOutputFPS() {
        if (processOutputTime > 0L && framesProcessed > 0L) {
            return 1000.0 / ((double)processOutputTime / (double)framesProcessed);
        }
        return 0.0;
    }

    public long getFramesProcessed() {
        return framesProcessed;
    }

    public static void resetFPSTiming() {
        framesProcessed = 0L;
        processInputTime = 0L;
        processOutputTime = 0L;
    }

    public static long getApproximateUsedMemory() {
        System.gc();
        System.runFinalization();
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        return l - l2;
    }
}

