/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.Application;
import jas.util.HelpException;
import jas.util.HelpInterface;
import java.awt.Dialog;
import java.awt.Window;
import java.net.URL;
import java.util.Enumeration;
import javax.help.DefaultHelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.Map;
import javax.swing.SwingUtilities;

class HelpInterfaceImpl
implements HelpInterface {
    private HelpSet mainHS;
    private DefaultHelpBroker mainHB;
    private final boolean debugHelp = System.getProperty("debugHelp") != null;

    HelpInterfaceImpl() throws HelpException {
        this.createHelpSet();
    }

    public void showHelpTopic(String helpTopicTarget, Window owner) {
        this.showHelpTopic(helpTopicTarget, "TOC", owner);
    }

    public void showHelpTopic(String helpTopicTarget, String navigatorView, Window owner) {
        try {
            Map.ID id = Map.ID.create(helpTopicTarget, this.mainHS);
            if (id == null) {
                id = this.mainHS.getHomeID();
            }
            this.mainHB.setActivationWindow(owner);
            this.mainHB.setCurrentView(navigatorView);
            this.mainHB.setCurrentID(id);
            this.mainHB.setDisplayed(true);
        }
        catch (Exception eek) {
            Application.getApplication().error("Sorry, the help topic could not be found.");
        }
    }

    public void modalDialogOpening(final Dialog dlg) {
        if (this.debugHelp) {
            System.out.println("modelDialogOpening " + this.mainHB.isDisplayed());
        }
        if (this.mainHB.isDisplayed()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HelpInterfaceImpl.this.mainHB.setActivationWindow(dlg);
                    HelpInterfaceImpl.this.mainHB.setDisplayed(true);
                }
            });
        }
    }

    public void modalDialogClosing(Dialog dlg) {
        if (this.debugHelp) {
            System.out.println("modelDialogClosing " + this.mainHB.isDisplayed());
        }
        this.mainHB.setActivationWindow(null);
    }

    private void createHelpSet() throws HelpException {
        Enumeration e = Application.getApplication().getHelpLocations();
        while (e.hasMoreElements()) {
            try {
                URL u = (URL)e.nextElement();
                if (this.debugHelp) {
                    System.out.print("Looking for hs at: " + u + " ... ");
                }
                this.mainHS = new HelpSet(null, u);
                if (!this.debugHelp) break;
                System.out.println("Success");
                break;
            }
            catch (HelpSetException e1) {
                if (!this.debugHelp) continue;
                System.out.println("Failed");
            }
        }
        if (this.mainHS == null) {
            throw new HelpException("No HelpSet found");
        }
        try {
            this.mainHB = (DefaultHelpBroker)this.mainHS.createHelpBroker();
        }
        catch (Throwable x) {
            throw new HelpException("Could not create Help Broker", x);
        }
    }
}

