/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class SymbolListCharSequence
implements CharSequence {
    private SymbolList syms;
    private Map alphaTokens;

    public SymbolListCharSequence(SymbolList syms) {
        FiniteAlphabet alphabet = (FiniteAlphabet)syms.getAlphabet();
        if (!(alphabet instanceof FiniteAlphabet)) {
            throw new IllegalArgumentException("Only SymbolLists using a FiniteAlphabet are supported by SymbolListCharSequence");
        }
        SymbolTokenization sToke = this.getTokenizer(alphabet, "token");
        if (sToke == null) {
            sToke = this.getTokenizer(alphabet, "unicode");
        }
        if (sToke == null) {
            throw new BioError("unable to get a character tokenization for alphabet " + alphabet.getName());
        }
        this.syms = syms;
        this.alphaTokens = new HashMap(Math.round((float)alphabet.size() / 0.75f) + 1);
        try {
            Iterator si = AlphabetManager.getAllSymbols(alphabet).iterator();
            while (si.hasNext()) {
                Symbol s = (Symbol)si.next();
                char symChar = sToke.tokenizeSymbol(s).charAt(0);
                this.alphaTokens.put(s, new Character(symChar));
            }
        }
        catch (IllegalSymbolException ise) {
            throw new BioError("Internal error: failed to tokenize a Symbol from an existing SymbolList", ise);
        }
    }

    private SymbolTokenization getTokenizer(FiniteAlphabet alphabet, String tokenType) {
        SymbolTokenization sToke = null;
        try {
            sToke = alphabet.getTokenization(tokenType);
        }
        catch (BioException be) {
            return null;
        }
        if (sToke.getTokenType() != SymbolTokenization.CHARACTER) {
            return null;
        }
        return sToke;
    }

    private SymbolListCharSequence(SymbolList syms, Map alphaTokens) {
        this.syms = syms;
        this.alphaTokens = alphaTokens;
    }

    public char charAt(int index) {
        return ((Character)this.alphaTokens.get(this.syms.symbolAt(index + 1))).charValue();
    }

    public int length() {
        return this.syms.length();
    }

    public CharSequence subSequence(int start, int end) {
        return new SymbolListCharSequence(this.syms.subList(start + 1, end), this.alphaTokens);
    }

    public String toString() {
        return this.syms.seqString();
    }
}

