/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.directory;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.directory.ProviderNotFoundException;
import org.biojava.directory.RegistryConfiguration;
import org.biojava.directory.RegistryException;
import org.biojava.directory.SequenceDBProvider;
import org.biojava.utils.ClassTools;
import org.biojava.utils.Services;

public class Registry {
    private RegistryConfiguration regConfig = null;

    public Registry(RegistryConfiguration regConfig) {
        this.regConfig = regConfig;
    }

    public SequenceDBLite getDatabase(String dbName) throws RegistryException, BioException {
        String providerName = "";
        List dbConfigs = (List)this.getRegistryConfiguration().getConfiguration().get(dbName);
        if (dbConfigs == null) {
            throw new RegistryException("Failed to find a configuration for database: " + dbName);
        }
        Iterator ci = dbConfigs.iterator();
        while (ci.hasNext()) {
            Map dbConfig = (Map)ci.next();
            providerName = (String)dbConfig.get("protocol");
            SequenceDBLite db = null;
            try {
                db = this.getProvider(providerName).getSequenceDB(dbConfig);
            }
            catch (RegistryException re) {
                continue;
            }
            catch (Exception e) {
                throw new RegistryException("Failed to configure database " + dbName);
            }
            if (db == null) continue;
            return db;
        }
        throw new RegistryException("Failed to find a configuration for database: " + dbName);
    }

    private SequenceDBProvider getProvider(String providerName) throws RegistryException {
        try {
            ClassLoader loader = ClassTools.getClassLoader(this);
            Iterator implNames = Services.getImplementationNames(SequenceDBProvider.class, loader).iterator();
            while (implNames.hasNext()) {
                String className = (String)implNames.next();
                try {
                    Class<?> clazz = loader.loadClass(className);
                    SequenceDBProvider seqDB = (SequenceDBProvider)clazz.newInstance();
                    if (!seqDB.getName().equals(providerName)) continue;
                    return seqDB;
                }
                catch (ClassNotFoundException ce) {
                    throw new RegistryException("Could not find class: " + className + " for service provider " + providerName, ce);
                }
            }
            throw new ProviderNotFoundException("No such provider exists: " + providerName);
        }
        catch (Exception e) {
            throw new RegistryException("Error accessing SequenceDBProvider services", e);
        }
    }

    public RegistryConfiguration getRegistryConfiguration() {
        return this.regConfig;
    }
}

