/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import java.util.List;
import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class ListToString
extends AbstractFunction {
    public ListToString() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.STRICT_ANY_LIST, "list", "Any list."), new ArgDescriptor(ArgType.STRING, "separator", "The text that will be inserted between the individual list elements.")});
    }

    public String getName() {
        return "LISTTOSTRING";
    }

    public String getFunctionSummary() {
        return "Converts a list to a string, given a separator.";
    }

    public Class getReturnType() {
        return String.class;
    }

    public Object evaluateFunction(Object[] args) {
        List list = (List)args[0];
        String separator = FunctionUtil.getArgAsString(args[1]);
        StringBuilder result = new StringBuilder();
        int count = 0;
        for (Object listEntry : list) {
            result.append(listEntry.toString());
            if (++count >= list.size()) continue;
            result.append(separator);
        }
        return result.toString();
    }
}

