/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.parse_tree;

import java.util.Stack;
import org.cytoscape.equations.CodeAndSourceLocation;
import org.cytoscape.equations.Token;
import org.cytoscape.equations.interpreter.Instruction;
import org.cytoscape.equations.parse_tree.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnaryOpNode
extends Node {
    private final Token operator;
    private final Node operand;

    public UnaryOpNode(int sourceLocation, Token operator, Node operand) {
        super(sourceLocation);
        if (operand == null) {
            throw new IllegalArgumentException("operand must not be null!");
        }
        this.operator = operator;
        this.operand = operand;
    }

    @Override
    public String toString() {
        return "UnaryOpNode: " + (Object)((Object)this.operator);
    }

    @Override
    public Class getType() {
        return this.operand.getType();
    }

    @Override
    public Node getLeftChild() {
        return this.operand;
    }

    @Override
    public Node getRightChild() {
        return null;
    }

    public Token getOperator() {
        return this.operator;
    }

    @Override
    public void genCode(Stack<CodeAndSourceLocation> codeStack) {
        this.operand.genCode(codeStack);
        switch (this.operator) {
            case PLUS: {
                codeStack.push(new CodeAndSourceLocation((Object)Instruction.FUPLUS, this.getSourceLocation()));
                break;
            }
            case MINUS: {
                codeStack.push(new CodeAndSourceLocation((Object)Instruction.FUMINUS, this.getSourceLocation()));
                break;
            }
            default: {
                throw new IllegalStateException("invalid unary operation: " + (Object)((Object)this.operator) + "!");
            }
        }
    }
}

