## ----include = FALSE--------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    crop = NULL
    ## Related to
    ## https://stat.ethz.ch/pipermail/bioc-devel/2020-April/016656.html
)

## ----vignetteSetup, echo=FALSE, message=FALSE, warning = FALSE--------------------------------------------------------
## Bib setup
library("RefManageR")

## Write bibliography information
bib <- c(
    R = citation(),
    BiocStyle = citation("BiocStyle")[1],
    knitr = citation("knitr")[1],
    RefManageR = citation("RefManageR")[1],
    rmarkdown = citation("rmarkdown")[1],
    sessioninfo = citation("sessioninfo")[1],
    testthat = citation("testthat")[1],
    ISAnalytics = citation("ISAnalytics")[1],
    eulerr = citation("eulerr")[1]
)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
inst_chunk_path <- system.file("rmd", "install_and_options.Rmd", package = "ISAnalytics")

## ----include=FALSE----------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("ISAnalytics")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  
#  # The following initializes usage of Bioc devel
#  BiocManager::install(version='devel')
#  
#  BiocManager::install("ISAnalytics")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
#  if (!require(devtools)) {
#    install.packages("devtools")
#  }
#  devtools::install_github("calabrialab/ISAnalytics",
#                           ref = "RELEASE_3_14",
#                           dependencies = TRUE,
#                           build_vignettes = TRUE)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
#  if (!require(devtools)) {
#    install.packages("devtools")
#  }
#  devtools::install_github("calabrialab/ISAnalytics",
#                           ref = "master",
#                           dependencies = TRUE,
#                           build_vignettes = TRUE)

## ----OptVerbose, eval=FALSE-------------------------------------------------------------------------------------------
#  # DISABLE
#  options("ISAnalytics.verbose" = FALSE)
#  
#  # ENABLE
#  options("ISAnalytics.verbose" = TRUE)
#  

## ----OptWidg, eval=FALSE----------------------------------------------------------------------------------------------
#  # DISABLE HTML REPORTS
#  options("ISAnalytics.reports" = FALSE)
#  
#  # ENABLE HTML REPORTS
#  options("ISAnalytics.reports" = TRUE)

## ---------------------------------------------------------------------------------------------------------------------
library(ISAnalytics)
data("integration_matrices")
data("association_file")

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
print(head(integration_matrices))

## ---------------------------------------------------------------------------------------------------------------------
## Aggregation by standard key
agg <- aggregate_values_by_key(integration_matrices,
                               association_file,
                               value_cols = c("seqCount", "fragmentEstimate"))
agg <- agg %>% dplyr::filter(TimePoint %in% c("0030", "0060"))

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
print(agg, width = Inf)

## ---------------------------------------------------------------------------------------------------------------------
sharing_1 <- is_sharing(agg, 
                        group_key = c("SubjectID", "CellMarker", 
                                      "Tissue", "TimePoint"),
                        n_comp = 2,
                        is_count = TRUE,
                        relative_is_sharing = TRUE,
                        minimal = TRUE,
                        include_self_comp = FALSE, 
                        keep_genomic_coord = TRUE)
sharing_1

## ---------------------------------------------------------------------------------------------------------------------
sharing_1_a <- is_sharing(agg, 
                        group_key = c("SubjectID", "CellMarker", 
                                      "Tissue", "TimePoint"),
                        n_comp = 3,
                        is_count = TRUE,
                        relative_is_sharing = TRUE,
                        minimal = TRUE,
                        include_self_comp = FALSE, 
                        keep_genomic_coord = TRUE)
sharing_1_a

## ---------------------------------------------------------------------------------------------------------------------
sharing_1_b <- is_sharing(agg,
                          group_key = c("SubjectID", "CellMarker", 
                                      "Tissue", "TimePoint"),
                          n_comp = 2,
                          is_count = TRUE,
                          relative_is_sharing = TRUE,
                          minimal = FALSE,
                          include_self_comp = TRUE)
sharing_1_b
heatmaps <- sharing_heatmap(sharing_1_b)

## ---------------------------------------------------------------------------------------------------------------------
heatmaps$absolute
heatmaps$on_g1
heatmaps$on_union

## ---------------------------------------------------------------------------------------------------------------------
sharing_2 <- is_sharing(agg,
                        group_keys = list(
                          g1 = c("SubjectID", "CellMarker", 
                                 "Tissue", "TimePoint"),
                          g2 = c("SubjectID", "CellMarker"),
                          g3 = c("CellMarker", "Tissue")
                          ))
sharing_2

## ---------------------------------------------------------------------------------------------------------------------
first_sample <- agg %>%
  dplyr::filter(SubjectID == "PT001", CellMarker == "MNC", Tissue == "BM", 
         TimePoint == "0030")
second_sample <- agg %>%
  dplyr::filter(SubjectID == "PT001", CellMarker == "MNC", Tissue == "BM", 
         TimePoint == "0060")
sharing_3 <- is_sharing(first_sample, second_sample,
                        group_key = c("SubjectID", "CellMarker", 
                                      "Tissue", "TimePoint"),
                        is_count = TRUE,
                        relative_is_sharing = TRUE,
                        minimal = TRUE)
sharing_3

## ---------------------------------------------------------------------------------------------------------------------
df1 <- agg %>%
  dplyr::filter(TimePoint == "0030")
df2 <- agg %>%
  dplyr::filter(TimePoint == "0060")
df3 <- agg %>%
  dplyr::filter(Tissue == "BM")

keys <- list(g1 = c("SubjectID", "CellMarker", "Tissue"),
             g2 = c("SubjectID", "Tissue"),
             g3 = c("SubjectID", "CellMarker", "Tissue"))

sharing_4 <- is_sharing(df1, df2, df3, group_keys = keys)
sharing_4

## ---------------------------------------------------------------------------------------------------------------------
sharing_5 <- is_sharing(agg,
                        group_keys = list(
                          g1 = c("SubjectID", "CellMarker", 
                                 "Tissue", "TimePoint"),
                          g2 = c("SubjectID", "CellMarker"),
                          g3 = c("CellMarker", "Tissue")
                          ), table_for_venn = TRUE)
sharing_5

## ---------------------------------------------------------------------------------------------------------------------
sharing_plots1 <- sharing_venn(sharing_5, row_range = 1, euler = TRUE)
sharing_plots2 <- sharing_venn(sharing_5, row_range = 1, euler = FALSE)

## ---------------------------------------------------------------------------------------------------------------------
plot(sharing_plots1[[1]])
plot(sharing_plots2[[1]])

## ----reproduce3, echo=FALSE-------------------------------------------------------------------------------------------
## Session info
library("sessioninfo")
options(width = 120)
session_info()

## ----vignetteBiblio, results = "asis", echo = FALSE, warning = FALSE, message = FALSE---------------------------------
## Print bibliography
PrintBibliography(bib, .opts = list(hyperlink = "to.doc", style = "html"))

