## ----style, echo=FALSE, results='asis', message=FALSE-------------------------
BiocStyle::markdown()
knitr::opts_chunk$set(tidy         = FALSE,
                      message      = FALSE)


## ----setup--------------------------------------------------------------------
library(MungeSumstats)

## ---- eval=FALSE, message=TRUE------------------------------------------------
#  eduAttainOkbayPth <- system.file("extdata","eduAttainOkbay.txt",
#                                    package="MungeSumstats")
#  reformatted <-
#    MungeSumstats::format_sumstats(path=eduAttainOkbayPth,
#                                   ref_genome="GRCh37")

## ----echo=FALSE---------------------------------------------------------------
#don't run time intensive checks
eduAttainOkbayPth <- system.file("extdata","eduAttainOkbay.txt",
                                  package="MungeSumstats")
reformatted <- 
  MungeSumstats::format_sumstats(path=eduAttainOkbayPth,
                                 on_ref_genome = FALSE,
                                 strand_ambig_filter = FALSE,
                                 bi_allelic_filter = FALSE,
                                 allele_flip_check = FALSE,
                                 ref_genome="GRCh37")

## ---- message=TRUE------------------------------------------------------------
#save ALS GWAS from the ieu open GWAS project to a temp directory
ALSvcfPth <- system.file("extdata","ALSvcf.vcf", package="MungeSumstats")

## ----eval=FALSE---------------------------------------------------------------
#  #set a low INFO filter so we get a return
#  reformatted_vcf <-
#    MungeSumstats::format_sumstats(path=ALSvcfPth,
#                                   ref_genome="GRCh37",
#                                   INFO_filter=0.1)

## ---- eval=FALSE,message=FALSE------------------------------------------------
#  #set
#  reformatted_vcf_2 <-
#    MungeSumstats::format_sumstats(path=ALSvcfPth,
#                                   ref_genome="GRCh37",
#                                   INFO_filter = 0.1,
#                                   log_folder_ind=TRUE,
#                                   imputation_ind=TRUE,
#                                   log_mungesumstats_msgs=TRUE)

## ----echo=FALSE,message=FALSE-------------------------------------------------
#don't run time intensive checks
reformatted_vcf_2 <- 
  MungeSumstats::format_sumstats(path=ALSvcfPth,
                                 ref_genome="GRCh37",
                                 INFO_filter = 0.1,
                                 log_folder_ind=TRUE,
                                 imputation_ind=TRUE,
                                 log_mungesumstats_msgs=TRUE,
                                 on_ref_genome = FALSE,
                                 strand_ambig_filter = FALSE,
                                 bi_allelic_filter = FALSE,
                                 allele_flip_check = FALSE)

## ---- message=TRUE------------------------------------------------------------
names(reformatted_vcf_2)

## ---- message=TRUE------------------------------------------------------------
data.table::fread(reformatted_vcf_2$log_files$info_filter)[1:10]

## ---- message=FALSE,eval=FALSE------------------------------------------------
#  #set
#  reformatted_vcf_2 <-
#    MungeSumstats::format_sumstats(path=ALSvcfPth,
#                                   ref_genome="GRCh37",
#                                   INFO_filter = 0.1,
#                                   log_folder_ind=TRUE,
#                                   imputation_ind=TRUE,
#                                   log_mungesumstats_msgs=TRUE,
#                                   return_format="GRanges")

## ---- message=FALSE,eval=FALSE------------------------------------------------
#  # Pass path to Educational Attainment Okbay sumstat file to a temp directory
#  eduAttainOkbayPth <- system.file("extdata", "eduAttainOkbay.txt",
#                                    package = "MungeSumstats")
#  sumstats_list <- list(ss1 = eduAttainOkbayPth, ss2 = eduAttainOkbayPth)
#  
#  ref_genomes <- MungeSumstats::get_genome_builds(sumstats_list = sumstats_list)
#  

## ---- message=TRUE, echo=FALSE------------------------------------------------
utils::sessionInfo()

