/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.antimatter;

import edu.rit.clu.antimatter.AntiprotonFile;
import edu.rit.numeric.ListXYSeries;
import edu.rit.numeric.plot.Dots;
import edu.rit.numeric.plot.Plot;
import edu.rit.numeric.plot.Strokes;
import edu.rit.vector.Vector2D;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class AntiprotonPlot {
    static Vector2D[] p;
    static int N;
    static Vector2D totalMV;
    static ListXYSeries pFinal;
    static ListXYSeries pTrack;

    private AntiprotonPlot() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        if (stringArray.length < 1) {
            AntiprotonPlot.usage();
        }
        AntiprotonFile antiprotonFile = new AntiprotonFile();
        AntiprotonFile.Reader reader = antiprotonFile.prepareToRead(new BufferedInputStream(new FileInputStream(stringArray[0])));
        N = antiprotonFile.getN();
        p = new Vector2D[N];
        for (n = 0; n < N; ++n) {
            AntiprotonPlot.p[n] = new Vector2D();
        }
        AntiprotonPlot.readFile(antiprotonFile, reader);
        for (n = 1; n < stringArray.length; ++n) {
            reader = antiprotonFile.prepareToRead(new BufferedInputStream(new FileInputStream(stringArray[n])));
            AntiprotonPlot.readFile(antiprotonFile, reader);
        }
        for (n = 0; n < N; ++n) {
            pFinal.add(AntiprotonPlot.p[n].x, AntiprotonPlot.p[n].y);
        }
        Plot plot = new Plot().seriesDots(null).seriesStroke(Strokes.solid(1.0)).xySeries(pTrack).seriesDots(Dots.circle()).seriesStroke(null).xySeries(pFinal).leftMargin(24.0).bottomMargin(24.0).topMargin(12.0).rightMargin(12.0).majorGridLines(false);
        plot.getFrame().setVisible(true);
    }

    private static void readFile(AntiprotonFile antiprotonFile, AntiprotonFile.Reader reader) throws IOException {
        int n = antiprotonFile.getSnaps();
        int n2 = antiprotonFile.getL();
        int n3 = antiprotonFile.getM();
        boolean bl = n2 <= 0 && 0 < n2 + n3;
        for (int i = 0; i < n; ++i) {
            reader.readSnapshot(p, n2, totalMV);
            if (!bl) continue;
            pTrack.add(AntiprotonPlot.p[0].x, AntiprotonPlot.p[0].y);
        }
        reader.close();
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.clu.antimatter.AntiprotonPlot <file> [<file> ...]");
        System.exit(1);
    }

    static {
        totalMV = new Vector2D();
        pFinal = new ListXYSeries();
        pTrack = new ListXYSeries();
    }
}

