/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.phyl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaximumParsimonyResults
implements Iterable<int[]>,
Externalizable {
    private static final int PAD = 32;
    private int[][] treeList;
    private int size;
    private int capacity;
    private int score;
    private int modCount;
    private static long p0;
    private static long p1;
    private static long p2;
    private static long p3;
    private static long p4;
    private static long p5;
    private static long p6;
    private static long p7;
    private static long p8;
    private static long p9;
    private static long pa;
    private static long pb;
    private static long pc;
    private static long pd;
    private static long pe;
    private static long pf;

    public MaximumParsimonyResults() {
    }

    public MaximumParsimonyResults(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("MaximumParsimonyResults(): capacity (= " + n + ") illegal");
        }
        this.size = 0;
        this.capacity = n;
        this.treeList = new int[n + 32][];
        this.score = Integer.MAX_VALUE;
    }

    public MaximumParsimonyResults(MaximumParsimonyResults maximumParsimonyResults) {
        this.size = maximumParsimonyResults.size;
        this.capacity = maximumParsimonyResults.capacity;
        this.treeList = new int[maximumParsimonyResults.capacity + 32][];
        for (int i = 0; i < maximumParsimonyResults.size; ++i) {
            this.treeList[i] = (int[])maximumParsimonyResults.treeList[i].clone();
        }
        this.score = maximumParsimonyResults.score;
    }

    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.treeList[i] = null;
        }
        this.size = 0;
        this.score = Integer.MAX_VALUE;
    }

    public void add(int[] nArray, int n) {
        ++this.modCount;
        if (n < this.score) {
            this.clear();
            this.score = n;
        }
        if (n == this.score && this.size < this.capacity) {
            this.treeList[this.size] = (int[])nArray.clone();
            ++this.size;
        }
    }

    public void addAll(MaximumParsimonyResults maximumParsimonyResults) {
        ++this.modCount;
        if (maximumParsimonyResults.score < this.score) {
            this.clear();
            this.score = maximumParsimonyResults.score;
        }
        if (maximumParsimonyResults.score == this.score) {
            for (int i = 0; this.size < this.capacity && i < maximumParsimonyResults.size; ++i) {
                this.treeList[this.size] = (int[])maximumParsimonyResults.treeList[i].clone();
                ++this.size;
            }
        }
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public int[] tree(int n) {
        if (0 > n || n >= this.size) {
            throw new IndexOutOfBoundsException("MaximumParsimonyScore.tree(): i (= " + n + ") out of bounds");
        }
        return this.treeList[n];
    }

    public int score() {
        return this.score;
    }

    public void score(int n) {
        this.score = n;
    }

    public void reduceScore(int n) {
        if (this.score > n) {
            this.clear();
            this.score = n;
        }
    }

    @Override
    public Iterator<int[]> iterator() {
        return new Iterator<int[]>(){
            private int originalModCount;
            private int i;
            {
                this.originalModCount = MaximumParsimonyResults.this.modCount;
            }

            @Override
            public boolean hasNext() {
                if (MaximumParsimonyResults.this.modCount != this.originalModCount) {
                    throw new ConcurrentModificationException();
                }
                return this.i < MaximumParsimonyResults.this.size;
            }

            @Override
            public int[] next() {
                if (MaximumParsimonyResults.this.modCount != this.originalModCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.i >= MaximumParsimonyResults.this.size) {
                    throw new NoSuchElementException();
                }
                return MaximumParsimonyResults.this.treeList[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.size);
        objectOutput.writeInt(this.capacity);
        objectOutput.writeInt(this.score);
        for (int i = 0; i < this.size; ++i) {
            int[] nArray = this.treeList[i];
            int n = nArray.length;
            objectOutput.writeInt(n);
            for (int j = 0; j < n; ++j) {
                objectOutput.writeInt(nArray[j]);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.size = objectInput.readInt();
        this.capacity = objectInput.readInt();
        this.score = objectInput.readInt();
        this.treeList = new int[this.capacity + 32][];
        for (int i = 0; i < this.size; ++i) {
            int n = objectInput.readInt();
            int[] nArray = new int[n];
            this.treeList[i] = nArray;
            for (int j = 0; j < n; ++j) {
                nArray[j] = objectInput.readInt();
            }
        }
    }
}

