/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.item.Size;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Point
implements Externalizable {
    private static final long serialVersionUID = 1961120380735433588L;
    double x;
    double y;

    public Point() {
    }

    public Point(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Point(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public Point add(double d, double d2) {
        return new Point(this.x + d, this.y + d2);
    }

    public Point add(Size size) {
        return new Point(this.x + size.width, this.y + size.height);
    }

    public Point sub(double d, double d2) {
        return new Point(this.x - d, this.y - d2);
    }

    public Point sub(Size size) {
        return new Point(this.x - size.width, this.y - size.height);
    }

    public Size difference(Point point) {
        return new Size(this.x - point.x, this.y - point.y);
    }

    public Size absDifference(Point point) {
        return new Size(Math.abs(this.x - point.x), Math.abs(this.y - point.y));
    }

    public Point max(Point point) {
        return new Point(Math.max(this.x, point.x), Math.max(this.y, point.y));
    }

    public Point min(Point point) {
        return new Point(Math.min(this.x, point.x), Math.min(this.y, point.y));
    }

    public Point n(double d) {
        return new Point(this.x, this.y - d);
    }

    public Point s(double d) {
        return new Point(this.x, this.y + d);
    }

    public Point e(double d) {
        return new Point(this.x + d, this.y);
    }

    public Point w(double d) {
        return new Point(this.x - d, this.y);
    }

    public Point n(Size size) {
        return new Point(this.x, this.y - size.height);
    }

    public Point s(Size size) {
        return new Point(this.x, this.y + size.height);
    }

    public Point e(Size size) {
        return new Point(this.x + size.width, this.y);
    }

    public Point w(Size size) {
        return new Point(this.x - size.width, this.y);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Point)) {
            return false;
        }
        Point point = (Point)object;
        return this.x == point.x && this.y == point.y;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.y);
        return (int)(l >>> 32) + (int)l + (int)(l2 >>> 32) + (int)l2;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }
}

