/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.LongBuf;
import edu.rit.mp.buf.LongMatrixReductionBuf;
import edu.rit.pj.reduction.LongOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;

public class LongMatrixBuf
extends LongBuf {
    long[][] myMatrix;
    Range myRowRange;
    Range myColRange;
    int myLowerRow;
    int myRowCount;
    int myRowStride;
    int myLowerCol;
    int myColCount;
    int myColStride;

    public LongMatrixBuf(long[][] lArray, Range range, Range range2) {
        super(range.length() * range2.length());
        this.myMatrix = lArray;
        this.myRowRange = range;
        this.myColRange = range2;
        this.myLowerRow = range.lb();
        this.myRowCount = range.length();
        this.myRowStride = range.stride();
        this.myLowerCol = range2.lb();
        this.myColCount = range2.length();
        this.myColStride = range2.stride();
    }

    public long get(int n) {
        return this.myMatrix[this.i2r(n) * this.myRowStride + this.myLowerRow][this.i2c(n) * this.myColStride + this.myLowerCol];
    }

    public void put(int n, long l) {
        this.myMatrix[this.i2r((int)n) * this.myRowStride + this.myLowerRow][this.i2c((int)n) * this.myColStride + this.myLowerCol] = l;
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof LongMatrixBuf) {
                LongMatrixBuf longMatrixBuf = (LongMatrixBuf)buf;
                Arrays.copy(longMatrixBuf.myMatrix, longMatrixBuf.myRowRange, longMatrixBuf.myColRange, this.myMatrix, this.myRowRange, this.myColRange);
            } else {
                LongBuf.defaultCopy((LongBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        return new LongMatrixReductionBuf(this.myMatrix, this.myRowRange, this.myColRange, (LongOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        int n2 = 0;
        int n3 = this.i2r(n);
        int n4 = n3 * this.myRowStride + this.myLowerRow;
        int n5 = this.i2c(n);
        int n6 = n5 * this.myColStride + this.myLowerCol;
        int n7 = Math.min(this.myColCount - n5, longBuffer.remaining());
        while (n3 < this.myRowCount && n7 > 0) {
            long[] lArray = this.myMatrix[n4];
            while (n5 < n7) {
                longBuffer.put(lArray[n6]);
                ++n5;
                n6 += this.myColStride;
            }
            n2 += n7;
            ++n3;
            n4 += this.myRowStride;
            n5 = 0;
            n6 = this.myLowerCol;
            n7 = Math.min(this.myColCount, longBuffer.remaining());
        }
        byteBuffer.position(byteBuffer.position() + 8 * n2);
        return n2;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        n2 = Math.min(n2, longBuffer.remaining());
        int n3 = 0;
        int n4 = this.i2r(n);
        int n5 = n4 * this.myRowStride + this.myLowerRow;
        int n6 = this.i2c(n);
        int n7 = n6 * this.myColStride + this.myLowerCol;
        int n8 = Math.min(this.myColCount - n6, n2);
        while (n4 < this.myRowCount && n8 > 0) {
            long[] lArray = this.myMatrix[n5];
            for (n6 = 0; n6 < n8; ++n6) {
                lArray[n7] = longBuffer.get();
                n7 += this.myColStride;
            }
            n3 += n8;
            ++n4;
            n5 += this.myRowStride;
            n7 = this.myLowerCol;
            n8 = Math.min(this.myColCount, n2 -= n8);
        }
        byteBuffer.position(byteBuffer.position() + 8 * n3);
        return n3;
    }

    int i2r(int n) {
        return this.myColCount == 0 ? n : n / this.myColCount;
    }

    int i2c(int n) {
        return this.myColCount == 0 ? 0 : n % this.myColCount;
    }
}

