/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.SharedFloatArrayBuf;
import edu.rit.pj.reduction.FloatOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedFloatArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class SharedFloatArrayReductionBuf
extends SharedFloatArrayBuf {
    FloatOp myOp;

    public SharedFloatArrayReductionBuf(SharedFloatArray sharedFloatArray, Range range, FloatOp floatOp) {
        super(sharedFloatArray, range);
        if (floatOp == null) {
            throw new NullPointerException("SharedFloatArrayReductionBuf(): op is null");
        }
        this.myOp = floatOp;
    }

    public void put(int n, float f) {
        this.myArray.reduce(this.myArrayOffset + n * this.myStride, f, this.myOp);
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n;
        int n4 = this.myArrayOffset + n * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        while (n3 < n5 && byteBuffer.remaining() >= 4) {
            this.myArray.reduce(n4, byteBuffer.getFloat(), this.myOp);
            ++n3;
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

