/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri;

import edu.rit.mri.PixelSignal;
import edu.rit.numeric.ArraySeries;
import edu.rit.numeric.Series;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SignalDataSetReader {
    private RandomAccessFile myFile;
    private int H;
    private int W;
    private int P;
    private int M;
    private Series t_series;

    public SignalDataSetReader(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("SignalDataSetReader(): theFile is null");
        }
        this.myFile = new RandomAccessFile(file, "r");
        this.H = this.myFile.readInt();
        this.W = this.myFile.readInt();
        this.P = this.H * this.W;
        this.myFile.seek(8L + (long)this.P * 8L);
        this.M = this.myFile.readShort();
        double[] dArray = new double[this.M];
        for (int i = 0; i < this.M; ++i) {
            dArray[i] = this.myFile.readDouble();
        }
        this.t_series = new ArraySeries(dArray);
    }

    public int getHeight() {
        return this.H;
    }

    public int getWidth() {
        return this.W;
    }

    public int getPixelCount() {
        return this.P;
    }

    public int indexFor(int n, int n2) {
        if (0 > n || n >= this.H) {
            throw new IndexOutOfBoundsException("SignalDataSetReader.indexFor(): r (= " + n + ") out of bounds");
        }
        if (0 > n2 || n2 >= this.W) {
            throw new IndexOutOfBoundsException("SignalDataSetReader.indexFor(): c (= " + n2 + ") out of bounds");
        }
        return n * this.W + n2;
    }

    public int rowFor(int n) {
        if (0 > n || n >= this.P) {
            throw new IndexOutOfBoundsException("SignalDataSetReader.rowFor(): i (= " + n + ") out of bounds");
        }
        return n / this.W;
    }

    public int columnFor(int n) {
        if (0 > n || n >= this.P) {
            throw new IndexOutOfBoundsException("SignalDataSetReader.columnFor(): i (= " + n + ") out of bounds");
        }
        return n % this.W;
    }

    public Series getTimeSeries() {
        return this.t_series;
    }

    public PixelSignal getPixelSignal(int n) throws IOException {
        if (0 > n || n >= this.P) {
            throw new IndexOutOfBoundsException("SignalDataSetReader.getPixelSignal(): i (= " + n + ") out of bounds");
        }
        this.myFile.seek(8L + (long)n * 8L);
        long l = this.myFile.readLong();
        if (l == 0L) {
            return null;
        }
        this.myFile.seek(l);
        PixelSignal pixelSignal = new PixelSignal();
        pixelSignal.pixelIndex(n);
        pixelSignal.read(this.myFile);
        return pixelSignal;
    }

    public void close() throws IOException {
        this.myFile.close();
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

